﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using CTester.Setting;
using CTester.Command;
using Utility;

namespace CTester
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        // ----------------------------------------
        // メンバー列挙型
        // ----------------------------------------
        #region Enum Members
        #endregion

        // ----------------------------------------
        // メンバー定数
        // ----------------------------------------
        #region Class Const Members

        public readonly string AppSettingFolder = "CTester";

        #endregion

        // ----------------------------------------
        // フィールド
        // ----------------------------------------
        #region Fields

        private Project _project = new Project();

        #endregion

        // ----------------------------------------
        // コンストラクタ
        // ----------------------------------------
        #region Constructor

        public MainWindow()
        {
            InitializeComponent();

            _project.ChangedInfo += new EventHandler(_project_ChangedInfo);
            //_windowLayoutVM = new DynamicViewModel(_windowLayout);
        }


        #endregion

        // ----------------------------------------
        // メソッド
        // ----------------------------------------
        #region Methods


        #endregion

        // ----------------------------------------
        // イベントハンドラ
        // ----------------------------------------
        #region Event Handlers

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            string path = string.Empty;

            // ドキュメントシリアライズデータロード
            //--------------------------------------------------------------
            path = System.IO.Path.Combine(
                Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData),
                AppSettingFolder,
                "DocSerializeData.xml");

            var data = (DocumentManager.SerializeData)Utility.Serializer.Deserialization(
                path,
                typeof(DocumentManager.SerializeData));

            DocumentManager.Instance.LoadSerializeData(data);

            // コマンドライン引数取得
            //---------------------------------------------
            string[] arges = System.Environment.GetCommandLineArgs();
            if (arges.Length >= 2)
            {
                path = arges[1];
                //_project.LoadProject(projectPath);
                _project.Load(path);
            }

            // 共通コマンドセット
            App.Commands.Add(new CommandNewProject(_project));
            App.Commands.Add(new CommandOpenProject(_project));
            App.Commands.Add(new CommandOpenSource(_project));
            App.Commands.Add(new CommandEmuSetting(_project));
            App.Commands.Add(new CommandClose(this));

            panelUnitTest.Initialize(_project);

            // メインウィンドウのコマンドバインド
            menuOpenSource.Command = App.Commands[typeof(CommandOpenSource)];
            menuAppExit.Command = App.Commands[typeof(CommandClose)];


            // Windowレイアウトバインディングセット
            // 直接xamlに書くと表示が見えないのでコードでバインディング記述。
            //--------------------------------------------------------------
            this.SetBinding(Window.WidthProperty, new Binding("Width") { Mode = BindingMode.TwoWay });
            this.SetBinding(Window.HeightProperty, new Binding("Height") { Mode = BindingMode.TwoWay });
            this.SetBinding(Window.WindowStateProperty, new Binding("WindowState") { Mode = BindingMode.TwoWay });
            this.SetBinding(Window.LeftProperty, new Binding("Left") { Mode = BindingMode.TwoWay });
            this.SetBinding(Window.TopProperty, new Binding("Top") { Mode = BindingMode.TwoWay });

            this.DataContext = DocumentManager.Instance.WindowsLayoutVM;
            //panelUnitTest.gridSplitter.SetBinding(GridSplitter.
        }

        void _project_ChangedInfo(object sender, EventArgs e)
        {
            this.Title = "CTester";
            if (_project.ProjectName != string.Empty)
            {
                this.Title = this.Title + "[" + _project.ProjectName + "]";
            }
        }

        #endregion

        private void menuHelp_Click(object sender, RoutedEventArgs e)
        {
            var helpUrl = "http://sourceforge.jp/projects/ctester/wiki/FrontPage";
            System.Diagnostics.Process.Start(helpUrl);
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            // ドキュメントシリアライスデータセーブ
            //--------------------------------------------------------------
            var dir = System.IO.Path.Combine(
                Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData),
                AppSettingFolder);
            var path = System.IO.Path.Combine(dir, "DocSerializeData.xml");

            if (!System.IO.Directory.Exists(dir))
            {
                System.IO.Directory.CreateDirectory(dir);
            }

            var data = DocumentManager.Instance.GetSerializeData();
            Utility.Serializer.Serialization(path, data);
        }

        private void menuVersion_Click(object sender, RoutedEventArgs e)
        {
            var dlg = new DialogVersion();
            dlg.ShowDialog();
        }
    }
}
