﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Collections.ObjectModel;
using System.ComponentModel;

namespace CTester.UnitTest
{
    public abstract class UTTreeBase : INotifyPropertyChanged
    {
        // ----------------------------------------
        // プロパティ
        // ----------------------------------------
        #region Properties

        public virtual ObservableCollection<UTTreeBase> Children
        {
            get;
            set;
        }

        protected string _title = string.Empty;
        public virtual string Title
        {
            get
            {
                return _title;
            }
            set
            {
                _title = value;
                OnPropertyChanged("Title");
            }
        }

        [XmlIgnoreAttribute]
        public Type ItemType
        {
            get { return this.GetType(); }
        }

        protected bool _isSelected = false;
        public bool IsSelected
        {
            get
            {
                return _isSelected;
            }


            set
            {
                _isSelected = value;
                this.OnPropertyChanged("IsSelected");
            }
        }

        protected bool _isExpaned = false;
        public bool IsExpanded
        {
            get
            {
                return _isExpaned;
            }
            set
            {
                _isExpaned = value;
                this.OnPropertyChanged("IsExpanded");
            }
        }

        #endregion

        // ----------------------------------------
        // INotifyPropertyChangedインターフェース
        // ----------------------------------------
        #region INotifyPropertyChanged InterFace

        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        // ----------------------------------------
        // メソッド
        // ----------------------------------------
        #region Methods


        #endregion
    }
}
