﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics.Contracts;

namespace Utility
{
    /// <summary>
    /// This attribute is used to indicate if a model property changes the value of another "derived" property.
    /// </summary>
    [AttributeUsage(AttributeTargets.Property, AllowMultiple = true)]
    public sealed class AffectsOtherPropertyAttribute : Attribute
    {

        /// <summary>
        /// Creates a new attribute that indicates which property this property affects.
        /// </summary>
        /// <param name="otherPropertyName">The name of the other property that is affected</param>
        public AffectsOtherPropertyAttribute(string otherPropertyName)
        {
            Contract.Requires(string.IsNullOrWhiteSpace(otherPropertyName) == false, "The other property name must not be null, empty or whitespace");
            this.AffectsProperty = otherPropertyName;
        }

        /// <summary>
        /// The constraints about this object that must always be true.
        /// </summary>
        [ContractInvariantMethod]
        private void ObjectInvariants()
        {
            Contract.Invariant(string.IsNullOrWhiteSpace(this.AffectsProperty) == false, "The affected property name must never be null");
        }

        /// <summary>
        /// The name of the other property that is affected by the property this attribute
        /// is applied to
        /// </summary>
        public string AffectsProperty { get; private set; }

    }//class
}
