﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Reflection.Emit;
using System.Runtime.InteropServices;

namespace Utility
{
    public class UnmanagedMethodBuilder : IDisposable
    {
        [DllImport("kernel32")]
        public extern static IntPtr LoadLibrary(string lpLibFileName);

        [DllImport("kernel32")]
        public extern static bool FreeLibrary(IntPtr hLibModule);

        [DllImport("kernel32")]
        public extern static IntPtr GetProcAddress(IntPtr hModule, string lpProcName);

        private IntPtr hModule;
        private bool disposed = false;

        public string SourcePath = string.Empty;

        public UnmanagedMethodBuilder(string dll)
        {
            SourcePath = dll;
            hModule = LoadLibrary(SourcePath);
            if (hModule == IntPtr.Zero)
                throw new System.IO.FileNotFoundException();
        }

        public Object Build(Type iface)
        {
            // アセンブリ名はインターフェース名の先頭に'_'を付ける
            AssemblyName asnm = new AssemblyName();
            asnm.Name = "_" + iface.Name;
            AssemblyBuilder ab = AppDomain.CurrentDomain.DefineDynamicAssembly(
              asnm, AssemblyBuilderAccess.Run);
            // モジュール名はアセンブリ名と同じ
            ModuleBuilder md = ab.DefineDynamicModule(asnm.Name);
            // クラス名はアセンブリ名と同じ
            TypeBuilder tb = md.DefineType(asnm.Name, TypeAttributes.Public);
            tb.AddInterfaceImplementation(iface);

            // インタフェースメソッドを実装
            foreach (MethodInfo mi in
              iface.GetMethods(BindingFlags.Public | BindingFlags.Instance))
            {
                ParameterInfo[] pis = mi.GetParameters();
                Type[] parameterTypes = new Type[pis.Length];
                for (int i = 0; i < pis.Length; ++i)
                    parameterTypes[i] = pis[i].ParameterType;

                // _stdcallの場合は_XXX@YYY形式になるが未対応
                MethodBuilder mb = tb.DefineMethod(mi.Name,
                  MethodAttributes.Public | MethodAttributes.Virtual,
                  mi.ReturnType, parameterTypes);
                ILGenerator il = mb.GetILGenerator();
                // _stdcallの場合は、スタックの積み方は逆になるが未対応
                //for (int i = parameterTypes.Length; i > 0; --i)
                for (int i = 1; i <= parameterTypes.Length; i++)
                    il.Emit(OpCodes.Ldarg, i);
                
                Int32 address = (Int32)GetProcAddress(hModule, mb.Name);
                if (address == 0)
                {
                    return null;
                }

                il.Emit(OpCodes.Ldc_I4, address);
                
                il.EmitCalli(OpCodes.Calli, CallingConvention.Cdecl,
                  mi.ReturnType, parameterTypes);
                il.Emit(OpCodes.Ret);

                tb.DefineMethodOverride(mb, mi);
            }
            return tb.CreateType().GetConstructor(Type.EmptyTypes).Invoke(null);
        }
        #region IDisposable メンバ

        public void Dispose()
        {
            if (!disposed)
            {
                FreeLibrary(hModule);
                hModule = IntPtr.Zero;
                disposed = true;
            }
        }

        #endregion
    }
}
