
#include <common.h>

#include <qlib/qlib.hpp>
#include <qlib/FileStream.hpp>

#include <jsbr/jsbr.hpp>
#include <jsbr/Interp.hpp>

#include <qsys/qsys.hpp>
#include <qsys/SceneManager.hpp>

#include <modules/molstr/molstr.hpp>

#include <iostream>
#include "boost/filesystem/path.hpp"
#include "boost/filesystem/operations.hpp"


using qlib::LString;
void process_input(const LString &loadscr);

#ifndef DEFAULT_CONFIG
#define DEFAULT_CONFIG ""
#endif

/**
   main routine for CueTTY (CLI version)
 */
int main(int argc, const char *argv[])
{
  if (qlib::init())
    MB_DPRINTLN("qlib::init() OK.");
  else {
    LOG_DPRINTLN("Init: ERROR!!");
    return -1;
  }

  LString loadscr;
  LString confpath;

  for (int i=1; i<argc; ++i) {
    MB_DPRINTLN("arg%d=%s", i, argv[i]);
    LString value = argv[i];
    if (value.equals("-conf")) {
      ++i;
      if (i>=argc) break;
      confpath = argv[i];
    }
    else {
      loadscr = value;
    }
  }
  
  if (confpath.isEmpty()) {
    confpath = DEFAULT_CONFIG;
  }

  if (!qsys::init(confpath)) {
    LOG_DPRINTLN("Qsys Init (%s): ERROR!!", confpath.c_str());
    return -1;
  }

  // load internal JS module
  jsbr::init();

  // load molstr module
  molstr::init();

  //////////

  if (!loadscr.isEmpty()) {
    process_input(loadscr);
  }

  //////////

  molstr::fini();
  MB_DPRINTLN("=== molstr::fini() OK ===");

  jsbr::fini();
  MB_DPRINTLN("=== jsbr::fini() OK ===");

  qsys::fini();
  MB_DPRINTLN("=== qsys::fini() OK ===");

  qlib::fini();

  std::cerr << "=== Terminated normaly ===" << std::endl;
  return 0;
}

namespace fs = boost::filesystem;

void process_input(const LString &loadscr)
{
  qsys::SceneManager *pSM = qsys::SceneManager::getInstance();
  LOG_DPRINTLN("CueMol version %s build %s", pSM->getVersion().c_str(), pSM->getBuildID().c_str());

  fs::path scr_path(loadscr);
  
  fs::path full_path = fs::system_complete( scr_path );

  if ( !fs::exists( full_path ) ) {
    std::cout << "\nNot found: " << full_path.file_string() << std::endl;
    return;
  }

  //std::cerr << "\nFull path: " << full_path.file_string() << std::endl;
  //std::cerr << "Extn: " << full_path.extension() << std::endl;

  if (full_path.extension()==".qsc") {
    //qsys::ScenePtr rscene = pSM->loadSceneFrom(scr_path.file_string(), "xml");
    //qlib::FileOutStream &fos = qlib::FileOutStream::getStdErr();
    //rscene->writeTo(fos, true);
  }
  else if (full_path.extension()==".js") {
    qsys::ScenePtr rscene = pSM->createScene();
    qlib::uid_t scene_id = rscene->getUID();
    rscene->execJSFile(loadscr);
    //jsbr::Interp *pInt = jsbr::createInterp(rscene.copy());
    //pInt->execFile(loadscr);
    // delete pInt;
    pSM->destroyScene(scene_id);
  }

}

