// -*-Mode: C++;-*-
//
// Residue index (with inscode)
//

#ifndef MOLSTR_RESID_IND_H__
#define MOLSTR_RESID_IND_H__

namespace molstr {

  struct MOLSTR_API ResidIndex : public std::pair<int, char>
  {
    ResidIndex() : std::pair<int, char>(0, '\0') {}
    ResidIndex(int index) : std::pair<int, char>(index, '\0') {}
    ResidIndex(int index, char insc) : std::pair<int, char>(index, insc) {}
    //operator int() const { return std::pair<int, char>::first; }
    //operator int&() { return std::pair<int, char>::first; }
    int toInt() const { return std::pair<int, char>::first; }
    qlib::LString toString() const;
    static ResidIndex fromString(const qlib::LString &stridx);
  };

  inline bool operator<(const ResidIndex &ix, const ResidIndex &iy)
  {
    if (ix.first<iy.first)
      return true;
    else if (ix.first>iy.first)
      return false;
    return ix.second < iy.second;
  }

  inline bool operator==(const ResidIndex &ix, const ResidIndex &iy)
  {
    return (ix.first==iy.first) && (ix.second == iy.second);
  }

}

#endif
