// -*-Mode: C++;-*-
//
// Molecular symmetry module
//  module loader/common definitions
//

#ifndef SYMM_HPP_INCLUDED
#define SYMM_HPP_INCLUDED

#ifdef WIN32

#ifdef DEBUG_NEW
#define new DEBUG_NEW
#endif

// for MS-Windows
#define DLLEXPORT __declspec(dllexport)

#ifdef SYMM_EXPORTS
# define SYMM_API __declspec(dllexport)
#else
# define SYMM_API __declspec(dllimport)
#endif

#else

// for non-MS platforms
# define SYMM_API

#endif // WIN32

#include <qlib/LScrSmartPtr.hpp>

namespace symm {

  /// Common Initialization for the symm library
  SYMM_API bool init();
  
  /// Common Finalization for the symm library
  SYMM_API void fini();
  
  class CrystalInfo;
  typedef qlib::LScrSp<CrystalInfo> CrystalInfoPtr;
}

#endif

