// -*-Mode: C++;-*-
//
// Crystallographic visualization module
//  module loader/common definitions
//

#ifndef XTAL_HPP_INCLUDED
#define XTAL_HPP_INCLUDED

#include <qlib/LString.hpp>

#ifdef WIN32

#ifdef DEBUG_NEW
#define new DEBUG_NEW
#endif

// for MS-Windows
#define DLLEXPORT __declspec(dllexport)

#ifdef XTAL_EXPORTS
# define XTAL_API __declspec(dllexport)
#else
# define XTAL_API __declspec(dllimport)
#endif

#else

// for non-MS platforms
# define XTAL_API

#endif // WIN32

namespace xtal {

/// Common Initialization for the xtal library
XTAL_API bool init();

/// Common Finalization for the xtal library
XTAL_API void fini();

}

#endif

