// -*-Mode: C++;-*-
//
// Superclass for object factory classes
//
// $Id: LFactory.hpp,v 1.2 2008/01/13 09:23:19 rishitani Exp $

#ifndef LFACTORY_HPP_INCLUDE_
#define LFACTORY_HPP_INCLUDE_

#include "LString.hpp"

namespace qlib {

  template <class _Type>
  struct LCreator {
    virtual _Type *createInstance() const =0;
  };

  template <class _Type, class _Super>
  struct LConcreteCreator : public LCreator<_Super>
  {
    virtual _Super *createInstance() const {
      return new _Type;
    }
  };

  template <class _Type>
  class LFactory
  {
  private:
    /*struct Entry {
      LString abiname;
      LCreator *pCtor;

      Entry(const LString &abi) : abiname(abi), pCtor(NULL) {}
      Entry(LCreator *p) : abiname(), pCtor(p) {}
      };*/

  public:
    typedef LCreator<_Type> creator_t;
    //typedef std::map<LString, Entry> data_t;
    typedef std::map<LString, creator_t *> data_t;

  private:
    data_t m_data;

    LFactory(const LFactory &) {}

  public:

    LFactory() {}

    virtual ~LFactory() {
      typename data_t::const_iterator iter = m_data.begin();
      for ( ; iter!=m_data.end(); ++iter) {
	if (iter->second!=NULL)
	  delete iter->second;
      }
    }

    //bool insert(const LString &type, const LClass &cls);

    bool insert(const LString &type, creator_t *pctor) {
      bool res = m_data.insert(typename data_t::value_type(type, pctor)).second;
      if (!res) delete pctor;
      return res;
    }

    _Type *createInstance(const LString &type) const {
      typename data_t::const_iterator iter = m_data.find(type);
      if (iter==m_data.end()) {
	MB_DPRINTLN("LFactory::createInst: type %s is not found", type.c_str());
	return NULL;
      }

      _Type *pret = iter->second->createInstance();
      MB_DPRINTLN("LFactory object %p(%s) created by LCreator.",
		  pret, typeid(*pret).name());
      return pret;
    }

  };

  /*template <class _Type>
  struct LConcreteCreator : public LCreator
  {
    virtual LObject *createInstance() const {
      return new _Type;
    }
    };*/
}

#endif // LFACTORY_HPP_INCLUDE_
