//
// Interface for the property handling class
//

#ifndef _QLIB_PROP_SPEC_HPP__
#define _QLIB_PROP_SPEC_HPP__

#include "qlib.hpp"

#include "LString.hpp"

namespace qlib {

  // Enum type definition
  struct EnumDef : public std::map<LString,int>
  {
  };

  class PropSpec
  {
  public:
    LString type_name;
    bool bReadOnly;
    bool bHasDefault;
    EnumDef *pEnumDef;

    PropSpec()
      : type_name(), bReadOnly(false),
	bHasDefault(false), pEnumDef(NULL) {}

    ~PropSpec() {
      if (pEnumDef!=NULL)
	delete pEnumDef;
    }
  };

}

#endif
