// -*-Mode: C++;-*-
//
// qlib's library-related routines
//
// $Id: qlib.hpp,v 1.10 2010/01/23 14:25:05 rishitani Exp $

#ifndef QLIB_DLL_H__
#define QLIB_DLL_H__

#ifdef WIN32

#ifdef DEBUG_NEW
#define new DEBUG_NEW
#endif

// for MS-Windows
#ifdef QLIB_EXPORTS
#define QLIB_API __declspec(dllexport)
#else
#define QLIB_API __declspec(dllimport)
#endif
#else

// for non-MS platforms
# define QLIB_API

#endif // WIN32

namespace qlib {

  /** Initialize the qlib library */
  QLIB_API bool init();

  /** Cleanup the qlib library */
  QLIB_API void fini();

  typedef unsigned long uid_t;
  const uid_t invalid_uid = 0;

  namespace detail {
    struct no_init_tag {};
  }

  struct no_throw_tag {};

  typedef bool LBool;
  typedef QUE_INT_32 LInt;
  typedef QUE_FLT_64 LReal;

}

#include "LDebug.hpp"

#endif // QLIB_DLL_H__
