// -*-Mode: C++;-*-
//
// Camera:
//
// $Id: Camera.cpp,v 1.3 2010/09/22 16:59:39 rishitani Exp $
//

#include <common.h>

#include "Camera.hpp"
#include "ScrEventManager.hpp"

using namespace qsys;

Camera::Camera()
{
  m_fSlabDepth = 50.0;
  m_fZoom = 50.0;
  m_center = qlib::Vector4D(0,0,0);
  m_rotQuat = qlib::LQuat(1, 0, 0, 0);

  // m_fStereoDist = 1.0;
  // m_nStereoMode = 0;
  // m_fPerspec = false;

  resetAllProps();
}

CameraEvent::~CameraEvent()
{
}

qlib::LCloneableObject *CameraEvent::clone() const
{
  return new CameraEvent(*this);
}

LString CameraEvent::getJSON() const
{
  return "{\"name\":\""+m_name.escapeQuots()+"\"}";
}

bool CameraEvent::getCategory(LString &category, int &nSrcType, int &nEvtType) const
{
  category = "cameraChanged";
  nEvtType = m_nEvtType;
  nSrcType = ScrEventManager::SEM_CAMERA;
  return true;
}


