// -*-Mode: C++;-*-
//
// In/Out handler abstract class
//
// $Id: InOutHandler.cpp,v 1.4 2011/01/03 16:47:05 rishitani Exp $

#include <common.h>

#include "InOutHandler.hpp"
#include <qlib/FileStream.hpp>

using namespace qsys;

InOutHandler::~InOutHandler()
{
}

/*
LString InOutHandler::getPath() const
{
  return m_pathName;
}
    
void InOutHandler::setPath(const LString &path)
{
  m_pathName = path;
}
*/

LString InOutHandler::getPath(const LString &key) const
{
  return m_stream.getPath(key);
}

void InOutHandler::setPath(const LString &key, const LString &path)
{
  m_stream.setPath(key, path);
}
    
qlib::OutStream *InOutHandler::createOutStream(const LString &key) const
{
  qlib::FileOutStream *pRet = new qlib::FileOutStream();
  pRet->open( getPath(key) );
  return pRet;
}

qlib::InStream *InOutHandler::createInStream(const LString &key) const
{
  qlib::FileInStream *pRet = new qlib::FileInStream();
  pRet->open( getPath(key) );
  return pRet;
}


