// -*-Mode: C++;-*-
//
// Object: base class of data object
//

#ifndef QSYS_OBJECT_HPP_INCLUDE_
#define QSYS_OBJECT_HPP_INCLUDE_

#include "qsys.hpp"

#include <qlib/ObjectManager.hpp>
#include <qlib/LScrObjects.hpp>
#include <qlib/LScrSmartPtr.hpp>
#include <qlib/mcutils.hpp>
#include <qlib/MapTable.hpp>

#include "ObjectEvent.hpp"
#include "Renderer.hpp"

namespace qlib { class LDom2Tree; }

namespace qsys {

using qlib::LString;

  class ObjLoadEditInfo;

  class QSYS_API Object :
    public qlib::LNoCopyScrObject,
    public qlib::LUIDObject,
    public qlib::LPropEventListener
  {
    MC_SCRIPTABLE;

    friend class ObjLoadEditInfo;

  public:
    // type definitions
    //typedef std::map<LString, ObjExtDataPtr> ExtDataTab;
    typedef qlib::MapTable<ObjExtDataPtr> ExtDataTab;

    typedef qlib::LNoCopyScrObject super_t;
    // typedef qlib::LSimpleCopyScrObject super_t;

  private:
    //////////////////////////////////////////////////
    // properties/etc

    /// Unique ID of this object
    qlib::uid_t m_uid;

    /// Name of this object
    LString m_name;

    /// Modified flag
    bool m_bModified;

    LString m_source;
    LString m_altsrc;
    LString m_sourcetype;

    qlib::LDom2Node *m_pReaderOpts;

    /// Visibility
    bool m_bVisible;

    /// Locked/unlocked (for user editing)
    bool m_bLocked;

    /// object event implementation
    ObjectEventCaster *m_pEvtCaster;


    /// ID of the scene to which this object belongs
    qlib::uid_t m_nSceneID;

    /// Extension data
    ExtDataTab m_extdat;

    //////////////////////////////////////////////////
    // 

    /// = operator (avoid copy operation)
    Object(const Object &r)
    {
      MB_ASSERT(false);
    }

    /// = operator (avoid copy operation)
    const Object &operator=(const Object &arg)
    {
      MB_ASSERT(false);
      return *this;
    }

    virtual qlib::LCloneableObject *clone() const {
      MB_ASSERT(false);
      return NULL;
    }
    
    //////////////////////////////////////////////////

  public:
    // default ctor
    Object();

    // dtor
    virtual ~Object();
  
    //////////

    const LString &getName() const { return m_name; }
    void setName(const LString &name) { m_name = name; }
    
    /// Get modified flag (read only from UI)
    bool getModifiedFlag() const { return m_bModified; }
    void setModifiedFlag(bool b) { m_bModified = b; }

    void setVisible(bool b) { m_bVisible = b; }
    bool isVisible() const { return m_bVisible; }

    void setUILocked(bool b) { m_bLocked = b; }
    bool isUILocked() const { return m_bLocked; }

    //

    const LString &getSource() const {
      return m_source;
    }
    void setSource(const LString &name) {
      m_source = name;
    }

    const LString &getAltSource() const {
      return m_altsrc;
    }
    void setAltSource(const LString &name) {
      m_altsrc = name;
    }
    
    void setReaderOpts(qlib::LDom2Node *ptree);
    qlib::LDom2Node *getReaderOpts() const { return m_pReaderOpts; }

    //

    const LString &getSourceType() const {
      return m_sourcetype;
    }
    void setSourceType(const LString &name) {
      m_sourcetype = name;
    }
    
    //

    qlib::uid_t getUID() const { return m_uid; }
    void setUID(qlib::uid_t) {
      MB_ASSERT(false);
    }

    //////////
  
    void setSceneID(qlib::uid_t nid) { m_nSceneID = nid; }
    
    qlib::uid_t getSceneID() const { return m_nSceneID; }
    ScenePtr getScene() const;

    virtual void unloading();
    virtual LString toString() const;

    virtual void dump() const;

    ////////////////////////////////////////////////////////////
    // Renderer management methods

  private:
    typedef std::map<qlib::uid_t, RendererPtr> rendtab_t;
    rendtab_t m_rendtab;

  public:
    typedef rendtab_t::const_iterator RendIter;

    RendererPtr createRenderer(const LString &tpnm);
    RendererPtr getRenderer(qlib::uid_t uid) const;
    RendererPtr getRendererByType(const LString &tpnm);
    RendererPtr getRendererByIndex(int ind);
    bool destroyRenderer(qlib::uid_t uid);


    RendIter beginRend() const { return m_rendtab.begin(); }
    RendIter endRend() const { return m_rendtab.end(); }
    int getRendCount() const { return m_rendtab.size(); }

    /// Returns comma separated list of compatible Renderer names
    LString searchCompatibleRendererNames();

    //////////
    // Scripting interface wrapper
    qlib::LVarArray getRendUIDArray() const;
    qlib::LVarArray getRendArray() const;

    ////////////////////////////////////////////////////////////
    // Extension data management

    int getExtDataSize() const;

    ObjExtDataPtr getExtData(const LString &name) const;

    void removeExtData(const LString &name);

    void setExtData(const LString &name, ObjExtDataPtr p);

    ////////////////////////////////////////////////////////////
    // Event related operations

    int addListener(ObjectEventListener *pL);
    bool removeListener(ObjectEventListener *pL);
    void fireObjectEvent(ObjectEvent &ev);

    /// for property event propagation
    virtual qlib::uid_t getRootUID() const;

    /// property event handler for object properties
    virtual void propChanged(qlib::LPropEvent &ev);

    ////////////////////////////////////////////////////////////
    // Serialization/Deserialization

    virtual void writeTo2(qlib::LDom2Node *pNode) const;
    virtual void readFrom2(qlib::LDom2Node *pNode);

    void forceEmbed();

  private:
    bool registerRendererImpl(RendererPtr);

  };

}

#endif
