// -*-Mode: C++;-*-
//
// Abstract class for QDF reader classes
//

#ifndef QSYS_QDF_ABS_READER_HPP
#define QSYS_QDF_ABS_READER_HPP

#include "qsys.hpp"

#include <qlib/mcutils.hpp>
#include <qlib/LExceptions.hpp>
#include <qlib/LTypes.hpp>
#include "ObjReader.hpp"

#include "QdfAbsWriter.hpp"

namespace qlib { class BinInStream; }

namespace qsys {

using qlib::LString;

class QSYS_API QdfAbsReader : public ObjReader, public QdfDataType
{

public:
  QdfAbsReader();
  virtual ~QdfAbsReader();

  /////////

  // QDF common interface

  void start(qlib::InStream &ins);
  void end();

  LString getFileType() const { return m_strFileType; }

  int readDataDef(const LString &name);

  void readRecordDef();

  void startRecord() { m_nRecInd = 0; }
  void endRecord() {}

  qfloat32 getRecValFloat32(const LString &name);
  qint32 getRecValInt32(const LString &name);
  qint8 getRecValInt8(const LString &name);
  LString getRecValStr(const LString &name);

private:
  // QDF implementation data

  /// Binary input stream
  qlib::BinInStream *m_pBinIn;

  /// File type string
  LString m_strFileType;

  /// QDF version no
  int m_nVer;

  RecElemList m_recdefs;
  
  int m_nRecInd;
};

}

#endif

