// -*-Mode: C++;-*-
//
// View related events
//
// $Id: ViewEvent.cpp,v 1.1 2010/09/12 12:52:38 rishitani Exp $

#include <common.h>

#include "ViewEvent.hpp"
#include "ScrEventManager.hpp"

using namespace qsys;

ViewEvent::~ViewEvent()
{
}

qlib::LCloneableObject *ViewEvent::clone() const
{
  return new ViewEvent(*this);
}

LString ViewEvent::getJSON() const
{
  LString json = "{}";
  return json;
}

bool ViewEvent::getCategory(LString &category, int &nTgtType, int &nEvtType) const
{
  const int nev = getType();
  switch (nev) {
  case ViewEvent::VWE_PROPCHG:
    nEvtType = ScrEventManager::SEM_PROPCHG;
    nTgtType = ScrEventManager::SEM_VIEW;
    category = "viewPropChanged";
    break;

  case ViewEvent::VWE_PROPCHG_DRG:
    nEvtType = ScrEventManager::SEM_PROPCHG;
    nTgtType = ScrEventManager::SEM_VIEW;
    category = "viewPropChgDragging";
    break;

  case ViewEvent::VWE_ACTIVATED:
    nEvtType = ScrEventManager::SEM_OTHER;
    nTgtType = ScrEventManager::SEM_VIEW;
    category = "viewActivated";
    break;

  case ViewEvent::VWE_SIZECHG:
    nEvtType = ScrEventManager::SEM_CHANGED;
    nTgtType = ScrEventManager::SEM_VIEW;
    category = "viewSizeChanged";
    break;

  default:
    MB_DPRINTLN("FATAL ERROR: unknown event type");
    return false;
  }

  return true;
}

