// -*-Mode: C++;-*-
//
// qsys's library-related routines
//
// $Id: qsys.hpp,v 1.13 2010/12/03 09:50:35 rishitani Exp $

#ifndef QSYS_DLL_H__
#define QSYS_DLL_H__

#ifdef WIN32

#ifdef DEBUG_NEW
#define new DEBUG_NEW
#endif

// for MS-Windows
#ifdef QSYS_EXPORTS
# define QSYS_API __declspec(dllexport)
#else
# define QSYS_API __declspec(dllimport)
#endif

#else

// for non-MS platforms
# define QSYS_API

#endif // WIN32

#include <qlib/LScrSmartPtr.hpp>

namespace qsys {

  /** Initialize the qsys library */
  QSYS_API bool init(const char *config);

  /** Cleanup the qsys library */
  QSYS_API void fini();

  class Scene;
  typedef qlib::LScrSp<Scene> ScenePtr;

  class Object;
  typedef qlib::LScrSp<Object> ObjectPtr;

  class Renderer;
  typedef qlib::LScrSp<Renderer> RendererPtr;

  class View;
  typedef qlib::LScrSp<View> ViewPtr;

  class Camera;
  typedef qlib::LScrSp<Camera> CameraPtr;

  class InOutHandler;
  typedef qlib::LScrSp<InOutHandler> InOutHandlerPtr;

  class ObjExtData;
  typedef qlib::LScrSp<ObjExtData> ObjExtDataPtr;

  class DrawObj;
  typedef qlib::LScrSp<DrawObj> DrawObjPtr;

}

#endif // QSYS_DLL_H__
