// -*-Mode: C++;-*-
//
// Style edit info
//
// $Id: StyleEditInfo.cpp,v 1.1 2011/05/02 12:42:55 rishitani Exp $
//

#include <common.h>

#include "StyleEditInfo.hpp"
#include "StyleSupports.hpp"
#include "StyleSheet.hpp"

using namespace qsys;

StyleEditInfo::~StyleEditInfo()
{
}

/// Perform undo
bool StyleEditInfo::undo()
{
  StyleSupports *pTgt =
    qlib::ObjectManager::sGetObj<StyleSupports>(getTargetUID());
  if (pTgt==NULL) return false;

  StyleSheet *pSS = pTgt->getStyleSheet();
  pSS->setStyleNames(m_oldvalue);

  // fire event
  fireStyleEvents(pTgt);
  return true;
}

/// Perform redo
bool StyleEditInfo::redo()
{
  StyleSupports *pTgt =
    qlib::ObjectManager::sGetObj<StyleSupports>(getTargetUID());
  if (pTgt==NULL) return false;

  StyleSheet *pSS = pTgt->getStyleSheet();
  pSS->setStyleNames(m_newvalue);

  // fire event
  fireStyleEvents(pTgt);
  return true;
}

bool StyleEditInfo::isUndoable() const
{
  // TO DO: check actually undoable
  return true;
}

bool StyleEditInfo::isRedoable() const
{
  // TO DO: check actually redoable
  return true;
}

void StyleEditInfo::fireStyleEvents(StyleSupports *pTgt)
{
  // Style changed event
  {
    StyleEvent ev;
    pTgt->styleChanged(ev);
  }

  // Fake the style-prop changed event
  qlib::LPropEventListener *pPropTgt = dynamic_cast<qlib::LPropEventListener *>(pTgt);
  if (pPropTgt!=NULL) {
    qlib::LPropEvent ev("styles");
    pPropTgt->propChanged(ev);
  }
}

