// -*-Mode: C++;-*-
//
// StyleSet implementation
//
// $Id: StyleSet.cpp,v 1.2 2011/04/16 17:30:39 rishitani Exp $

#include <common.h>

#include "StyleSet.hpp"

#include <gfx/SolidColor.hpp>
#include <gfx/NamedColor.hpp>

#include <qlib/FileStream.hpp>
#include <qlib/LDOM2Stream.hpp>

using namespace qsys;
using qlib::LDom2Node;
using gfx::SolidColor;
using gfx::SolidColorPtr;
using gfx::AbstractColor;
using gfx::NamedColor;

StyleSet::StyleSet()
     : m_bModified(false)
{
}

StyleSet::~StyleSet()
{
  m_matdata.clearAndDelete();

  BOOST_FOREACH (data_t::value_type &v, m_data) {
    delete v.second;
  }
}

//////////

bool StyleSet::getColor(const LString &rkey, ColorPtr &rcol) const
{
  LString key = rkey.toLowerCase();
  palette_t::const_iterator iter = m_palette.find(key);
  if (iter==m_palette.end()) 
    return false;
  rcol = iter->second;
  return true;
}

bool StyleSet::putColor(const LString &rkey, const ColorPtr &pCol)
{
  LString key = rkey.toLowerCase();
  palette_t::const_iterator iter = m_palette.find(key);
  if (iter!=m_palette.end())
    return false;

  bool res = m_palette.insert(palette_t::value_type(key, pCol)).second;
  if (res)
    m_bModified = true;
  return res;
}

/////

bool StyleSet::getString(const LString &key, LString &rval) const
{
  strdata_t::const_iterator iter = m_strdata.find(key);
  if (iter==m_strdata.end())
    return false;
  rval =  iter->second;
  return true;
}

bool StyleSet::putString(const LString &key, const LString &value)
{
  bool res = m_strdata.insert(strdata_t::value_type(key, value)).second;
  if (res)
    m_bModified = true;
  return res;
}

LDom2Node *StyleSet::getData(const LString &key) const
{
  data_t::const_iterator iter = m_data.find(key);
  if (iter==m_data.end())
    return NULL;
  return iter->second;
}

bool StyleSet::putData(const LString &key, LDom2Node *pNode)
{
  bool res = m_data.insert(data_t::value_type(key, pNode)).second;
  if (res)
    m_bModified = true;
  return res;
}

//////////

bool StyleSet::putMaterial(const LString &id, const LString &type, const LString &value)
{
  Material *pMat = m_matdata.get(id);
  if (pMat==NULL) {
    pMat = new Material();
    m_matdata.set(id, pMat);
  }

  pMat->setDepValue(type, value);
  m_bModified = true;
  return true;
}

bool StyleSet::putMaterial(const LString &id, int type, double value)
{
  Material *pMat = m_matdata.get(id);
  if (pMat==NULL) {
    pMat = new Material();
    m_matdata.set(id, pMat);
  }

  pMat->setSysValue(type, value);
  m_bModified = true;
  return true;
}

Material *StyleSet::getMaterial(const LString &id) const
{
  return m_matdata.get(id);
}

//////////

StyleList::~StyleList()
{
  // TO DO: style set possibly belongs to multiple lists of scenes,
  // therefore should be managed by reference counting.
  BOOST_FOREACH (value_type v, *this) {
    delete v;
  }
}



