// -*-Mode: C++;-*-
//
// Style/color database
//

#ifndef GFX_STYLE_SET_HPP_INCLUDED
#define GFX_STYLE_SET_HPP_INCLUDED

#include <qsys/qsys.hpp>
#include <gfx/gfx.hpp>

#include <qlib/MapTable.hpp>
#include <gfx/Material.hpp>

namespace qlib {
  class PrintStream;
  class InStream;
  class OutStream;
  class LDom2Node;
}

namespace qsys {

  using qlib::LString;
  using qlib::LDom2Node;
  using gfx::ColorPtr;
  using gfx::Material;

  ///
  /// Style definition set
  ///
  class GFX_API StyleSet
  {
  private:
    typedef std::map<LString, ColorPtr> palette_t;
    typedef std::map<LString, LString> strdata_t;
    typedef std::map<LString, LDom2Node*> data_t;

    typedef qlib::MapPtrTable<Material> matdata_t;

    /// Named color definitions
    palette_t m_palette;

    /// String data definitions
    strdata_t m_strdata;

    /// Structured data definitions
    data_t m_data;

    /// Material definition
    matdata_t m_matdata;

    // TO DO: linked style set belongs to multiple scenes
    /// ID of the Scene to which this StyleSet belongs
    qlib::uid_t m_nID;

    /// source file name this style is loaded from
    LString m_source;

    /// id of this style set
    LString m_name;

    /// modified flag
    bool m_bModified;

  public:
    
    StyleSet();

    ~StyleSet();

    //////////

    void setContextID(qlib::uid_t id) { m_nID = id; }
    qlib::uid_t getContextID() const { return m_nID; }

    void setSource(const LString &src) { m_source =src; }
    const LString &getSource() const { return m_source; }

    void setName(const LString &name) { m_name = name; }
    const LString &getName() const { return m_name; }

    void setModified(bool val) { m_bModified = val; }
    bool isModified() const { return m_bModified; }

    //////////
    // Color data methods

    bool getColor(const LString &key, ColorPtr &rcol) const;
    bool putColor(const LString &rkey, const ColorPtr &pCol);

    typedef palette_t::const_iterator coldata_iterator;
    coldata_iterator colBegin() const { return m_palette.begin(); }
    coldata_iterator colEnd() const { return m_palette.end(); }

    //////////
    // String data methods

    bool getString(const LString &key, LString &rval) const;
    bool putString(const LString &key, const LString &value);

    typedef strdata_t::const_iterator strdata_iterator;
    strdata_iterator strBegin() const { return m_strdata.begin(); }
    strdata_iterator strEnd() const { return m_strdata.end(); }

    //////////
    // Structured data methods

    LDom2Node *getData(const LString &key) const;
    bool putData(const LString &key, LDom2Node *pNode);

    typedef data_t::const_iterator data_iterator;
    data_iterator dataBegin() const { return m_data.begin(); }
    data_iterator dataEnd() const { return m_data.end(); }

    //////////
    // Material data methods
    bool putMaterial(const LString &id, const LString &type, const LString &value);
    bool putMaterial(const LString &id, int type, double value);
    Material *getMaterial(const LString &id) const;
  };

  /// Cascading list of style set objects.
  /// StyleSet nearer the front has higher priority.
  class StyleList : public std::list<StyleSet *>
  {
  public:
    ~StyleList();
  };

}

#endif

