// -*-Mode: C++;-*-
//
// Style support interface
//

#ifndef QSYS_STYLE_SUPPORTS_HPP_INCLUDED
#define QSYS_STYLE_SUPPORTS_HPP_INCLUDED

#include <qsys/qsys.hpp>
#include <qlib/LScrObjects.hpp>
#include <qlib/LEvent.hpp>

namespace qsys {

  class StyleSheet;

  class QSYS_API StyleEvent : public qlib::LEvent
  {
  public:
    StyleEvent() {}
    
    StyleEvent(const StyleEvent &ev)
         : qlib::LEvent(ev)
    {}
  
    virtual ~StyleEvent();

    virtual LCloneableObject *clone() const;
  };

  ////////////////////////////////////////////

  ///
  /// Stylesheet supporting class
  /// getStyleSheet() should be implemented so as to return the applied style sheet object.
  ///
  class QSYS_API StyleSupports //: public StyleEventListener
  {
  public:
    virtual ~StyleSupports() {}
    virtual StyleSheet *getStyleSheet() =0;
    virtual void styleChanged(StyleEvent &) =0;
    virtual qlib::uid_t getStyleCtxtID() const =0;
  };

  /////////////////////
  
  ///
  /// Interface of style event listeners
  ///
  typedef StyleSupports StyleEventListener;

  ////////////////////////////////////////////

  ///
  /// Scriptable object class with stylesheet client implementation
  ///   resetProperty() implements reseting the prop value to the style-sheet defined value.
  ///
  class QSYS_API StyleScrObject : public qlib::LSimpleCopyScrObject
  {
  public:
    typedef qlib::LSimpleCopyScrObject super_t;

    virtual ~StyleScrObject();

    virtual bool resetProperty(const LString &propnm);

  };

}

#endif

