//
//
//
// $Id: MouseEventHandler.hpp,v 1.3 2010/12/04 17:23:19 rishitani Exp $
//

#ifndef MOUSE_EVENT_HANDLER_HPP_INCLUDED
#define MOUSE_EVENT_HANDLER_HPP_INCLUDED

namespace qsys {

/// Utility class for seting up mouse event object (for dragging info)
class MouseEventHandler
{
private:
  /// for mouse drag event generation
  int m_prevPt_x, m_prevPt_y;
  int m_startPt_x, m_startPt_y;
    
  /// mouse dragging start flag
  int m_nDragStart;

  enum {
    DRAG_NONE,
    DRAG_CHECK,
    DRAG_DRAG
  };
  
public:
  
  MouseEventHandler()
    : m_prevPt_x(0), m_prevPt_y(0), m_startPt_x(0), m_startPt_y(0),
      m_nDragStart(DRAG_NONE)
  {
  }

  ~MouseEventHandler()
  {
  }

  void buttonDown(InDevEvent &ev)
  {
    // Ignore mousedown event, when drag is already initiated.
    if (m_nDragStart==DRAG_NONE) {
      m_startPt_x = m_prevPt_x = ev.getX();
      m_startPt_y = m_prevPt_y = ev.getY();
      m_nDragStart = DRAG_CHECK;
    }
    else {
      MB_DPRINTLN("buttonDown> drag is already initiated. %d", m_nDragStart);
    }
  }

  bool move(InDevEvent &ev)
  {
    const int xx = ev.getX();
    const int yy = ev.getY();

    // check drag start
    // TO DO : make the "Drag Start Range" configureable
    if (m_nDragStart==DRAG_CHECK) {
      if (qlib::abs<int>(xx-m_prevPt_x)<2 &&
	  qlib::abs<int>(yy-m_prevPt_y)<2 ) {
	// pointer is still in chkdrag range --> do nothing
	return false;
      }

      // pointer is out from chkdrag range --> enter to dragging mode
      m_nDragStart = DRAG_DRAG;
      ev.setType(InDevEvent::INDEV_DRAG_START);
      m_prevPt_x = xx;
      m_prevPt_y = yy;
      return true;
    }
    
    ev.setType(InDevEvent::INDEV_DRAG_MOVE);
    ev.setDeltaX(xx - m_prevPt_x);
    ev.setDeltaY(yy - m_prevPt_y);
    ev.setMoveX(xx - m_startPt_x);
    ev.setMoveY(yy - m_startPt_y);
    
    m_prevPt_x = xx;
    m_prevPt_y = yy;

    return true;
  }

  void buttonUp(InDevEvent &ev)
  {
    if (m_nDragStart==DRAG_CHECK) {
      // click event case
      ev.setType(InDevEvent::INDEV_LBTN_CLICK);
      MB_DPRINTLN("buttonUp> click");
    }
    else{
      // mouse drag is initiated
      // case of the end of drag
      ev.setType(InDevEvent::INDEV_DRAG_END);
      MB_DPRINTLN("buttonUp> drag end");
    }
    m_nDragStart = DRAG_NONE;
  }

};

}

#endif
