//
// $Id: XPCObjWrapper.hpp,v 1.9 2009/11/15 11:50:41 rishitani Exp $
//

#ifndef XPC_OBJ_WRAPPER_HPP__
#define XPC_OBJ_WRAPPER_HPP__

#include "qIObjWrapper.h"
#include <qlib/LScriptable.hpp>

namespace qlib {
  class LVarArgs;
}

namespace xpcom {

  using qlib::LString;
  using qlib::LScriptable;
  using qlib::LVariant;

  class XPCCueMol;

  class XPCObjWrapper : public qIObjWrapper
  {
  private:
    XPCCueMol *m_pParent;
    int m_nIndex;

    LScriptable *m_pWrapped;

  public:

    XPCObjWrapper(XPCCueMol *pParent, int ind);
    virtual ~XPCObjWrapper();

    // Implementation

    void setWrappedObj(LScriptable *pobj);

    void detach();

    LScriptable *getWrappedObj() const;

    // XPCOM iface Implementation

    NS_DECL_ISUPPORTS;

    NS_DECL_QIOBJWRAPPER;

  private:
    nsresult invokeChk1(const char *name);
    nsresult invokeImpl(const char *name, qlib::LVarArgs &largs, nsIVariant **_retval);
    LString getPropsJSONImpl(LScriptable *pObj);
    
    nsresult checkPropImpl(const char *propname, PRBool *rval = NULL);

  };

}

#endif
