// -*-Mode: C++;-*-
// $Id: molsellist.js,v 1.6 2011/04/03 11:11:06 rishitani Exp $
//

////////////////////////////////
// define class MolSelList

if (!("MolSelList" in cuemolui)) {

cuemolui.MolSelList = ( function () {

/// constructor
var MolSelList = function (aOuter)
{
  this._outer = aOuter;
}

var cls = MolSelList.prototype;

cls.init = function ()
{
  var that = this;
  var elem = this._outer.mSelBox;
  elem.addEventListener("select", function(){that.onSelBoxSelect();}, false);
  elem.inputField.addEventListener(
    "change",
    function(){try{that.onSelBoxChange();}catch(e){debug.exception(e);}}, false);
  
  this.targetSceID = null;
  this.targetObjID = null;

  this.mOrigSel = null;
  this.mSelectedSel = null;
}

cls.buildBox = function (aResvSel)
{
  var stylem = cuemol.getService("StyleManager");
  //var element = document.getAnonymousElementByAttribute(this, "anonid", "selection-box");
  var element = this._outer.mSelBox;
  
  dd("buildBox element: "+element);
  var oldselval = null;
  if (element.selectedItem) {
    dd(" ### Old selected: "+element.selectedItem.label);
    oldselval = element.selectedItem.value;
  }
  element.removeAllItems();
  
  // original value
  dd("***************** orig sel: "+this.mOrigSel);
  if (this.mOrigSel) {
    element.appendItem(this.mOrigSel.toString(), this.mOrigSel.toString());
    element.menupopup.insertBefore(document.createElement("menuseparator"), null);
  }
  
  var sce_id = null;
  
  // Object's current selection
  if (this.targetObjID) {
    var obj = cuemol.getObject(this.targetObjID);
    sce_id = obj.scene_uid;
    // Also update scene ID
    if (this.targetSceID==null)
      this.targetSceID = sce_id;
    if ("sel" in obj) {
      var selstr = obj.sel.toString();
      if (selstr.length>0) {
        element.appendItem("current ("+selstr+")", selstr);
      }
    }
  }
  else if (this.targetSceID) {
    sce_id = this.targetSceID;
  }
  
  element.appendItem("all (*)", "*");
  var prev_sep = this.appendSeparator(element);
  
  // Selection history
  var his = require("util").selHistory;
  var nitems = his.getLength();
  if (nitems>0) {
    for (var i=0; i<nitems; ++i) {
      element.appendItem(his.getEntry(i), his.getEntry(i));
    }
    prev_sep.setAttribute("label", "History");
    prev_sep = this.appendSeparator(element);
  }

  // Scene's selection defs
  if (sce_id !== null) {
    var json = stylem.getStrDataDefsJSON("sel", sce_id);
    dd("scene selection defs: "+json);
    if (this.appendSelJSON(element, json)!=0) {
      prev_sep.setAttribute("label", "Scene");
      prev_sep = this.appendSeparator(element);
    }
  }
  
  // global selection defs
  json = stylem.getStrDataDefsJSON("sel", 0);
  if (this.appendSelJSON(element, json)!=0) {
    prev_sep.setAttribute("label", "Global");
  }
  
  if (aResvSel && oldselval) {
    dd("=== BuildBox oldsel="+oldselval);
    var nitems = element.menupopup.childNodes.length;
    var i;
    for (i=0; i<nitems; ++i) {
      var item = element.menupopup.childNodes[i];
      if (item && item.value == oldselval) {
        dd("=== BuildBox oldsel is selected"+item.value);
        element.selectedIndex = i;
        break;
      }
    }
    if (i==nitems)
      element.selectedIndex = 0;
  }
  else {
    element.selectedIndex = 0;
  }
};

cls.appendSeparator = function (aElem, aLabel)
{
  var item = document.createElement("menuseparator");
  if (aLabel)
    item.setAttribute("label", aLabel);
  aElem.menupopup.insertBefore(item, null);
  return item;
};

cls.appendSelJSON = function (aElem, aJson)
{
  var nappend = 0;
  try {
    var seldefs = JSON.parse(aJson);
    // seldefs.splice(seldefs.length, 0, tmp);
    seldefs.forEach(function (e) {
	      aElem.appendItem(e, e);
      ++nappend;
    }, this);
  }
  catch (e) {
    dd("error : "+json);
    debug.exception(e);
  }
  return nappend;
};

cls.updateCurrentSel = function ()
{
  dd("MolSel.updateCurrentSel> "+this.targetObjID);
  this.buildBox(false);
};

cls.onSelBoxSelect = function ()
{
  var val = this._outer.mSelBox.selectedItem.value;
  var lab = this._outer.mSelBox.selectedItem.label;
  var ind = this._outer.mSelBox.selectedIndex;
  dd("selboxselect: index="+ind+", val="+val+", lab="+lab);

  if (typeof val == 'undefined' || val===null || val.length==0) {
    dd("!!! this._outer.mSelBox.selectedItem.value is invalid: "+this._outer.mSelBox.selectedItem.value);
    return;
  }
  
  //var sel = cuemol.createObj("SelCommand");
  //sel.compile(val);
  var sel = cuemol.makeSel(val, this.targetSceID);
  
  this.mSelectedSel = sel;
  if (this._outer.mSelErrBox)
    this._outer.mSelErrBox.setAttribute("noerr", "yes"); //value = "";

  if (val!==lab) {
    this._outer.mSelBox.inputField.value = val;
  }
};

cls.onSelBoxChange = function ()
{
  var val = this._outer.mSelBox.inputField.value;
  var bOK = false;
  
  try {
    var sel = cuemol.makeSel(val, this.targetSceID);
    if (sel) {
      this.mSelectedSel = sel;
      bOK = true;
    }
  }
  catch (e) {
    dd("exception: "+e);
    debug.exception(e);
  }
  
  //window.alert("SelBoxChange:"+bOK);
  //dd("***** this._outer.mSelBox: "+this._outer.mSelBox);
  //dd("***** this._outer.mSelErrBox: "+this._outer.mSelErrBox);
  
  var error_box = this._outer.mSelErrBox;
  if (error_box===null || error_box===undefined) {
    dd("molsellist> Warning: No error box is defined");
    return;
  }

  if (bOK)
    error_box.setAttribute("noerr", "yes"); //value = "";
  else {
    error_box.removeAttribute("noerr"); //value = "Error in the selection code!!";
    this.mSelectedSel = null;
    // window.alert(this._outer.mSelErrBox.value);
  }
};

cls.addHistorySel = function ()
{
  if (this.mSelectedSel) {
    var cmd = this.mSelectedSel.toString();
    if (cmd)
      util.selHistory.append(cmd);
  }
}

return MolSelList;

})();
}


