// -*-Mode: C++;-*-
//
//  Tabbed molecular viewer
//
// $Id: tabmolview.js,v 1.24 2011/02/20 09:34:26 rishitani Exp $
//

// dump("loading tabmolview.js ....\n");

if (!("TabMolView" in cuemolui)) {

cuemolui.TabMolView = ( function() {

// constructor
var ctor = function (aOuter)
{
  this._outer = aOuter;

  this.mHoverTimeoutID = null;
  this.mHoverDelay = 1000;
  this.mToolTip = document.getElementById("tabmolview-tooltip");
  this.mActiveViewID = null;

  this.mCurrentScene = null;
  this.mCurrentView = null;

  var that = this;
  this._callbackID = cuemol.evtMgr.addListener(
    "",
    cuemol.evtMgr.SEM_SCENE, //|cuemol.evtMgr.SEM_VIEW, // source type
    cuemol.evtMgr.SEM_PROPCHG, // event type
    0, // source UID (ANY)
    function (args) { that.onScenePropChanged(args); });

  window.addEventListener("unload", function() {
    dd("TABMOLVIEW: unload called --> unregister evt listnr.");
    cuemol.evtMgr.removeListener(that._callbackID);
    that._callbackID = null;
    delete that.mCurrentScene;
    delete that.mCurrentView;
  }, false);

  aOuter.mPanelContainer.addEventListener("select", function(ev) { try {
    that.onTabSelect(ev);
  } catch (e) {debug.exception(e);} }, false);

  var tabsel_popup = aOuter.mTabContainer.mAllTabsPopup;
  tabsel_popup.addEventListener("popupshowing", function(ev) { try {
    that.populateAllTabMenu(ev);
  } catch (e) {debug.exception(e);} }, false);
  tabsel_popup.addEventListener("command", function(ev) { try {
    that.onCmdTabMenu(ev);
  } catch (e) {debug.exception(e);} }, false);

  //////////
  // View key-shortcut registration (XXX: move to xul files?)

  try {
  cuemolui.shortcut.reg("view-trans-plusx", "VK_RIGHT", "control", function (id) {
    that.onShortcutEvent(id); } );
  cuemolui.shortcut.reg("view-trans-minusx", "VK_LEFT", "control", function (id) {
    that.onShortcutEvent(id); } );
  }
  catch (e) { debug.exception(e); }
};

ctor.prototype.onShortcutEvent = function (aId)
{
  switch (aId) {
  case "view-trans-plusx":
    this._outer.translateView(1, 0, 0);
    break;
  case "view-trans-minusx":
    this._outer.translateView(-1, 0, 0);
    break;
  }
};

ctor.prototype.updateCurView = function ()
{
  if (this.mCurrentView==null)
    this.mCurrentView=this.getCurrentViewW();
}

/////////////////////////

ctor.prototype._bindIframeToNativeWidget = function(scid, vwid, mvid)
{
  const pref = require("preferences-service");

  dd("bindIframeToNativeWidget() called");
  var frm = window.document.getElementById(mvid);
  var flo = frm.QueryInterface(Ci.nsIFrameLoaderOwner);
  var fldr = flo.frameLoader;
  var docshell = fldr.docShell;
  var bw = docshell.QueryInterface(Ci.nsIBaseWindow);
  dd("BindIframe: basewindow= "+bw);

  var natwin = cuemol.xpc.createNativeWidget();
  if (!natwin) {
    dd("FATAL ERROR: cannot create native widget.");
    window.alert("FATAL ERROR: cannot create native widget.");
    return;
  }
  if (pref.has("cuemol2.ui.mouse-multitouch-pad"))
    natwin.useMultiPad = pref.get("cuemol2.ui.mouse-multitouch-pad");
  natwin.setBaseWin(bw);

  /*
  function onResize(aEvent) {
    var res1 = new Object();
    var res2 = new Object();
    dump("***onResize target="+aEvent.target+"\n");
    //dumpln("  bw.enabled: "+bw.enabled);
    bw.getSize(res1, res2);
    dump("***onResize called: "+JSON.stringify(res1)+JSON.stringify(res2)+"\n");
  }

  frm.contentWindow.addEventListener("resize", onResize, false);*/
  //onResize({target: 1});

  /*
  var that = this;
  frm.contentWindow.addEventListener("mousemove", function (e) { that.onMouse(e); }, false);
  frm.contentWindow.addEventListener("mouseover", function (e) { that.onMouse(e); }, false);
  frm.contentWindow.addEventListener("mouseout", function (e) { that.onMouse(e); }, false);
  */

  var natwin_el = natwin.QueryInterface(Ci.nsIDOMEventListener);
  var evtarg = frm.contentWindow;
  dd("NatieWidget event lisnter="+natwin_el);

  evtarg.addEventListener("resize", natwin_el, false);
  //evtarg.addEventListener("resize", onResize, false);
  evtarg.addEventListener("hide", natwin_el, false);

  evtarg.addEventListener("unload",
                          function onUnload(aEvent) {
                            evtarg.removeEventListener("resize", natwin_el, false);
                            evtarg.removeEventListener("hide", natwin_el, false);
                            natwin.unload();
                            dd("Unloading native widget : OK");
                          },
                          false);

  natwin.load(scid, vwid);

  //  setTimeout( function() { natwin.load(); }, 0);
  //  evtarg.addEventListener("mouseover", function(){dump("***mouseover\n");}, false);
  dd("BindIframe: OK");

  // Update HW stereo menu
  this.updateHwStereoMenu();

  return natwin;
}

ctor.prototype.makeTabLabel = function (aScID, aVwID)
{
  var obj;

  obj = cuemol.getScene(aScID);
  var sc_name = obj.name;

  obj = cuemol.sceMgr.getView(aVwID);
  var vw_name = obj.name;

  return  sc_name+":"+vw_name;
}

ctor.prototype.addTab = function _addTab(aScID, aVwID)
{
  var t = document.createElementNS(
    "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",
    "tab");
  //window.alert("calling bind ("+aScID+", "+aVwID+")");
  
  var labeltext = this.makeTabLabel(aScID, aVwID);
  t.setAttribute("label", labeltext);
  t.setAttribute("tooltiptext", labeltext);
  t.setAttribute("crop", "end");
  t.setAttribute("flex", "1");
  // t.setAttribute("validate", "never");
  t.className = "tabmolview-tab";
  this._outer.mTabContainer.appendChild(t);
  t.setImpl(this);
  
  //window.alert("calling bind ("+aScID+", "+aVwID+")");
  
  var molview;
  var mvid = "render-widget-"+aScID+"-"+aVwID;
  if (this._outer.mUsePlugin) {
    molview = document.createElementNS("http://www.w3.org/1999/xhtml", "embed");
    molview.setAttribute("type", "application/cuemol2-plugin");
    dump("created plugin molview id="+mvid+"\n");
  }
  else {
    molview = document.createElementNS("http://www.w3.org/1999/xhtml", "iframe");
    dump("created iframe molview id="+mvid+"\n");
  }
  
  molview.setAttribute("style", "margin: 0px; padding: 0px; border: 0px; background-color: black;");
  molview.setAttribute("flex", "1");
  molview.setAttribute("id", mvid);
  molview.setAttribute("scid", aScID);
  molview.setAttribute("vwid", aVwID);
  //molview.setAttribute("tooltip", "tabmolview-tooltip");
  
  //window.alert("calling bind ("+aScID+", "+aVwID+")");
  this._outer.mPanelContainer.appendChild(molview);
  
  t.linkedView = molview;
  t.linkedSceneID = aScID;
  t.linkedViewID = aVwID;
  
  // Select the added tab
  this._outer.selectedTab = t;
  this.mActiveViewID = aVwID;
  var view = cuemol.getView(aVwID);
  view.active = true;
  delete view;
  
  var that = this;
  if (!this._outer.mUsePlugin) {
//    try { _bindIframeToNativeWidget(aScID, aVwID, mvid); }
//    catch (e) { debug.exception(e); }


    molview.contentWindow.addEventListener(
      "load",
      function(aEvent) {
        try { t.natwin = that._bindIframeToNativeWidget(aScID, aVwID, mvid); }
        catch (e) { debug.exception(e); }
      },
      false);

  }

  return t;
}

ctor.prototype.removeTab = function _removeTab(aTab)
{
  var l = this._outer.mTabContainer.childNodes.length;
  if (l==1) return;
  
  var index = -1;
  if (this._outer.selectedTab == aTab)
    index = this._outer.mTabContainer.selectedIndex;
  else {
    // Find and locate the tab in our list.
    for (var i = 0; i < l; i++)
      if (this._outer.mTabContainer.childNodes[i] == aTab)
        index = i;
  }
  
  //
  // cleanup molview
  //
  if ("unbind" in aTab.linkedView) {
    // unbind from the view
    aTab.linkedView.unbind();
  }

  // Dereference the native widget (XPCNativeWidget instance)
  if ("natwin" in aTab) {
    dd("Removing XPCNativeWidget obj: "+aTab.natwin);
    delete aTab.natwin;
  }

  var scene = this.getCurrentSceneW();

  // destroy the view
  scene.destroyView(aTab.linkedViewID);

  var nViewCnt = scene.getViewCount();
  if (nViewCnt==0) {
    // remove the scene
    cuemol.sceMgr.destroyScene(aTab.linkedSceneID);
  }

  //
  // cleanup UI
  //
  var currentIndex = this._outer.mTabContainer.selectedIndex;
  
  var oldTab = aTab;
  oldTab._selected = false;
  
  // Remove the tab
  this._outer.mTabContainer.removeChild(aTab);
  this._outer.mPanelContainer.removeChild(aTab.linkedView);
  
  // Find the tab to select
  var newIndex = -1;
  if (currentIndex > index)
    newIndex = currentIndex-1;
  else if (currentIndex < index)
    newIndex = currentIndex;
  else {
    newIndex = (index == l - 1) ? index - 1 : index;
  }
  
  // Select the new tab
  this.selectTab(newIndex);
  //this._outer.selectedTab = this._outer.mTabContainer.childNodes[newIndex];
  //this._outer.mTabBox.selectedPanel = this._outer.selectedTab.linkedView;
}

ctor.prototype.removeAllTabs = function _tabmolview_removeAllTabs()
{
  var childNodes = this._outer.mTabContainer.childNodes;
  var i, nTabs = childNodes.length;
  for (i=0; i<nTabs; ++i) {
    var tab = childNodes[i];
    try {
      // if (!("linkedSceneID" in tab)) continue; // not a tab instance!!
      var scene = cuemol.sceMgr.getScene(tab.linkedSceneID);
      scene.destroyView(tab.linkedViewID);
      var nViewCnt = scene.getViewCount();
      if (nViewCnt==0) {
        // remove the empty scene
        cuemol.sceMgr.destroyScene(tab.linkedSceneID);
      }

      // Dereference the native widget (XPCNativeWidget instance)
      if ("natwin" in tab) {
        delete tab.natwin;
      }

      this._outer.mTabContainer.removeChild(tab);
      this._outer.mPanelContainer.removeChild(tab.linkedView);
    }
    catch (e) {
      dd("Warning: tabmolview removeAllTabs, non-tab element at: "+i);
      debug.exception(e);
    }
  }
}

ctor.prototype.selectTab = function (aIndex)
{
  this._outer.selectedTab = this._outer.mTabContainer.childNodes[aIndex];
  this._outer.mTabBox.selectedPanel = this._outer.selectedTab.linkedView;
}

ctor.prototype.updateTabLabel = function (aTab)
{
  var label = this.makeTabLabel(aTab.linkedSceneID, aTab.linkedViewID);
  aTab.setAttribute("label", label);
  aTab.setAttribute("tooltiptext", label);
}

ctor.prototype.getCurrentSceneW = function ()
{
  if (!this._outer.selectedTab) {
    dump("getCurrSce(): no view\n");
    return null;
  }
  var scid = this._outer.selectedTab.linkedSceneID;
  if (!scid) {
    dump("getCurrSce(): scene ID is NULL\n");
    return null;
  }
  return cuemol.sceMgr.getScene(scid);
}

ctor.prototype.getCurrentViewW = function ()
{
  var vwid = this._outer.selectedTab.linkedViewID;
  //dump("**** getCurrVw() vwID="+vwid+"\n");
  if (!vwid) {
    dump("getCurrVw(): vw ID is NULL\n");
    return null;
  }
  //var scene = this.getCurrentSceneW();
  //if (!scene)
  //return null;
  return cuemol.getView(vwid);
}

ctor.prototype.onScenePropChanged = function (args)
{
  dd("TABMOLVIEW: onScenePropChnged, "+args.obj.propname);

  if ("propname" in args.obj && (
    args.obj.propname=="name")) {

    var childNodes = this._outer.mTabContainer.childNodes;
    var i, nTabs = childNodes.length;
    for (i=0; i<nTabs; ++i) {
      var tab = childNodes[i];

      if (tab.linkedSceneID!=args.srcUID)
        continue;

      this.updateTabLabel(tab);
    }

  }
}

/// Tab selection changed event handler
ctor.prototype.onTabSelect = function (aEvent)
{
  // Invalidate cached view/scene object
  this.mCurrentScene = null;
  this.mCurrentView = null;

  var view = this.getCurrentViewW();

  // Change the active view
  if (this.mActiveViewID) {
    var old_view = cuemol.getView(this.mActiveViewID);
    if (old_view)
      old_view.active = false;
  }
  view.active = true;
  
  delete view;

  this.updateHwStereoMenu();
}

/// Menu update functions (HW stereo)
ctor.prototype.updateHwStereoMenu = function ()
{
  var view = this.getCurrentViewW();

  var cmd = document.getElementById("cmd_toggle_hwstereo");
  var hwster = view.hasHWStereo;

  if (!hwster)
    cmd.setAttribute("disabled", "true");
  else
    cmd.removeAttribute("disabled");

  var hwstereo_menu = document.getElementById("view-menu-hwstereo");
  var smode = view.stereoMode;
  dd("OnTabASelect> Stereo mode: "+smode);
  if (smode=="hardware")
    hwstereo_menu.setAttribute("checked", "true");
  else
    hwstereo_menu.removeAttribute("checked");

  delete view;
}

ctor.prototype.onMouse = function (aEvent)
{
  dd("***onMouse type="+aEvent.type+", target="+aEvent.target);
  var that = this;

  switch (aEvent.type) {
  case "mousemove":
    this.setCursor("auto");
    if (this.mToolTip)
      this.mToolTip.hidePopup();
    if (this.mHoverTimeoutID)
      window.clearTimeout(this.mHoverTimeoutID);

    this.mHoverTimeoutID = window.setTimeout(
      function (e) { that.onHover(e); }, this.mHoverDelay, aEvent);
    break;

  case "mouseout":
    this.setCursor("auto");
    if (this.mToolTip)
      this.mToolTip.hidePopup();
    if (this.mHoverTimeoutID)
      window.clearTimeout(this.mHoverTimeoutID);
    break;
  }
  
}

ctor.prototype.onHover = function (aEvent)
{
  var x = aEvent.clientX;
  var y = aEvent.clientY;
  dd("** HOVER ** "+x+", "+y);

  var view = this.getCurrentViewW();
  var sres;
  try {
    sres = view.hitTest(x, y);
    dump("Hittest result: "+sres+"\n");
  }
  catch(e) {
    debug.exception(e);
    return;
  }

  if (sres.length==0) return;

  var res;
  try {
    res = JSON.parse(sres);
  }
  catch (e) {
    dd("error : "+sres);
    debug.exception(e);
    return;
  }

  if (res.objtype=="MolCoord") {
    var label = "Molecule ["+res.obj_name+"], "+res.data[0].message;

    // dd("set status line: "+label);
    // dd("status line: "+gQm2Main.mStatusLabel);
    // gQm2Main.mStatusLabel.label = label;

    var molview = this._outer.mPanelContainer.selectedPanel;
    if (this.mToolTip) {
      this.mToolTip.label = label;
      this.mToolTip.openPopup(molview, "overlap", x, y);
    }
    this.setCursor("pointer");
  }
}

ctor.prototype.setCursor = function (aCursor)
{
  var molview = this._outer.mPanelContainer.selectedPanel;
  if (molview)
    molview.contentWindow.setCursor(aCursor);
}

ctor.prototype.getTabByViewId = function (viewid)
{
  var childNodes = this._outer.mTabContainer.childNodes;
  var i, nTabs = childNodes.length;
  for (i=0; i<nTabs; ++i) {
    var tab = childNodes[i];
    if (tab.linkedViewID==viewid)
      return tab;
  }

  // not found
  return null;
}

ctor.prototype.populateAllTabMenu = function (aEvent)
{
  var menu = aEvent.currentTarget;
  dd("PopulateAllTabMenu: "+menu.id);

  while (menu.firstChild)
    menu.removeChild(menu.firstChild);

  var childNodes = this._outer.mTabContainer.childNodes;
  var i, nTabs = childNodes.length;
  for (i=0; i<nTabs; ++i) {
    var tab = childNodes[i];
    var item = util.appendMenu(document, menu, i, tab.label);
    item.setAttribute("type", "checkbox");
    if (tab==this._outer.selectedTab) {
      dd("============= tab selected: "+tab.label);
      item.setAttribute("checked", true);
    }
  }

}

ctor.prototype.onCmdTabMenu = function (aEvent)
{
  //dd("selecteed: "+aEvent.target.value);
  var newIndex = parseInt(aEvent.target.value);
  if (newIndex===NaN)
    return;
  this.selectTab(newIndex);
}

return ctor;

} )();

}

