/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_MODIFIER_INCLUDED
#define FIT_MODIFIER_INCLUDED

#include "CommandOption.h"
#include "PlotModifier.h"

class QString;

//! fit コマンドのオプション
class FitModifier : public CommandOption
{
	public:
		FitModifier();

		void setIndex(int m, int n = -1, int p = -1);
		int m() const;
		int n() const;
		int p() const;

		void setEvery(int pointIncr, int blockIncr,
				int startPoint, int startBlock,
				int endPoint, int endBlock);
		int pointIncrement() const;
		int blockIncrement() const;
		int startPoint() const;
		int startBlock() const;
		int endPoint() const;
		int endBlock() const;

		void setUsing(const QStringList &entry, const QString &format);
		const QStringList &entry() const;
		const QString &format() const;

		QString option() const;
	private:
		PlotModifier plotModifier;
};
#endif // FIT_MODIFIER_INCLUDED
