/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef CONSOLE_SCROLL_AREA_INCLUDED
#define CONSOLE_SCROLL_AREA_INCLUDED

class QResizeEvent;
#include <QtGui/QAbstractScrollArea>

class ConsoleScrollArea : public QAbstractScrollArea
{
	Q_OBJECT

	public:
		explicit ConsoleScrollArea(QWidget *parent = 0);
		void append(const QString &text);
		
		void setLocked(bool status);
		bool isLocked() const;

	signals:
		/*!
		 * \brief このシグナルはコマンドを実行するときに発信される
		 * \param command 実行するコマンド
		 */
		void executed(const QString &command);

	private:
		// don't implement these
		ConsoleScrollArea(const ConsoleScrollArea &);
		ConsoleScrollArea &operator=(const ConsoleScrollArea &);

		void keyPressEvent(QKeyEvent *e);
		void paintEvent(QPaintEvent *event);
		void resizeEvent(QResizeEvent *event);

		const static char * const REPCHAR;
		QStringList rowList;
		int fontHeight;
		int fontLineSpacing;
		int fontWidth;
		int numY;
		int numX;
		bool lock;
		int cuX;
		int cuY;
};
#endif // CONSOLE_SCROLL_AREA_INCLUDED
