/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "AxisDataOptionWidget.h"
#include "AxisData.h"

#include <QtGui/QCheckBox>
#include <QtGui/QLabel>
#include <QtGui/QGridLayout>

AxisDataOptionWidget::AxisDataOptionWidget(QWidget *parent)
: OptionWidget(parent), axisData(0)
{
	setWindowTitle(tr("Data"));
}

AxisDataOptionWidget::~AxisDataOptionWidget()
{
	while (!timeCheckBoxList.isEmpty()) {
		delete timeCheckBoxList.takeFirst();
	}
	delete axisData;
}

void AxisDataOptionWidget::construct()
{
	setWhatsThis(tr("set &lt;axis&gt;data"));

	for (int i = 0; !AxisData::AXIS[i].isEmpty(); i++) {
		QCheckBox *timeCheckBox = new QCheckBox;
		timeCheckBox->setText(tr("Time/Date"));
		connect(timeCheckBox, SIGNAL(toggled(bool)),
				this, SIGNAL(modified()));
		timeCheckBoxList.append(timeCheckBox);
	}

	QGridLayout *mainLayout = new QGridLayout;
	for (int i = 0; !AxisData::AXIS[i].isEmpty(); i++) {
		QLabel *timeLabel = new QLabel;
		timeLabel->setText(AxisData::AXIS[i] + tr(" axis:"));

		mainLayout->addWidget(timeLabel, i, 0);
		mainLayout->addWidget(timeCheckBoxList[i], i, 1);
	}
	mainLayout->addItem(new QSpacerItem(0, 0, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 1);
	mainLayout->addItem(new QSpacerItem(0, 0,
				QSizePolicy::Minimum, QSizePolicy::Expanding),
			timeCheckBoxList.size(), 0);

	setLayout(mainLayout);
}

void AxisDataOptionWidget::init()
{
	delete axisData;
	axisData = new AxisData;
	setWidget();
}
void AxisDataOptionWidget::apply()
{
	for (int i = 0; !AxisData::AXIS[i].isEmpty(); i++) {
		axisData->setTime(i, timeCheckBoxList.at(i)->isChecked());
	}
	emit executed(axisData->command());
}

void AxisDataOptionWidget::setWidget()
{
	for (int i = 0; !AxisData::AXIS[i].isEmpty(); i++) {
		timeCheckBoxList[i]->setChecked(axisData->isTime(i));
	}
}
