/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "AxisOptionWidget.h"

#include <QtGui/QComboBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QLabel>
#include <QtGui/QVBoxLayout>

AxisOptionWidget::AxisOptionWidget(QWidget *parent)
: OptionWidget(parent), prevAxis(0)
{
}

AxisOptionWidget::~AxisOptionWidget()
{
}

void AxisOptionWidget::construct()
{
	axisComboBox = new QComboBox;
	connect(axisComboBox, SIGNAL(activated(int)),
			this, SLOT(changeAxis(int)));

	QLabel *axisLabel = new QLabel;
	axisLabel->setText(tr("A&xis:"));
	axisLabel->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
	axisLabel->setBuddy(axisComboBox);

	QWidget *widget = new QWidget;
	constructWidget(widget);

	QHBoxLayout *selectLayout = new QHBoxLayout;
	selectLayout->addWidget(axisLabel);
	selectLayout->addWidget(axisComboBox);

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addLayout(selectLayout);
	mainLayout->addWidget(widget);
	setLayout(mainLayout);
}

void AxisOptionWidget::changeAxis(int axis)
{
	setOption(prevAxis);
	blockSignals(true);
	setAxisWidget(axis);
	blockSignals(false);
	prevAxis = axis;
}

void AxisOptionWidget::apply()
{
	setOption(axisComboBox->currentIndex());
}

void AxisOptionWidget::setWidget()
{
	setAxisWidget(axisComboBox->currentIndex());
}
