/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef AXIS_OPTION_WIDGET_INCLUDED
#define AXIS_OPTION_WIDGET_INCLUDED

#include "OptionWidget.h"

class QComboBox;

class AxisOptionWidget : public OptionWidget
{
	Q_OBJECT

	public:
		explicit AxisOptionWidget(QWidget *parent = 0);
		virtual ~AxisOptionWidget();

		virtual void construct();

	protected:
		virtual void apply();
		void setWidget();
		/*!
		 * \brief 各軸について存在する設定項目を扱うウィジェットを構築する
		 * \param widget 親ウィジェット
		 */
		virtual void constructWidget(QWidget *widget) = 0;
		/*!
		 * \brief ウィジェットの状態をメンバ変数のオブジェクトに適用させる
		 * \param axis 軸
		 */
		virtual void setOption(int axis) = 0;
		/*!
		 * \brief メンバ変数のオブジェクトの状態をウィジェットに適用させる
		 * \param axis 軸
		 */
		virtual void setAxisWidget(int axis) = 0;
		//! 前の軸
		int prevAxis;
		//! 設定できる軸が項目として含まれるコンボボックス
		QComboBox *axisComboBox;

	private slots:
		 void changeAxis(int axis);

	private:
		// don't implement these
		AxisOptionWidget(const AxisOptionWidget &);
		AxisOptionWidget &operator=(const AxisOptionWidget &);
};
#endif // AXIS_OPTION_WIDGET_INCLUDED
