/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "FormatOptionWidget.h"
#include "Format.h"

#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>

FormatOptionWidget::FormatOptionWidget(QWidget *parent)
: OptionWidget(parent), format(0)
{
	setWindowTitle(tr("Format"));
}

FormatOptionWidget::~FormatOptionWidget()
{
	while (!formatLineEditList.isEmpty()) {
		delete formatLineEditList.takeFirst();
	}
	delete format;
}

void FormatOptionWidget::construct()
{
	setWhatsThis("set format");

	for (int i = 0; !Format::AXIS[i].isEmpty(); i++) {
		QLineEdit *formatLineEdit = new QLineEdit;
		connect(formatLineEdit, SIGNAL(textChanged(const QString &)),
				this, SIGNAL(modified()));
		formatLineEditList.append(formatLineEdit);
	}

	QGridLayout *mainLayout = new QGridLayout;
	for (int i = 0; !Format::AXIS[i].isEmpty(); i++) {
		QLabel *formatLabel = new QLabel;
		formatLabel->setText(Format::AXIS[i] + tr(" axis:"));

		mainLayout->addWidget(formatLabel, i, 0);
		mainLayout->addWidget(formatLineEditList[i], i, 1);
	}
	mainLayout->addItem(new QSpacerItem(0, 0, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addItem(new QSpacerItem(0, 0,
				QSizePolicy::Minimum, QSizePolicy::Expanding),
			formatLineEditList.size(), 0);

	setLayout(mainLayout);
}

void FormatOptionWidget::init()
{
	delete format;
	format = new Format;
	setWidget();
}
void FormatOptionWidget::apply()
{
	for (int i = 0; !Format::AXIS[i].isEmpty(); i++) {
		format->setFormatString(i, formatLineEditList.at(i)->text());
	}
	emit executed(format->command());
}

void FormatOptionWidget::setWidget()
{
	for (int i = 0; !Format::AXIS[i].isEmpty(); i++) {
		formatLineEditList[i]->setText(format->formatString(i));
	}
}
