/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSMessageReceiver;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSConnectionFactory {
    private static final Log log = LogFactory.getLog((Class)JMSConnectionFactory.class);
    private String name = null;
    private String jndiName = null;
    private String jndiUser = null;
    private String jndiPass = null;
    private Map serviceJNDINameMapping = null;
    private Map serviceDestinationMapping = null;
    private Map jmsSessions = null;
    private Hashtable properties = null;
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private Connection connection = null;
    private JMSMessageReceiver msgRcvr = null;
    private String user = null;
    private String pass = null;

    JMSConnectionFactory(String name, String jndiName) {
        this.name = name;
        this.jndiName = jndiName;
        this.serviceJNDINameMapping = new HashMap();
        this.serviceDestinationMapping = new HashMap();
        this.properties = new Hashtable();
        this.jmsSessions = new HashMap();
    }

    JMSConnectionFactory(String name) {
        this(name, null);
    }

    public void connect() throws NamingException {
        if (this.context == null) {
            this.createInitialContext();
        }
        this.conFactory = (ConnectionFactory)this.context.lookup(this.jndiName);
        if (this.jndiUser != null) {
            this.user = (String)this.context.lookup(this.jndiUser);
        }
        if (this.jndiPass != null) {
            this.pass = (String)this.context.lookup(this.jndiPass);
        }
        log.debug((Object)("Connected to the actual connection factory : " + this.jndiName));
    }

    private void createInitialContext() throws NamingException {
        this.context = new InitialContext(this.properties);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setJndiUser(String jndiUser) {
        this.jndiUser = jndiUser;
    }

    public void setJndiPass(String jndiPass) {
        this.jndiPass = jndiPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestination(String destinationJndi, String serviceName) {
        this.serviceJNDINameMapping.put(destinationJndi, serviceName);
        String destinationName = this.getDestinationName(destinationJndi);
        if (destinationName == null) {
            log.warn((Object)("JMS Destination with JNDI name : " + destinationJndi + " does not exist"));
            Connection con = null;
            try {
                con = this.jndiUser == null || this.jndiPass == null ? this.conFactory.createConnection() : this.conFactory.createConnection(this.user, this.pass);
                Session session = con.createSession(false, 1);
                Queue queue = session.createQueue(destinationJndi);
                destinationName = queue.getQueueName();
                log.warn((Object)("JMS Destination with JNDI name : " + destinationJndi + " created"));
            }
            catch (JMSException e) {
                log.error((Object)("Unable to create a Destination with JNDI name : " + destinationJndi), (Throwable)e);
                JMSUtils.markServiceAsFaulty((String)this.serviceJNDINameMapping.get(destinationJndi), "Error looking up JMS destination : " + destinationJndi, this.msgRcvr.getAxisConf().getAxisConfiguration());
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (JMSException ignore) {}
                }
            }
        }
        this.serviceDestinationMapping.put(destinationName, serviceName);
        log.info((Object)("Mapping JNDI name : " + destinationJndi + " and JMS Destination name : " + destinationName + " against service : " + serviceName));
    }

    public void removeDestination(String destinationJndi) throws JMSException {
        String providerSpecificDestination = this.getDestinationName(destinationJndi);
        this.stoplistenOnDestination(destinationJndi);
        this.serviceJNDINameMapping.remove(destinationJndi);
        if (providerSpecificDestination != null) {
            this.serviceDestinationMapping.remove(providerSpecificDestination);
        }
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getJndiUser() {
        return this.jndiUser;
    }

    public String getJndiPass() {
        return this.jndiPass;
    }

    public String getPass() {
        return this.pass;
    }

    public String getUser() {
        return this.user;
    }

    public ConnectionFactory getConFactory() {
        return this.conFactory;
    }

    public Map getDestinations() {
        return this.serviceJNDINameMapping;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void listen(JMSMessageReceiver msgRcvr) throws JMSException {
        this.msgRcvr = msgRcvr;
        log.debug((Object)("Connection factory : " + this.name + " initializing..."));
        if (this.conFactory == null || this.context == null) {
            this.handleException("Connection factory must be 'connected' before listening");
        } else {
            try {
                this.connection = this.jndiUser == null || this.jndiPass == null ? this.conFactory.createConnection() : this.conFactory.createConnection(this.user, this.pass);
            }
            catch (JMSException e) {
                this.handleException("Error creating a JMS connection using the factory : " + this.jndiName, (Exception)((Object)e));
            }
        }
        Iterator iter = this.serviceJNDINameMapping.keySet().iterator();
        while (iter.hasNext()) {
            String destinationJndi = (String)iter.next();
            this.listenOnDestination(destinationJndi);
        }
        this.connection.start();
        log.info((Object)("Connection factory : " + this.name + " initialized..."));
    }

    public void listenOnDestination(String destinationJndi) throws JMSException {
        Session session = this.connection.createSession(false, 1);
        Destination destination = null;
        try {
            Object o = this.context.lookup(destinationJndi);
            destination = (Destination)o;
        }
        catch (NameNotFoundException e) {
            log.warn((Object)("Cannot find destination : " + destinationJndi + " Creating a Queue with this name"));
            destination = session.createQueue(destinationJndi);
        }
        catch (NamingException e) {
            log.warn((Object)("Error looking up destination : " + destinationJndi), (Throwable)e);
            JMSUtils.markServiceAsFaulty((String)this.serviceJNDINameMapping.get(destinationJndi), "Error looking up JMS destination : " + destinationJndi, this.msgRcvr.getAxisConf().getAxisConfiguration());
        }
        MessageConsumer consumer = session.createConsumer(destination);
        consumer.setMessageListener((MessageListener)this.msgRcvr);
        this.jmsSessions.put(destinationJndi, session);
    }

    private void stoplistenOnDestination(String destinationJndi) throws JMSException {
        ((Session)this.jmsSessions.get(destinationJndi)).close();
    }

    public String getServiceNameForDestination(String destination) {
        return (String)this.serviceJNDINameMapping.get(destination);
    }

    public void stop() {
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            log.warn((Object)("Error shutting down connection factory : " + this.name), (Throwable)e);
        }
    }

    public String getDestinationName(String destinationJndi) {
        try {
            Destination destination = (Destination)this.context.lookup(destinationJndi);
            if (destination != null && destination instanceof Queue) {
                return ((Queue)destination).getQueueName();
            }
            if (destination != null && destination instanceof Topic) {
                return ((Topic)destination).getTopicName();
            }
        }
        catch (JMSException e) {
            log.warn((Object)("Error reading provider specific JMS destination name for destination with JNDI name : " + destinationJndi), (Throwable)e);
        }
        catch (NamingException e) {
            log.warn((Object)("Error looking up destination with JNDI name : " + destinationJndi + " to map its corresponding provider specific Destination name"));
        }
        return null;
    }

    public EndpointReference getEPRForDestination(String destination) {
        StringBuffer sb = new StringBuffer();
        sb.append("jms:/").append(destination);
        sb.append("?").append("transport.jms.ConnectionFactoryJNDIName").append("=").append(this.getJndiName());
        Iterator props = this.getProperties().keySet().iterator();
        while (props.hasNext()) {
            String key = (String)props.next();
            String value = (String)this.getProperties().get(key);
            sb.append("&").append(key).append("=").append(value);
        }
        return new EndpointReference(sb.toString());
    }

    public String getServiceByDestination(String destinationName) {
        return (String)this.serviceDestinationMapping.get(destinationName);
    }

    private void handleException(String msg) throws AxisJMSException {
        log.error((Object)msg);
        throw new AxisJMSException(msg);
    }

    private void handleException(String msg, Exception e) throws AxisJMSException {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }
}

