/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.addressbook.beans;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * AddressBookGroupMemberListのBeanです。 社外グループに所属している 「個人名(個人アドレス.姓 + 個人アドレス.名)」
 * 「AddressId」 をセットします。
 * 
 * @see ALData
 */
public class AddressBookGroupMemberListBean implements ALData {

  /** アドレスID */
  private ALNumberField address_id;

  /** 社外グループに所属している個人名 */
  private ALStringField group_member_name;

  // add start
  /** オーナーID */
  private ALNumberField owner_id;

  // add end
  /**
   * オブジェクトのフィールドを初期化するメソッドです。
   */
  public void initField() {
    address_id = new ALNumberField();
    group_member_name = new ALStringField();
    // add start
    owner_id = new ALNumberField();
    // add end
  }

  /**
   * @param string
   *          個人名
   */
  public void setGroupMemberName(String string) {
    group_member_name.setValue(string);
  }

  /**
   * @return string 個人名
   */
  public String getGroupMemberName() {
    return group_member_name.getValue();
  }

  /**
   * @param int アドレスID
   */
  public void setAddressId(int addressId) {
    address_id.setValue(addressId);
  }

  /**
   * @return string アドレスID
   */
  public String getAddressId() {
    return address_id.toString();
  }

  /**
   * @param int オーナーID
   */
  public void setOwnerId(int ownerId) {
    owner_id.setValue(ownerId);
  }

  /**
   * @return string オーナーID
   */
  public String getOwnerId() {
    return owner_id.toString();
  }
}
