/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.net.URLEncoder;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.cayenne.om.portlet.AvzTScheduleFile;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.schedule.util.ScheduleUtils;

/**
 * スケジュールの添付ファイルの一覧を処理するクラスです。
 */
public class ScheduleFileRawScreen extends FileuploadRawScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(ScheduleFileRawScreen.class.getName());

  /**
   * 
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata) throws Exception {
    try {
      AvzTScheduleFile file = ScheduleUtils.getAvzTScheduleFile(rundata);

      super.setFilePath(ScheduleUtils.getSaveDirPath(Database.getDomainName(), file.getOwnerId().intValue()) + file.getFilePath());
      // change start 要件No.11 メール作成／詳細（ファイル添付）
      // super.setFileName(file.getFileName());
      // ファイル名はURLエンコードする。（エンコードすると半角スペースが+に置き変わってしまうため、%20に置換する）
      String fileName = URLEncoder.encode(file.getFileName(), "UTF-8").replaceAll("\\+", "%20");
      super.setFileName(fileName);
      // change end
      super.doOutput(rundata);
    } catch (Exception e) {
      logger.error("[ERROR]", e);
    }
  }
}
