/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule.beans;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.aimluck.commons.field.ALCellDateField;
import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALCellNumberField;
import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.schedule.AbstractCellScheduleFormData;
import com.aimluck.eip.schedule.ScheduleConst;
import com.aimluck.eip.schedule.util.CellScheduleUtils;
import com.aimluck.eip.schedule.util.ScheduleUtils;

/**
 * 携帯版スケジュールのフォームデータを管理するクラスです。
 * 
 */
public class CellScheduleFormBean implements ALData, Cloneable {

  /** <code>start_date</code> 開始日時 */
  private ALCellDateTimeField start_date;

  /** <code>end_date</code> 終了日時 */
  private ALCellDateTimeField end_date;

  /** <code>end_date</code> 指定日時 */
  private ALCellDateTimeField view_date;

  /** <code>repeat_type</code> 繰り返し種別 */
  private ALCellStringField repeat_type;

  /** <code>week_0</code> 繰り返し曜日 */
  private ALCellStringField week_0;

  /** <code>week_1</code> 繰り返し曜日 */
  private ALCellStringField week_1;

  /** <code>week_2</code> 繰り返し曜日 */
  private ALCellStringField week_2;

  /** <code>week_3</code> 繰り返し曜日 */
  private ALCellStringField week_3;

  /** <code>week_4</code> 繰り返し曜日 */
  private ALCellStringField week_4;

  /** <code>week_5</code> 繰り返し曜日 */
  private ALCellStringField week_5;

  /** <code>week_6</code> 繰り返し曜日 */
  private ALCellStringField week_6;

  /** <code>limit_flag</code> 期限ありなし */
  private ALCellStringField limit_flag;

  /** <code>limit_date</code> 繰り返し期限（開始日） */
  private ALCellDateField limit_start_date;

  /** <code>limit_date</code> 繰り返し期限（終了日） */
  private ALCellDateField limit_end_date;

  // remove start
  // /** <code>month_day</code> 繰り返す日 */
  // private ALCellNumberField month_day;

  /** <code>edit_schedule_flag</code> 繰り返しスケジュールの編集フラグ */
  private ALCellNumberField edit_repeat_flag;

  // remove end
  // change start
  // /** <code>memberList</code> メンバーリスト */
  /** <code>memberList</code> 参加ユーザー(必須)リスト */
  // change end
  private List<ALEipUser> memberList;

  // remove start
  // 共有施設設定は未使用のため削除
  /** <code>memberList</code> 施設メンバーリスト */
  // private List<FacilityResultData> facilityMemberList;

  // /** <code>edit_control_flag</code> 共有メンバーによる編集／削除権限フラグ */
  // private ALCellStringField edit_flag;
  //
  // /** <code>enable_change_tmpreserve</code> 仮スケジュールに戻すかどうか */
  // private ALCellStringField change_tmpreserve_flag;

  // remove end
  /** <code>currentYear</code> 現在の年 */
  private int current_year;

  // add start

  /** <code>memberList</code> 参加ユーザー(任意)リスト */
  private List<ALEipUser> submemberList;

  /** <code>day_interval</code> 繰り返しスケジュール「日指定」日間隔 */
  private ALCellNumberField day_interval;

  /** <code>week_interval</code> 繰り返しスケジュール「週指定」週間隔 */
  private ALCellNumberField week_interval;

  /** <code>md_month_interval</code> 繰り返しスケジュール「月->日指定」月間隔 */
  private ALCellNumberField md_month_interval;

  /** <code>md_day</code> 繰り返しスケジュール「月->日指定」日 */
  private ALCellNumberField md_day;

  /** <code>mw_month_interval</code> 繰り返しスケジュール「月->曜日指定 」月間隔 */
  private ALCellNumberField mw_month_interval;

  /** <code>mw_count</code> 繰り返しスケジュール「月->曜日指定 」週 */
  private ALCellNumberField mw_count;

  /** <code>mw_dow</code> 繰り返しスケジュール「月->曜日指定 」曜日 */
  private ALCellNumberField mw_dow;

  /** <code>ymd_month</code> 繰り返しスケジュール「年->月日指定 」月間隔 */
  private ALCellNumberField ymd_month;

  /** <code>ymd_day</code> 繰り返しスケジュール「年->月日指定 」日 */
  private ALCellNumberField ymd_day;

  /** <code>ymw_month</code> 繰り返しスケジュール「年->曜日指定 」月間隔 */
  private ALCellNumberField ymw_month;

  /** <code>ymw_count</code> 繰り返しスケジュール「年->曜日指定 」週 */
  private ALCellNumberField ymw_count;

  /** <code>ymw_dow</code> 繰り返しスケジュール「年->曜日指定 」曜日 */
  private ALCellNumberField ymw_dow;

  /** 反復回数 */
  private ALCellNumberField repeat_num;

  // add end
  public void initField() {
    initField(null, null, null);
  }

  public void initField(String tmpStart, String tmpEnd, String tmpView) {
    Calendar cal = Calendar.getInstance();
    // remove start
    // 時刻は1分単位表示のため削除
    // int min = cal.get(Calendar.MINUTE);
    // if (min <= 15) {
    // cal.set(Calendar.MINUTE, 15);
    // } else if (min <= 30) {
    // cal.set(Calendar.MINUTE, 30);
    // } else if (min <= 45) {
    // cal.set(Calendar.MINUTE, 45);
    // } else {
    // cal.set(Calendar.MINUTE, 60);
    // }
    // remove
    Date now = cal.getTime();

    // 開始日時
    start_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
    if (tmpStart == null || tmpStart.equals("")) {
      start_date.setValue(now);
    } else {
      start_date.setValue(tmpStart);
    }
    start_date.setFieldName("開始日時");

    // 終了日時
    end_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
    if (tmpEnd == null || tmpEnd.equals("")) {
      if (tmpStart == null || tmpStart.equals("")) {
        end_date.setValue(now);
      } else {
        end_date.setValue(tmpStart);
      }
    } else {
      end_date.setValue(tmpEnd);
    }
    end_date.setFieldName("終了日時");

    // 指定日時
    view_date = new ALCellDateTimeField("yyyy-MM-dd");
    if (tmpView == null || tmpView.equals("")) {
      view_date.setValue(now);
    } else {
      view_date.setValue(tmpView);
    }
    view_date.setFieldName("指定日時");

    // 繰り返しタイプ
    repeat_type = new ALCellStringField();
    repeat_type.setFieldName("繰り返しタイプ");
    repeat_type.setValue("D");
    repeat_type.setTrim(true);

    // 日
    week_0 = new ALCellStringField();
    week_0.setFieldName("日");
    week_0.setTrim(true);

    // 月
    week_1 = new ALCellStringField();
    week_1.setFieldName("月");
    week_1.setTrim(true);

    // 火
    week_2 = new ALCellStringField();
    week_2.setFieldName("火");
    week_2.setTrim(true);

    // 水
    week_3 = new ALCellStringField();
    week_3.setFieldName("水");
    week_3.setTrim(true);

    // 木
    week_4 = new ALCellStringField();
    week_4.setFieldName("木");
    week_4.setTrim(true);

    // 金
    week_5 = new ALCellStringField();
    week_5.setFieldName("金");
    week_5.setTrim(true);

    // 土
    week_6 = new ALCellStringField();
    week_6.setFieldName("土");
    week_6.setTrim(true);

    // remove start
    // // 繰り返し日（選択されたときのみ Validate する）
    // month_day = new ALCellNumberField();
    // month_day.setFieldName("毎月の日");
    // month_day.limitValue(1, 31);
    // remove end
    // 繰り返しフラグ
    limit_flag = new ALCellStringField();
    limit_flag.setFieldName("繰り返し");
    // change start
    // limit_flag.setValue("OFF");
    limit_flag.setValue("non");
    // change end
    limit_flag.setTrim(true);

    // 繰り返し期限
    limit_start_date = new ALCellDateField();
    // change start
    // limit_start_date.setFieldName("繰り返し期限");
    limit_start_date.setFieldName("開始日");
    limit_start_date.setNotNull(true);
    // change end
    limit_start_date.setValue(start_date.getValue());
    limit_end_date = new ALCellDateField();
    // change start
    // limit_end_date.setFieldName("繰り返し期限");
    limit_end_date.setFieldName("終了日");
    // change end
    ALCellDateTimeField tmp_date = new ALCellDateTimeField("yyyy-MM-dd-HH-mm");
    if (tmpEnd == null || tmpEnd.equals("")) {
      if (tmpStart == null || tmpStart.equals("")) {
        tmp_date.setValue(now);
        limit_end_date.setValue(tmp_date.getValue());
      } else {
        tmp_date.setValue(tmpStart);
        limit_end_date.setValue(tmp_date.getValue());
      }
    } else {
      tmp_date.setValue(tmpEnd);
      limit_end_date.setValue(tmp_date.getValue());
    }

    // 繰り返しスケジュールの編集フラグ
    edit_repeat_flag = new ALCellNumberField();
    edit_repeat_flag.setFieldName("繰り返し編集範囲");
    edit_repeat_flag
      .setValue(AbstractCellScheduleFormData.FLAG_EDIT_REPEAT_DEF);

    // change start
    // // メンバーリスト
    // 参加ユーザー(必須)リスト
    // change end
    memberList = new ArrayList<ALEipUser>();

    // 参加ユーザー(任意)リスト
    submemberList = new ArrayList<ALEipUser>();

    // remove start
    // 施設リスト
    // facilityMemberList = new ArrayList<FacilityResultData>();

    // // 共有メンバーによる編集／削除権限フラグ
    // edit_flag = new ALCellStringField();
    // edit_flag.setFieldName("編集／削除権限");
    // edit_flag.setTrim(true);
    // edit_flag.setValue("T");
    //
    // // 仮スケジュールに戻すかどうか
    // change_tmpreserve_flag = new ALCellStringField();
    // change_tmpreserve_flag.setFieldName("仮スケジュール");
    // change_tmpreserve_flag.setTrim(true);
    // change_tmpreserve_flag.setValue("F");
    // remove end
    // 現在の年（年を選択するリストボックスに利用）
    current_year = Calendar.getInstance().get(Calendar.YEAR);

    // add start
    // 繰り返しスケジュール 日指定の日付間隔
    day_interval = new ALCellNumberField();
    day_interval.setFieldName("日指定の日付間隔");
    day_interval.setNotNull(true);
    day_interval.limitValue(1L, 999L);

    // 繰り返しスケジュール 週指定の週間隔
    week_interval = new ALCellNumberField();
    week_interval.setFieldName("週指定の週間隔");
    week_interval.setNotNull(true);
    week_interval.limitValue(1L, 99L);

    // 繰り返しスケジュール 月->日指定の月間隔
    md_month_interval = new ALCellNumberField();
    md_month_interval.setFieldName("月->日指定の月間隔");
    md_month_interval.setNotNull(true);
    md_month_interval.limitValue(1L, 99L);

    // 繰り返しスケジュール 月->日指定の日
    md_day = new ALCellNumberField();
    md_day.setFieldName("月->日指定の日");
    md_day.setNotNull(true);
    md_day.limitValue(1L, 99L);

    // 繰り返しスケジュール 月->曜日指定の月間隔
    mw_month_interval = new ALCellNumberField();
    mw_month_interval.setFieldName("月->曜日指定の月間隔");
    mw_month_interval.setNotNull(true);
    mw_month_interval.limitValue(1L, 99L);
    // 繰り返しスケジュール 月->曜日指定の週
    mw_count = new ALCellNumberField();
    mw_count.setFieldName("月->曜日指定の週");

    // 繰り返しスケジュール 月->曜日指定の曜日
    mw_dow = new ALCellNumberField();
    mw_dow.setFieldName("月->曜日指定の曜日");

    // 繰り返しスケジュール 年->月日指定の月間隔
    ymd_month = new ALCellNumberField();
    ymd_month.setFieldName("年->月日指定の月間隔");

    // 繰り返しスケジュール 年->月日指定の日
    ymd_day = new ALCellNumberField();
    ymd_day.setFieldName("年->月日指定の日");

    // 繰り返しスケジュール 年->曜日指定の月間隔
    ymw_month = new ALCellNumberField();
    ymw_month.setFieldName("年->曜日指定の月間隔");

    // 繰り返しスケジュール 年->曜日指定の週
    ymw_count = new ALCellNumberField();
    ymw_count.setFieldName("年->曜日指定の週");

    // 繰り返しスケジュール 年->曜日指定の曜日
    ymw_dow = new ALCellNumberField();
    ymw_dow.setFieldName("年->曜日指定の曜日");

    // 反復回数
    repeat_num = new ALCellNumberField();
    repeat_num.setFieldName("反復回数");
    repeat_num.setNotNull(true);
    repeat_num.limitValue(1L, 999L);

    // add end

  }

  public void setResultData(EipTSchedule record) {
    // DN -> 毎日 (A = N -> 期限なし A = L -> 期限あり)
    // WnnnnnnnN W01111110 -> 毎週(月～金用)
    // MnnN M25 -> 毎月25日
    // S -> 期間での指定
    String ptn = record.getRepeatPattern();
    // remove start
    // 不要なため削除
    // int count = 0;
    // remove end
    // add start

    // 毎日
    boolean is_repeat = true;
    @SuppressWarnings("unused")
    boolean is_span = false;

    if (ptn.charAt(0) == 'D') {
      repeat_type.setValue("D");
      // remove start
      // count = 1;
      // remove end
    } else if (ptn.charAt(0) == 'W') {
      repeat_type.setValue("W");
      week_0.setValue(ptn.charAt(1) != '0' ? "TRUE" : null);
      week_1.setValue(ptn.charAt(2) != '0' ? "TRUE" : null);
      week_2.setValue(ptn.charAt(3) != '0' ? "TRUE" : null);
      week_3.setValue(ptn.charAt(4) != '0' ? "TRUE" : null);
      week_4.setValue(ptn.charAt(5) != '0' ? "TRUE" : null);
      week_5.setValue(ptn.charAt(6) != '0' ? "TRUE" : null);
      week_6.setValue(ptn.charAt(7) != '0' ? "TRUE" : null);
      // remove start
      // count = 8;
      // remove end
    } else if (ptn.charAt(0) == 'M') {
      repeat_type.setValue("M");
      // remove start
      // month_day.setValue(Integer.parseInt(ptn.substring(1, 3)));
      // count = 3;
      // remove end
      // add start
      // 定期パターン増加対応
    } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_DAILY)) {
      // 間隔 X日ごとに設定 AxxxN
      repeat_type.setValue(ScheduleConst.CELL_REPEAT_TYPE_DAY);
      day_interval.setValue(ptn.substring(1, 4));
    } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_WEEKLY)) {
      // 間隔 X週ごとに設定 BxxnnnnnnnL
      repeat_type.setValue(ScheduleConst.CELL_REPEAT_TYPE_WEEK);
      week_interval.setValue(Integer.parseInt(ptn.substring(1, 3)));
      week_0.setValue(ptn.charAt(3) == '1'
        ? ScheduleConst.DOW_CHECKED
        : ScheduleConst.DOW_UNCHECKED);
      week_1.setValue(ptn.charAt(4) == '1'
        ? ScheduleConst.DOW_CHECKED
        : ScheduleConst.DOW_UNCHECKED);
      week_2.setValue(ptn.charAt(5) == '1'
        ? ScheduleConst.DOW_CHECKED
        : ScheduleConst.DOW_UNCHECKED);
      week_3.setValue(ptn.charAt(6) == '1'
        ? ScheduleConst.DOW_CHECKED
        : ScheduleConst.DOW_UNCHECKED);
      week_4.setValue(ptn.charAt(7) == '1'
        ? ScheduleConst.DOW_CHECKED
        : ScheduleConst.DOW_UNCHECKED);
      week_5.setValue(ptn.charAt(8) == '1'
        ? ScheduleConst.DOW_CHECKED
        : ScheduleConst.DOW_UNCHECKED);
      week_6.setValue(ptn.charAt(9) == '1'
        ? ScheduleConst.DOW_CHECKED
        : ScheduleConst.DOW_UNCHECKED);
    } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_MONTHLY_DAY)) {
      // xxヶ月ごとの dd日に設定 CxxddL
      repeat_type.setValue(ScheduleConst.CELL_REPEAT_TYPE_MONTH_DAY);
      md_month_interval.setValue(Integer.parseInt(ptn.substring(1, 3)));
      md_day.setValue(Integer.parseInt(ptn.substring(3, 5)));
    } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_MONTHLY_WEEK)) {
      // Xヶ月ごとの 第Y Z曜日に設定 ExxWyzN
      repeat_type.setValue(ScheduleConst.CELL_REPEAT_TYPE_MONTH_WEEK);
      mw_month_interval.setValue(Integer.parseInt(ptn.substring(1, 3)));
      mw_count.setValue(ptn.substring(4, 5));
      mw_dow.setValue(ptn.substring(5, 6));
    } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_YEARLY_DAY)) {
      // X月Y日に設定 FmmddN
      repeat_type.setValue(ScheduleConst.CELL_REPEAT_TYPE_YEAR_MONTH);
      ymd_month.setValue(ptn.substring(1, 3));
      ymd_day.setValue(ptn.substring(3, 5));
    } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_YEARLY_WEEK)) {
      // mm月第y z曜日に設定定 GmmWyzL
      repeat_type.setValue(ScheduleConst.CELL_REPEAT_TYPE_YEAR_WEEK);
      ymw_month.setValue(ptn.substring(1, 3));
      ymw_count.setValue(ptn.substring(4, 5));
      ymw_dow.setValue(ptn.substring(5, 6));
    } else if (ptn.startsWith(ScheduleConst.SCHEDULE_PATTERN_DAYS)) {
      // 日またぎ
      is_span = false;
      is_repeat = false;
      // add end
    } else if (ptn.charAt(0) == 'S') {
      // 期間
      is_span = true;
      is_repeat = false;
    } else {
      // 単発
      is_repeat = false;
    }

    if (is_repeat) {
      // 開始日時
      Calendar tmpViewCal = Calendar.getInstance();
      tmpViewCal.setTime(view_date.getValue());
      Calendar tmpStartCal = Calendar.getInstance();
      tmpStartCal.setTime(record.getStartDate());
      tmpViewCal.set(Calendar.HOUR_OF_DAY, tmpStartCal
        .get(Calendar.HOUR_OF_DAY));
      tmpViewCal.set(Calendar.MINUTE, tmpStartCal.get(Calendar.MINUTE));
      start_date.setValue(tmpViewCal.getTime());
      // 終了日時
      Calendar tmpStopCal = Calendar.getInstance();
      tmpStopCal.setTime(record.getEndDate());
      tmpViewCal
        .set(Calendar.HOUR_OF_DAY, tmpStopCal.get(Calendar.HOUR_OF_DAY));
      tmpViewCal.set(Calendar.MINUTE, tmpStopCal.get(Calendar.MINUTE));
      end_date.setValue(tmpViewCal.getTime());
      // change start
      // 有効期限の設定
      // if (ptn.charAt(count) == 'N') {
      // limit_start_date.setValue(view_date.getValue());
      // limit_end_date.setValue(view_date.getValue());
      // limit_flag.setValue("OFF");
      // } else {
      // limit_flag.setValue("ON");
      // limit_start_date.setValue(record.getStartDate());
      // limit_end_date.setValue(record.getEndDate());
      // }
      // 有効期限開始日
      limit_start_date.setValue(record.getStartDate());
      // 有効期限終了日
      limit_end_date.setValue(record.getEndDate());
      // 有効期限終了パターンの設定
      SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
      String chkDate = df.format(record.getEndDate());
      if (ScheduleConst.SCHEDULE_LIMIT_ENDDATE_NONEND.equals(chkDate)) {
        // 終了日が最大値の場合、終了日なし
        limit_flag.setValue(ScheduleConst.LIMIT_TYPE_NONEND);
        // 表示上の終了日に開始日を設定
        limit_end_date.setValue(record.getStartDate());
      } else if (null != record.getRepeatNum()) {
        // 繰り返し回数データが有る場合、反復回数
        limit_flag.setValue(ScheduleConst.LIMIT_TYPE_NOFT);
        repeat_num.setValue(record.getRepeatNum().longValue());
        // 表示上の終了日に開始日を設定
        limit_end_date.setValue(record.getStartDate());
      } else {
        // 上記以外の場合、終了日
        limit_flag.setValue(ScheduleConst.LIMIT_TYPE_DATE);
      }
      // change end

      // 繰り返しスケジュールの編集フラグ
      edit_repeat_flag
        .setValue(AbstractCellScheduleFormData.FLAG_EDIT_REPEAT_ALL);

    }
    // change start
    // // 開始日時
    // start_date.setValue(record.getStartDate());
    //
    // // 終了日時
    // end_date.setValue(record.getEndDate());
    //
    // // 期限開始日
    // limit_start_date.setValue(record.getStartDate());
    //
    // // 期限終了日
    // limit_end_date.setValue(record.getEndDate());
    // 期間予定の開始日時・終了日時
    if (is_span) {
      // 開始日時
      start_date.setValue(record.getStartDate());
      // 終了日時
      end_date.setValue(record.getEndDate());
      // 期限開始日
      limit_start_date.setValue(record.getStartDate());
      // 期限終了日
      limit_end_date.setValue(record.getEndDate());
    }

    // 単発・日またぎ予定の開始日時・終了日時
    if (!is_repeat && !is_span) {
      // 開始日時
      start_date.setValue(record.getStartDate());
      // 終了日時
      end_date.setValue(record.getEndDate());
      // 期限開始日
      limit_start_date.setValue(record.getStartDate());
      // 期限終了日
      limit_end_date.setValue(record.getEndDate());
    }
    // change end

  }

  public boolean validateDelegate(List<String> msgList, ALEipUser loginUser,
      String entityId, String scheduleType) throws ALDBErrorException,
      ALPageNotFoundException {
    boolean is_repeat = false;
    boolean is_span = false;
    // add start
    // 日またぎ
    boolean is_straddle = false;
    // add end
    if (CellScheduleUtils.SCHEDULE_TYPE_REPEAT.equals(scheduleType)) {
      is_repeat = true;
    } else if (CellScheduleUtils.SCHEDULE_TYPE_SPAN.equals(scheduleType)) {
      is_span = true;
    }/** add start */
    else if (CellScheduleUtils.SCHEDULE_TYPE_CROSS_OVER.equals(scheduleType)) {
      // 日またぎ
      is_straddle = true;
    }
    /** add end */

    if ("".equals(week_0.getValue())) {
      week_0.setValue(null);
    }
    if ("".equals(week_1.getValue())) {
      week_1.setValue(null);
    }
    if ("".equals(week_2.getValue())) {
      week_2.setValue(null);
    }
    if ("".equals(week_3.getValue())) {
      week_3.setValue(null);
    }
    if ("".equals(week_4.getValue())) {
      week_4.setValue(null);
    }
    if ("".equals(week_5.getValue())) {
      week_5.setValue(null);
    }
    if ("".equals(week_6.getValue())) {
      week_6.setValue(null);
    }
    // change start
    // return ScheduleUtils.validateDelegate(
    // getStartDate(),
    // getEndDate(),
    // getRepeatType(),
    // is_repeat,
    // is_span,
    // getWeek0(),
    // getWeek1(),
    // getWeek2(),
    // getWeek3(),
    // getWeek4(),
    // getWeek5(),
    // getWeek6(),
    // getLimitFlag(),
    // getLimitStartDate(),
    // getLimitEndDate(),
    // getMonthDay(),
    // loginUser,
    // entityId,
    // msgList,
    // true);
    return ScheduleUtils.validateDelegate(
      is_repeat,
      is_span,
      is_straddle,
      getStartDate(),
      getEndDate(),
      CellScheduleUtils.getRepeatTypeForValidate(repeat_type.getValue()),
      day_interval,
      week_interval,
      getCheckedWeekDoW(),
      CellScheduleUtils.getMonthTypeForValidate(repeat_type.getValue()),
      md_month_interval,
      mw_month_interval,
      limit_flag,
      limit_start_date,
      limit_end_date,
      repeat_num,
      msgList,
      true);
    // change end
  }

  /**
   * 開始日時を取得します。
   * 
   * @return
   */
  public ALCellDateTimeField getStartDate() {
    return start_date;
  }

  public String getStartDateDate() {
    return ScheduleUtils.translateDate(start_date.getValue(), "yyyyMMdd");
  }

  public String getStartDateTime() {
    return ScheduleUtils.translateDate(start_date.getValue(), "HHmm");
  }

  public String getStartDateDate2() {
    try {
      Calendar cal = Calendar.getInstance();
      cal.setTime(start_date.getValue());
      return ScheduleUtils.translateDate(start_date.getValue(), "yyyy/MM/dd")
        + ALDateUtil.getDayOfWeek(cal);
    } catch (Exception e) {
      return "";
    }
  }

  public String getStartDateTime2() {
    try {
      return ScheduleUtils.translateDate(start_date.getValue(), "HH:mm");
    } catch (Exception e) {
      return "";
    }
  }

  /**
   * 終了日時を取得します。
   * 
   * @return
   */
  public ALCellDateTimeField getEndDate() {
    return end_date;
  }

  public String getEndDateDate() {
    return ScheduleUtils.translateDate(end_date.getValue(), "yyyyMMdd");
  }

  public String getEndDateTime() {
    return ScheduleUtils.translateDate(end_date.getValue(), "HHmm");
  }

  public String getEndDateDate2() {
    try {
      Calendar cal = Calendar.getInstance();
      cal.setTime(end_date.getValue());
      return ScheduleUtils.translateDate(end_date.getValue(), "yyyy/MM/dd")
        + ALDateUtil.getDayOfWeek(cal);
    } catch (Exception e) {
      return "";
    }
  }

  public String getEndDateTime2() {
    try {
      return ScheduleUtils.translateDate(end_date.getValue(), "HH:mm");
    } catch (Exception e) {
      return "";
    }
  }

  /**
   * 指定日時を取得します。
   * 
   * @return
   */
  public ALCellDateTimeField getViewDate() {
    return view_date;
  }

  /**
   * 繰り返しタイプを取得します。
   * 
   * @return
   */
  public ALCellStringField getRepeatType() {
    return repeat_type;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALCellStringField getWeek0() {
    return week_0;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALCellStringField getWeek1() {
    return week_1;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALCellStringField getWeek2() {
    return week_2;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALCellStringField getWeek3() {
    return week_3;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALCellStringField getWeek4() {
    return week_4;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALCellStringField getWeek5() {
    return week_5;
  }

  /**
   * 繰り返し曜日を取得します。
   * 
   * @return
   */
  public ALCellStringField getWeek6() {
    return week_6;
  }

  /**
   * 期限フラグを取得します。
   * 
   * @return
   */
  public ALCellStringField getLimitFlag() {
    return limit_flag;
  }

  /**
   * 期限開始日を取得します。
   * 
   * @return
   */
  public ALCellDateField getLimitStartDate() {
    return limit_start_date;
  }

  public String getLimitStartDateDate() {
    Date date = null;
    try {
      date = limit_start_date.getValue().getDate();
    } catch (Exception e) {
    }
    if (date == null) {
      return "";
    }
    return ScheduleUtils.translateDate(date, "yyyyMMdd");
    // return ""+(date.getYear()+1900)+date.getMonth()+date.getDate();
  }

  public String getLimitStartDateDate2() {
    try {
      return ScheduleUtils.translateDate(
        limit_start_date.getValue().getDate(),
        "yyyy/MM/dd");
    } catch (Exception e) {
      return "";
    }
  }

  /**
   * 期限終了日を取得します。
   * 
   * @return
   */
  public ALCellDateField getLimitEndDate() {
    return limit_end_date;
  }

  public String getLimitEndDateDate() {
    Date date = null;
    try {
      date = limit_end_date.getValue().getDate();
    } catch (Exception e) {
    }
    if (date == null) {
      return "";
    }
    return ScheduleUtils.translateDate(date, "yyyyMMdd");
  }

  public String getLimitEndDateDate2() {
    try {
      return ScheduleUtils.translateDate(
        limit_end_date.getValue().getDate(),
        "yyyy/MM/dd");
    } catch (Exception e) {
      return "";
    }
  }

  // remove start
  // public ALCellNumberField getEditRepeatFlag() {
  // return edit_repeat_flag;
  // }

  // /**
  // * 毎月繰り返す日を取得します。
  // *
  // * @return
  // */
  // public ALCellNumberField getMonthDay() {
  // return month_day;
  // }
  // remove end
  // change start
  // /**
  // * グループメンバーを取得します。
  // *
  // * @return
  // */
  /**
   * 参加参加ユーザー(必須)メンバーを取得します。
   * 
   * @return
   */
  // change end
  public List<ALEipUser> getMemberList() {
    return memberList;
  }

  /**
   * 任意参加ユーザー(必須)メンバーを取得します。
   * 
   * @return
   */
  public List<ALEipUser> getSubMemberList() {
    return submemberList;
  }

  // remove start
  // /**
  // * 施設一覧を取得します。
  // *
  // * @return
  // */
  // public List<FacilityResultData> getFacilityMemberList() {
  // return facilityMemberList;
  // }

  // /**
  // * 共有メンバーによる編集／削除権限フラグを取得します。
  // *
  // * @return
  // */
  // public ALCellStringField getEditFlag() {
  // return edit_flag;
  // }
  //
  // /**
  // * 仮スケジュールに戻すかどうかを取得します。
  // *
  // * @return
  // */
  // public ALCellStringField getChangeTmpreserveFlag() {
  // return change_tmpreserve_flag;
  // }
  // remove end
  /**
   * 現在の年を取得します。
   * 
   * @return
   */
  public int getCurrentYear() {
    return current_year;
  }

  // add start

  /**
   * 週パターンチェック済み曜日一覧取得
   * 
   * @return チェック済み曜日一覧（0番=日曜日、1番=月曜日...）
   */
  public List<String> getCheckedWeekDoW() {
    List<String> result = new ArrayList<String>(0);
    if (ScheduleConst.DOW_CHECKED.equals(week_0.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_1.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_2.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_3.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_4.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_5.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    if (ScheduleConst.DOW_CHECKED.equals(week_6.toString())) {
      result.add(ScheduleConst.DOW_CHECKED);
    } else {
      result.add(ScheduleConst.DOW_UNCHECKED);
    }
    return result;
  }

  /**
   * 「日指定」日間隔を取得します。
   * 
   * @return
   */
  public ALCellNumberField getDayInterval() {
    return day_interval;
  }

  /**
   * 「週指定」週間隔を取得します。
   * 
   * @return
   */
  public ALCellNumberField getWeekInterval() {
    return week_interval;
  }

  /**
   * 「月->日指定」月間隔を取得します。
   * 
   * @return
   */
  public ALCellNumberField getMdMonthInterval() {
    return md_month_interval;
  }

  /**
   * 「月->日指定」日を取得します。
   * 
   * @return
   */
  public ALCellNumberField getMdDay() {
    return md_day;
  }

  /**
   * 「月->曜日指定」月間隔を取得します。
   * 
   * @return
   */
  public ALCellNumberField getMwMonthInterval() {
    return mw_month_interval;
  }

  /**
   * 「月->曜日指定」週を取得します。
   * 
   * @return
   */
  public ALCellNumberField getMwCount() {
    return mw_count;
  }

  /**
   * 月->曜日指定 曜日を取得します。
   * 
   * @return
   */
  public ALCellNumberField getMwDoW() {
    return mw_dow;
  }

  /**
   * 年->月日指定 月間隔を取得します。
   * 
   * @return
   */
  public ALCellNumberField getYmdMonth() {
    return ymd_month;
  }

  /**
   * 年->月日指定 日を取得します。
   * 
   * @return
   */
  public ALCellNumberField getYmdDay() {
    return ymd_day;
  }

  /**
   * 年->曜日指定 月間隔を取得します。
   * 
   * @return
   */
  public ALCellNumberField getYmwMonth() {
    return ymw_month;
  }

  /**
   * 年->曜日指定 週を取得します。
   * 
   * @return
   */
  public ALCellNumberField getYmwCount() {
    return ymw_count;
  }

  /**
   * 年->曜日指定 曜日を取得します。
   * 
   * @return
   */
  public ALCellNumberField getYmwDoW() {
    return ymw_dow;
  }

  /**
   * 反復回数を取得します。
   * 
   * @return
   */
  public ALCellNumberField getRepeatNum() {
    return repeat_num;
  }

  /**
   * 「年->月日指定 」月を数値型で取得します。
   * 
   * @return
   */
  public int getYmdMonthbyInt() {
    return (int) getYmdMonth().getValue();
  }

  /**
   * 「年->月日指定 」日を数値型で取得します。
   * 
   * @return
   */
  public int getYmdDaybyInt() {
    return (int) getYmdDay().getValue();
  }

  /**
   * 「年->曜日指定 」月を数値型で取得します。
   * 
   * @return
   */
  public int getYmwMonthbyInt() {
    return (int) getYmwMonth().getValue();
  }
  // add end
}
