/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailFormData;

/**
 * Webメールのフォームデータを管理するためのクラスです。 <br />
 * 
 */
public class WebMailFormScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WebMailFormScreen.class.getName());

  /**
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {
    try {
      WebMailFormData formData = new WebMailFormData();
      formData.initField();
      formData.doViewForm(this, rundata, context);

      // add by motegi start
      HttpServletResponse response = rundata.getResponse();
      response.setContentType("text/html; "
        + ALEipConstants.DEF_CONTENT_ENCODING);
      // add end

      setTemplate(rundata, context, "portlets/html/ja/ajax-webmail-form.vm");
    } catch (Exception ex) {
      // change start
      // logger.error("[WebMailFormScreen] Exception.", ex);
      logger.error("メール作成　表示処理に失敗しました。", ex);
      // change end
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
