/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MIMEOutputUtils;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog((Class)SOAPMessageFormatter.class);

    public void writeTo(MessageContext msgCtxt, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start writeTo()");
            log.debug((Object)("  preserve=" + preserve));
            log.debug((Object)("  isOptimized=" + format.isOptimized()));
            log.debug((Object)("  isDoingSWA=" + format.isDoingSWA()));
        }
        SOAPEnvelope element = msgCtxt.getEnvelope();
        int optimizedThreshold = Utils.getMtomThreshold(msgCtxt);
        if (optimizedThreshold > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting MTOM optimized Threshold Value on OMOutputFormat");
            }
            format.setOptimizedThreshold(optimizedThreshold);
        }
        try {
            if (!format.isOptimized() & format.isDoingSWA()) {
                StringWriter bufferedSOAPBody = new StringWriter();
                if (preserve) {
                    element.serialize((Writer)bufferedSOAPBody, format);
                } else {
                    element.serializeAndConsume((Writer)bufferedSOAPBody, format);
                }
                this.writeSwAMessage(msgCtxt, bufferedSOAPBody, out, format);
            } else if (preserve) {
                element.serialize(out, format);
            } else {
                element.serializeAndConsume(out, format);
            }
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault(e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"end writeTo()");
            }
        }
    }

    public byte[] getBytes(MessageContext msgCtxt, OMOutputFormat format) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start getBytes()");
            log.debug((Object)("  isOptimized=" + format.isOptimized()));
            log.debug((Object)("  isDoingSWA=" + format.isDoingSWA()));
        }
        SOAPEnvelope element = msgCtxt.getEnvelope();
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            if (!format.isOptimized()) {
                if (format.isDoingSWA()) {
                    OMOutputFormat format2 = new OMOutputFormat();
                    format2.setCharSetEncoding(format.getCharSetEncoding());
                    StringWriter bufferedSOAPBody = new StringWriter();
                    element.serializeAndConsume((Writer)bufferedSOAPBody, format2);
                    this.writeSwAMessage(msgCtxt, bufferedSOAPBody, bytesOut, format);
                } else {
                    element.serializeAndConsume((OutputStream)bytesOut, format);
                }
                byte[] byArray = bytesOut.toByteArray();
                return byArray;
            }
            element.serializeAndConsume((OutputStream)bytesOut, format);
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault(e);
        }
        catch (FactoryConfigurationError e) {
            throw AxisFault.makeFault(e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"end getBytes()");
            }
        }
    }

    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String encoding = format.getCharSetEncoding();
        String contentType = format.getContentType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentType from the OMOutputFormat =" + contentType));
        }
        if (encoding != null && contentType != null && contentType.indexOf("multipart/related") == -1) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (!(msgCtxt.isSOAP11() || soapActionString == null || "".equals(soapActionString.trim()) || "\"\"".equals(soapActionString.trim()))) {
            contentType = contentType + "; action=\"" + soapActionString + "\"";
        }
        if ((contentType = contentType.trim()).lastIndexOf(";") == contentType.length() - 1) {
            contentType = contentType.substring(0, contentType.length() - 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentType returned =" + contentType));
        }
        return contentType;
    }

    public String formatSOAPAction(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        if (msgCtxt.isSOAP11()) {
            if ("".equals(soapActionString)) {
                return "\"\"";
            }
            if (soapActionString != null && !soapActionString.startsWith("\"")) {
                soapActionString = "\"" + soapActionString + "\"";
            }
            return soapActionString;
        }
        return null;
    }

    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, msgCtxt, false);
        return targetURL;
    }

    private void writeSwAMessage(MessageContext msgCtxt, StringWriter bufferedSOAPBody, OutputStream outputStream, OMOutputFormat format) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start writeSwAMessage()");
        }
        Object property = msgCtxt.getProperty("MM7Compatible");
        boolean MM7CompatMode = false;
        if (property != null) {
            MM7CompatMode = JavaUtils.isTrueExplicitly(property);
        }
        if (!MM7CompatMode) {
            MIMEOutputUtils.writeSOAPWithAttachmentsMessage((StringWriter)bufferedSOAPBody, (OutputStream)outputStream, (Attachments)msgCtxt.getAttachmentMap(), (OMOutputFormat)format);
        } else {
            Object innerBoundaryProperty = msgCtxt.getProperty("MM7InnerBoundary");
            String innerBoundary = innerBoundaryProperty != null ? (String)innerBoundaryProperty : "innerBoundary" + UUIDGenerator.getUUID().replace(':', '_');
            Object partCIDProperty = msgCtxt.getProperty("MM7PartCID");
            String partCID = partCIDProperty != null ? (String)partCIDProperty : "innerCID" + UUIDGenerator.getUUID().replace(':', '_');
            MIMEOutputUtils.writeMM7Message((StringWriter)bufferedSOAPBody, (OutputStream)outputStream, (Attachments)msgCtxt.getAttachmentMap(), (OMOutputFormat)format, (String)partCID, (String)innerBoundary);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeSwAMessage()");
        }
    }
}

