/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import net.sf.json.JSONArray;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.user.util.UserUtils;

/**
 * グループ情報をJSONデータとして出力するクラスです。 <br />
 * 
 */
public class UserGroupLiteJSONScreen extends ALJSONScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(UserLiteJSONScreen.class.getName());

  @Override
  protected String getJSONString(RunData rundata, Context context)
      throws Exception {
    String result = "";
    JSONArray json;

    try {

      String mode = rundata.getParameters().getString("mode");
      if ("mygroup".equals(mode)) {
        json =
          JSONArray.fromObject(UserUtils.getUserGroupLiteBeans(
            rundata,
            true,
            false));
      } else if ("post".equals(mode)) {
        json =
          JSONArray.fromObject(UserUtils.getUserGroupLiteBeans(
            rundata,
            false,
            true));
        // add by motegi start メンバー選択フォーム用（必須／任意） 親部署のリストを取得する
      } else if ("parent".equals(mode)) {

        String groupsend_mode =
          rundata.getParameters().getString("groupsend_mode");

        // 部署１リストを取得
        json =
          JSONArray.fromObject(UserUtils.getUserParentGroupLiteBeans(
            rundata,
            groupsend_mode));
      } else if ("child".equals(mode)) {
        // 部署２リストを取得
        String parent_group_name =
          rundata.getParameters().getString("parent_group_name");

        String with_all = rundata.getParameters().getString("with_all");
        if ("none".equals(with_all)) {
          json =
            JSONArray.fromObject(UserUtils.getPost2LiteBeans(
              parent_group_name,
              true,
              false,
              false));
        } else {
          json =
            JSONArray
              .fromObject(UserUtils.getPost2LiteBeans(parent_group_name));
        }
      } else if ("groupsend".equals(mode)) {
        json =
          JSONArray.fromObject(UserUtils.getUserGroupSendLiteBeans(rundata));
        // add end
      } else {
        json =
          JSONArray.fromObject(UserUtils.getUserGroupLiteBeans(
            rundata,
            true,
            true));
      }

      result = json.toString();
    } catch (Exception e) {
      logger.error("部署プルダウン用の情報取得に失敗しました", e);
    }

    return result;
  }
}
