/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.cayenne.om.portlet;

import org.apache.cayenne.ObjectId;

import com.aimluck.eip.cayenne.om.portlet.auto._EipTMailFolder;

public class EipTMailFolder extends _EipTMailFolder {

  /** アカウント作成時に自動生成されるメールフォルダの名前 */
  public static final String DEFAULT_FOLDER_NAME = "受信トレイ";

  /** アカウント作成時に自動生成されるメールフォルダの名前 */
  public static final String DEFAULT_ROOT_RECEIVE_FOLDER_NAME = "受信";

  /** アカウント作成時に自動生成されるメールフォルダの名前 */
  public static final String DEFAULT_ROOT_SEND_FOLDER_NAME = "送信";

  /** アカウント作成時に自動生成される送信メールフォルダの名前 */
  public static final String DEFAULT_SEND_FOLDER_NAME = "送信トレイ";

  /** アカウント作成時に自動生成されるゴミ箱フォルダの名前 */
  public static final String DEFAULT_TRASH_FOLDER_NAME = "ゴミ箱";

  /** アカウント作成時に自動生成される下書きフォルダの名前 */
  public static final String DEFAULT_DRAFT_FOLDER_NAME = "下書き";

  /** アカウント作成時に自動生成される迷惑メールフォルダの名前 */
  public static final String DEFAULT_SPAMMAIL_FOLDER_NAME = "迷惑メール";

  /** アカウント作成時に自動生成される戻したメールフォルダの名前 */
  public static final String DEFAULT_RETURNMAIL_FOLDER_NAME = "戻したメール";

  public Integer getFolderId() {
    if (getObjectId() != null && !getObjectId().isTemporary()) {
      Object obj = getObjectId().getIdSnapshot().get(FOLDER_ID_PK_COLUMN);
      if (obj instanceof Long) {
        Long value = (Long) obj;
        return Integer.valueOf(value.intValue());
      } else {
        return (Integer) obj;
      }
    } else {
      return null;
    }
  }

  public void setFolderId(String id) {
    setObjectId(new ObjectId("EipTMailFolder", FOLDER_ID_PK_COLUMN, Integer
      .valueOf(id)));
  }
}
