/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.util.ALCommonUtils;

/**
 * グループ送信情報のResultDataです。 <BR>
 * 
 */
public class AccountGroupSendResultData implements ALData {

  /** グループ送信ID */
  private ALNumberField groupsend_id;

  /** グループ送信名 */
  private ALStringField groupsend_name;

  /** グループ送信カテゴリ */
  private ALStringField category;

  /** 登録日 */
  private ALStringField create_date;

  /** 更新日 */
  private ALStringField update_date;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    groupsend_id = new ALNumberField();
    groupsend_name = new ALStringField();
    category = new ALStringField();
    create_date = new ALStringField();
    update_date = new ALStringField();
  }

  /**
   * @return
   */
  public ALNumberField getGroupsendId() {
    return groupsend_id;
  }

  /**
   * @param i
   */
  public void setGroupsendId(long i) {
    groupsend_id.setValue(i);
  }

  /**
   * @return
   */
  public String getGroupsendName() {
    return ALCommonUtils.replaceToAutoCR(groupsend_name.toString());
  }

  /**
   * @param string
   */
  public void setGroupsendName(String string) {
    groupsend_name.setValue(string);
  }

  /**
   * @return
   */
  public String getCategory() {
    return ALCommonUtils.replaceToAutoCR(category.toString());
  }

  /**
   * @param string
   */
  public void setCategory(String string) {
    category.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getCreateDate() {
    return create_date;
  }

  /**
   * @param string
   */
  public void setCreateDate(String string) {
    create_date.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getUpdateDate() {
    return update_date;
  }

  /**
   * @param string
   */
  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }

}
