/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * 変更履歴
 *    No.    変更日        変更者           障害No/仕様変
 *      1    2011.9.22     上原   有貴      新規カスタマイズ
 */

package com.aimluck.eip.account;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogConstants;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;

/**
 * Webメールアカウントのフォームデータを管理するためのクラスです。 <br />
 */
public class AccountWebMailAccountFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(AccountWebMailAccountFormData.class.getName());

  /** デフォルトSMTPポート番号 */
  private final int DEF_SMTP_PORT = 25;

  /** デフォルトPOP3ポート番号 */
  private final int DEF_POP3_PORT = 110;

  /** The value for the accountId field */
  private ALNumberField account_id;

  /** The value for the userId field */
  private ALNumberField user_id;

  /** The value for the accountName field */
  private ALStringField account_name;

  /** The value for the accountType field */
  private ALStringField account_type;

  /** The value for the pop3serverName field */
  private ALStringField smtpserver_name;

  /** The value for the pop3serverName field */
  private ALStringField pop3server_name;

  /** The value for the pop3userName field */
  private ALStringField pop3user_name;

  // remove start 運用フェーズ課題・障害台帳No.１５２
  /** The value for the pop3password field */
  // private ALStringField pop3_password;
  // remove end
  /** The value for the mailUserName field */
  private ALStringField mail_user_name;

  /** The value for the mailAddress field */
  private ALStringField mail_address;

  /** The value for the smtpPort field */
  private ALNumberField smtp_port;

  /** The value for the pop3Port field */
  private ALNumberField pop3_port;

  // /** <code>auth_send_flag</code> 送信時の認証方式 */
  // private ALNumberField auth_send_flg;
  //
  // /** <code>auth_send_user_id</code> SMTP 認証時のユーザ ID */
  // private ALStringField auth_send_user_id;
  //
  // /** <code>auth_send_user_password</code> SMTP 認証時のユーザパスワード */
  // private ALStringField auth_send_user_password;
  //
  // /** <code>auth_receive_flag</code> 受信時の認証方式 */
  // private ALNumberField auth_receive_flag;
  //
  // /** The value for the delAtPop3Flg field */
  // private ALNumberField del_at_pop3_flg;
  //
  // /** <code>del_at_pop3_before_days_flg</code> 指定日数の経過後に POP3 サーバからメールを削除する
  // */
  // private ALNumberField del_at_pop3_before_days_flg;
  //
  // /** <code>del_at_pop3_before_days</code> POP3 サーバからメールを削除する経過日数 */
  // private ALNumberField del_at_pop3_before_days;
  //
  // /** The value for the nonReceivedFlg field */
  // private ALNumberField non_received_flg;
  //
  /** The value for the createDate field */
  private ALDateTimeField create_date;

  /** The value for the updateDate field */
  private ALDateTimeField update_date;

  // /** The value for the signature field */
  // private ALStringField signature;
  //
  // /** The value for the smtpEncryptionFlag field */
  // private ALNumberField smtp_encryption_flag;
  //
  // /** The value for the pop3EncryptionFlag field */
  // private ALNumberField pop3_encryption_flag;

  private static final String SETTING_FILE_PATH = JetspeedResources.getString("aipo.conf", "") + File.separator + "WebMailAdminSettings.properties";

  // add start 2012.2.24 受入障害No.294
  /** The value for the accountUsage field */
  private ALStringField account_usage;

  // add end 2012.2.24
  /**
   * 初期処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);
  }

  /**
   * 画面フィールド初期化
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  @Override
  public void initField() {
    account_id = new ALNumberField();
    account_id.setFieldName("アカウントID");

    user_id = new ALNumberField();
    user_id.setFieldName("ユーザID");

    account_name = new ALStringField();
    account_name.setFieldName("メールアカウント名");
    account_name.setTrim(true);

    account_type = new ALStringField();
    account_type.setFieldName("アカウント種別");
    account_type.setTrim(true);

    smtpserver_name = new ALStringField();
    smtpserver_name.setFieldName("送信メールサーバ名（SMTP）");
    smtpserver_name.setTrim(true);

    pop3server_name = new ALStringField();
    pop3server_name.setFieldName("受信メールサーバ名（POP3）");
    pop3server_name.setTrim(true);

    pop3user_name = new ALStringField();
    pop3user_name.setFieldName("受信用ユーザーID");
    pop3user_name.setTrim(true);

    // remove start 運用フェーズ課題・障害台帳No.１５２
    // pop3_password = new ALStringField();
    // pop3_password.setFieldName("受信用ユーザーパスワード");
    // pop3_password.setTrim(true);
    // remove end

    mail_user_name = new ALStringField();
    mail_user_name.setFieldName("メール送信元表示名");
    mail_user_name.setTrim(true);

    mail_address = new ALStringField();
    mail_address.setFieldName("メールアドレス");
    mail_address.setTrim(true);

    smtp_port = new ALNumberField();
    smtp_port.setFieldName("送信ポート番号（SMTP）");
    smtp_port.setValue(DEF_SMTP_PORT);

    pop3_port = new ALNumberField();
    pop3_port.setFieldName("受信ポート番号（POP3）");
    pop3_port.setValue(DEF_POP3_PORT);

    // add start 2012.2.24 受入障害No.294
    account_usage = new ALStringField();
    account_usage.setFieldName("アカウント用途選択");
    account_usage.setTrim(true);
    // add end

    // auth_send_flg = new ALNumberField();
    // auth_send_flg.setFieldName("送信時の認証方式");
    // auth_send_flg.setValue(ALSmtpMailSender.AUTH_SEND_NONE);
    //
    // smtp_encryption_flag = new ALNumberField();
    // smtp_encryption_flag.setFieldName("送信時の暗号化方式");
    // smtp_encryption_flag.setValue(0);
    //
    // auth_send_user_id = new ALStringField();
    // auth_send_user_id.setFieldName("SMTP認証用ユーザーID");
    // auth_send_user_id.setTrim(true);
    //
    // auth_send_user_password = new ALStringField();
    // auth_send_user_password.setFieldName("SMTP認証用パスワード");
    // auth_send_user_password.setTrim(true);
    //
    // auth_receive_flag = new ALNumberField();
    // auth_receive_flag.setFieldName("受信時の認証方式");
    // auth_receive_flag.setValue(ALPop3MailReceiver.AUTH_RECEIVE_NORMAL);
    //
    // pop3_encryption_flag = new ALNumberField();
    // pop3_encryption_flag.setFieldName("受信時の暗号化方式");
    // pop3_encryption_flag.setValue(0);
    //
    // del_at_pop3_flg = new ALNumberField();
    // del_at_pop3_flg.setFieldName("受信後、サーバからメールを削除する");
    // del_at_pop3_flg.setValue(0);
    //
    // del_at_pop3_before_days_flg = new ALNumberField();
    // del_at_pop3_before_days_flg.setFieldName("メール削除日数指定フラグ");
    // del_at_pop3_before_days_flg.setValue(0);
    //
    // del_at_pop3_before_days = new ALNumberField();
    // del_at_pop3_before_days.setFieldName("メール削除日数");
    // del_at_pop3_before_days.setValue(0);
    //
    // non_received_flg = new ALNumberField();
    // non_received_flg.setFieldName("受信済みメッセージは取り込まない");
    // non_received_flg.setValue(1);
    //
    // create_date = new ALDateTimeField(ALDateTimeField.DEFAULT_DATE_FORMAT);
    // create_date.setFieldName("メールアカウント作成日");
    //
    // update_date = new
    // ALDateTimeField(ALDateTimeField.DEFAULT_DATE_TIME_FORMAT);
    // update_date.setFieldName("メールアカウント最終更新日");
    //
    // signature = new ALStringField();
    // signature.setFieldName("署名");
    // signature.setTrim(true);
  }

  /**
   * バリデータ初期化
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  @Override
  protected void setValidator() {
    // アカウント名
    account_name.setNotNull(true);
    account_name.limitMaxLength(20);

    // SMTPサーバ名
    smtpserver_name.setNotNull(true);
    smtpserver_name.setCharacterType(ALStringField.TYPE_ASCII);
    smtpserver_name.limitMaxLength(50);

    // POP3サーバ名
    pop3server_name.setNotNull(true);
    pop3server_name.setCharacterType(ALStringField.TYPE_ASCII);
    pop3server_name.limitMaxLength(50);

    // POP3用ユーザID
    pop3user_name.setNotNull(true);
    pop3user_name.setCharacterType(ALStringField.TYPE_ASCII);
    pop3user_name.limitMaxLength(50);

    // POP3用ユーザパスワード
    // remove start 運用フェーズ課題・障害台帳No.１５２
    // pop3_password.setNotNull(true);
    // pop3_password.setCharacterType(ALStringField.TYPE_ASCII);
    // pop3_password.limitMaxLength(50);
    // remove end

    // メールユーザ名
    mail_user_name.setNotNull(true);
    mail_user_name.limitMaxLength(50);

    // メールアドレス
    mail_address.setNotNull(true);
    mail_address.setCharacterType(ALStringField.TYPE_ASCII);
    mail_address.limitMaxLength(64);

    // SMTPポート番号
    smtp_port.setNotNull(true);
    smtp_port.limitMinValue(0);
    smtp_port.limitMaxValue(65535);

    // POP3ポート番号
    pop3_port.setNotNull(true);
    pop3_port.limitMinValue(0);
    pop3_port.limitMaxValue(65535);

    // // 送信時の認証方式
    // auth_send_flg.setNotNull(true);
    // auth_send_flg.limitMinValue(ALSmtpMailSender.AUTH_SEND_NONE);
    // auth_send_flg.limitMaxValue(ALSmtpMailSender.AUTH_SEND_SMTP_AUTH);
    //
    // // 送信時の暗号化
    // smtp_encryption_flag.setNotNull(true);
    // smtp_encryption_flag.limitMaxValue(ALSmtpMailSender.ENCRYPTION_SEND_SSL);
    // smtp_encryption_flag.limitMinValue(ALSmtpMailSender.ENCRYPTION_SEND_NONE);
    //
    // // SMTP 認証時のユーザ ID
    // auth_send_user_id.setNotNull(true);
    // auth_send_user_id.setCharacterType(ALStringField.TYPE_ASCII);
    // auth_send_user_id.limitMaxLength(50);
    //
    // // SMTP 認証時のユーザパスワード
    // auth_send_user_password.setNotNull(true);
    // auth_send_user_password.setCharacterType(ALStringField.TYPE_ASCII);
    // auth_send_user_password.limitMaxLength(50);

    // // 受信時の認証方式
    // auth_receive_flag.setNotNull(true);
    // auth_receive_flag.limitMinValue(ALPop3MailReceiver.AUTH_RECEIVE_NORMAL);
    // auth_receive_flag.limitMaxValue(ALPop3MailReceiver.AUTH_RECEIVE_APOP);
    //
    // // 受信時の暗号化
    // pop3_encryption_flag.setNotNull(true);
    // pop3_encryption_flag.limitMinValue(ALPop3MailReceiver.ENCRYPTION_SEND_NONE);
    // pop3_encryption_flag.limitMaxValue(ALPop3MailReceiver.ENCRYPTION_SEND_SSL);
    //
    // // 受信後、サーバからメールを削除する
    // del_at_pop3_flg.setNotNull(true);
    // del_at_pop3_flg.limitMinValue(0);
    // del_at_pop3_flg.limitMaxValue(1);
    //
    // // 指定日数の経過後に POP3 サーバからメールを削除する
    // del_at_pop3_before_days_flg.setNotNull(true);
    // del_at_pop3_before_days_flg.limitMinValue(0);
    // del_at_pop3_before_days_flg.limitMaxValue(1);
    //
    // // POP3 サーバからメールを削除する経過日数
    // del_at_pop3_before_days.setNotNull(true);
    // del_at_pop3_before_days.limitMinValue(0);
    // del_at_pop3_before_days.limitMaxValue(100);
    //
    // // 受信済みメッセージは取り込まない
    // non_received_flg.setNotNull(true);
    // non_received_flg.limitMinValue(0);
    // non_received_flg.limitMaxValue(1);
    //
    // // 署名の最大文字数
    // signature.limitMaxLength(1000);
  }

  /**
   * バリデーション
   * 
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  @Override
  protected boolean validate(List<String> msgList) {
    // アカウント名
    account_name.validate(msgList);

    // POP3用ユーザID
    pop3user_name.validate(msgList);

    // add start 運用フェーズ課題・障害台帳No.１５５
    String s = pop3user_name.getValue();
    if (s.matches(".*[A-Z].*")) {
      msgList.add("『 受信用ユーザーID 』に大文字半角英字は使用できません。");
    }
    // add end

    // remove start 運用フェーズ課題・障害台帳No.１５２
    // POP3用ユーザパスワード
    // pop3_password.validate(msgList);
    // remove end
    // メールユーザ名
    mail_user_name.validate(msgList);
    // メールアドレス
    if (mail_address.validate(msgList) && !ALStringUtil.isMailAddress(mail_address.getValue())) {
      msgList.add("『 <span class='em'>メールアドレス</span> 』を正しく入力してください。");
    }

    return (msgList.size() == 0);
  }

  /**
   * メールアカウント編集画面表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
    try {
      int accountId = Integer.parseInt(ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID));

      // オブジェクトモデルを取得
      EipMMailAccount account = ALMailUtils.getMailAccount(accountId);
      if (account == null) {
        throw new Exception("指定されたメールアカウントがデータベースにありません。ID=" + accountId);
      }

      account_id.setValue(account.getAccountId().intValue());
      account_name.setValue(account.getAccountName());
      // account_type.setValue(account.getAccountType());
      pop3user_name.setValue(account.getPop3userName());
      // remove start 運用フェーズ課題・障害台帳No.１５２
      // pop3_password.setValue(new
      // String(ALMailUtils.getDecryptedMailAccountPasswd(account.getPop3password())));
      // remove end
      mail_user_name.setValue(account.getMailUserName());
      mail_address.setValue(account.getMailAddress());
      // add start 2012.2.24 受入障害No.294
      account_usage.setValue(account.getAccountUsage());
      // add end
    } catch (Exception ex) {
      String msg = "メールアカウント情報の編集画面の表示に失敗しました。";
      logger.error(msg, ex);
      throw new ALDBErrorException();
    }
    return true;
  }

  /**
   * メールアカウント登録処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {

    try {
      // (1) add start
      // メールサーバデフォルト情報の設定を行う。
      // 処理が失敗した場合はfalseを返す。
      // 失敗ログは呼び出しメソッド内で行っている。
      if (!setMailDefaultInfo()) {
        throw new Exception("メールサーバ情報の取得に失敗しました。");
      }
      // (1) add end
      String uid = rundata.getRequest().getParameter("user_id");

      ALMailUtils.insertMailAccountData(
        rundata,
        msgList,
        Integer.valueOf(uid),
        getAccountName().getValue(),
        ALMailUtils.ACCOUNT_TYPE_INIT,
        getMailAddress().getValue(),
        getMailUserName().getValue(),
        getSmtpserverName().getValue(),
        (int) getSmtpPort().getValue(),
        getPop3serverName().getValue(),
        (int) getPop3Port().getValue(),
        getPop3userName().getValue(),
        // change start 運用フェーズ課題・障害台帳No.１５２
        // getPop3Password().getValue(),
        AccountUtils.getMD5Digest(getPop3userName().getValue()),
        // change end
        0, // 送信時認証フラグ
        "", // 送信時認証（SMTP認証のユーザーID）
        "", // 送信時認証（SMTP認証のパスワード）
        0, // 受信時認証フラグ
        1, // 受信時メール削除フラグ(リリース時は1)
        0, // 受信時メール削除日数指定フラグ
        0, // 受信時メール削除日数
        "1", // 既未受信フラグ
        "", // 署名
        0, // 送信時の暗号化方式
        0
        // add start 2012.2.24 受入障害対応No.294
        ,
        getAccountUsage().getValue()
      // add end 2012.2.24
        );
    } catch (Exception t) {
      Database.rollback();
      String msg = "メールアカウント情報の登録に失敗しました。";
      logger.error(msg, t);
      msgList.add(msg);
      return false;
    }
    return true;
  }

  /**
   * メールアカウント更新処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {

    try {
      // (1) add start
      // メールサーバデフォルト情報の設定を行う。
      // 処理が失敗した場合はfalseを返す。
      // 失敗ログは呼び出しメソッド内で行っている。
      if (!setMailDefaultInfo()) {
        throw new Exception("メールサーバ情報の取得に失敗しました。");
      }
      // (1) add end

      int accountId = Integer.parseInt(ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID));

      // オブジェクトモデルを取得
      EipMMailAccount mailAccount = ALMailUtils.getMailAccount(accountId);
      if (mailAccount == null) {
        throw new Exception("指定されたメールアカウントがデータベースにありません。ID=" + accountId);
      }

      // mailAccount.setUserId(Integer.valueOf(userId));
      mailAccount.setAccountName(getAccountName().getValue());
      // mailAccount.setAccountType(getAccountType().getValue());
      mailAccount.setSmtpserverName(getSmtpserverName().getValue());
      mailAccount.setPop3serverName(getPop3serverName().getValue());
      mailAccount.setPop3userName(getPop3userName().getValue());
      // change start 運用フェーズ課題・障害台帳No.１５２
      // mailAccount.setPop3password(ALMailUtils.getEncryptedMailAccountPasswd(getPop3Password().getValue().getBytes()));
      mailAccount.setPop3password(ALMailUtils.getEncryptedMailAccountPasswd(AccountUtils.getMD5Digest(getPop3userName().getValue()).getBytes()));
      // change end
      mailAccount.setMailUserName(getMailUserName().getValue());
      mailAccount.setMailAddress(getMailAddress().getValue());
      mailAccount.setSmtpPort(Integer.toString((int) getSmtpPort().getValue()));
      mailAccount.setPop3Port(Integer.toString((int) getPop3Port().getValue()));
      // add start 2012.2.24 受入障害No.294
      mailAccount.setAccountUsage(getAccountUsage().getValue());
      // add end
      /*
       * mailAccount.setAuthSendFlg(Short.valueOf(getAuthSendFlg().toString()));
       * mailAccount.setSmtpEncryptionFlg((short) getSmtpEncryptionFlag()
       * .getValue()); mailAccount.setPop3EncryptionFlg((short)
       * getPop3EncryptionFlag() .getValue()); if (getAuthSendFlg().getValue() ==
       * ALSmtpMailSender.AUTH_SEND_SMTP_AUTH) {
       * mailAccount.setAuthSendUserId(getAuthSendUserId().getValue());
       * mailAccount.setAuthSendUserPasswd(ALMailUtils
       * .getEncryptedMailAccountPasswd(getAuthSendUserPasswd() .getValue()
       * .getBytes())); } mailAccount.setAuthReceiveFlg(Short.valueOf((short)
       * getAuthReceiveFlg() .getValue()));
       * mailAccount.setDelAtPop3Flg(getDelAtPop3Flg().getValueAsString()); if
       * (getDelAtPop3Flg().getValue() == 0) {
       * mailAccount.setDelAtPop3BeforeDaysFlg(getDelAtPop3BeforeDaysFlg()
       * .getValueAsString()); if (getDelAtPop3BeforeDaysFlg().getValue() == 1) {
       * mailAccount.setDelAtPop3BeforeDays(Integer .valueOf((int)
       * getDelAtPop3BeforeDays().getValue())); } }
       * mailAccount.setNonReceivedFlg(getNonReceivedFlg().toString());
       * mailAccount.setUpdateDate(Calendar.getInstance().getTime());
       * mailAccount.setSignature(getSignature().getValue());
       */

      // アカウントを更新
      Database.commit();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(
        mailAccount.getAccountId(),
        ALEventlogConstants.PORTLET_TYPE_WEBMAIL_ACCOUNT,
        mailAccount.getAccountName());

    } catch (Exception t) {
      Database.rollback();
      String msg = "メールアカウント情報の更新に失敗しました。";
      logger.error(msg, t);
      msgList.add(msg);
      return false;
    }
    return true;
  }

  /**
   * メールアカウント削除処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
    try {
      int accountId = rundata.getParameters().getInt("accountid");
      EipMMailAccount account = Database.get(EipMMailAccount.class, accountId);
      if (account == null) {
        throw new Exception("指定されたメールアカウントがデータベースにありません。ID=" + accountId);
      }

      AccountUtils.deleteAccount(accountId, msgList);

      Database.commit();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(
        account.getAccountId(),
        ALEventlogConstants.PORTLET_TYPE_WEBMAIL_ACCOUNT,
        account.getAccountName());

    } catch (Exception t) {
      Database.rollback();
      String msg = "メールアカウント情報の削除処理に失敗しました。";
      logger.error(msg, t);
      msgList.add(msg);
      return false;
    }
    return true;
  }

  /**
   * メールアカウント名取得
   * 
   * @return メールアカウント名
   */
  public ALStringField getAccountName() {
    return account_name;
  }

  /**
   * メールアカウントタイプ取得
   * 
   * @return メールアカウントタイプ
   */
  public ALStringField getAccountType() {
    return account_type;
  }

  // /**
  // * @return
  // */
  // public ALDateTimeField getCreateDate() {
  // return create_date;
  // }

  // /**
  // * @return
  // */
  // public ALNumberField getDelAtPop3Flg() {
  // return del_at_pop3_flg;
  // }

  /**
   * メールアドレス取得
   * 
   * @return メールアドレス
   */
  public ALStringField getMailAddress() {
    return mail_address;
  }

  /**
   * メールユーザー名取得
   * 
   * @return メールユーザー名
   */
  public ALStringField getMailUserName() {
    return mail_user_name;
  }

  // /**
  // * @return
  // */
  // public ALNumberField getNonReceivedFlg() {
  // return non_received_flg;
  // }

  /**
   * POP3パスワード取得
   * 
   * @return POP3パスワード取得
   */
  // remove start 運用フェーズ課題・障害台帳No.１５２
  // public ALStringField getPop3Password() {
  // return pop3_password;
  // }
  // remove end
  /**
   * POP3ポート番号取得
   * 
   * @return POP3ポート番号
   */
  public ALNumberField getPop3Port() {
    return pop3_port;
  }

  /**
   * POP3サーバー名取得
   * 
   * @return POP3サーバー名
   */
  public ALStringField getPop3serverName() {
    return pop3server_name;
  }

  /**
   * POP3ユーザー名取得
   * 
   * @return POP3ユーザー名
   */
  public ALStringField getPop3userName() {
    return pop3user_name;
  }

  /**
   * SMTPサーバー名取得
   * 
   * @return SMTPサーバー名
   */
  public ALStringField getSmtpserverName() {
    return smtpserver_name;
  }

  /**
   * SMTPポート番号取得
   * 
   * @return SMTPポート番号
   */
  public ALNumberField getSmtpPort() {
    return smtp_port;
  }

  // /**
  // * @return
  // */
  // public ALDateTimeField getUpdateDate() {
  // return update_date;
  // }

  /**
   * アカウントＩＤ取得
   * 
   * @return アカウントＩＤ
   */
  public int getAccountId() {
    return (int) account_id.getValue();
  }

  /**
   * ユーザーID取得
   * 
   * @return ユーザーID
   */
  public int getUserId() {
    return (int) user_id.getValue();
  }

  // public ALNumberField getAuthSendFlg() {
  // return auth_send_flg;
  // }
  //
  // public ALStringField getAuthSendUserId() {
  // return auth_send_user_id;
  // }
  //
  // public ALStringField getAuthSendUserPasswd() {
  // return auth_send_user_password;
  // }
  //
  // public ALNumberField getAuthReceiveFlg() {
  // return auth_receive_flag;
  // }
  //
  // public ALNumberField getDelAtPop3BeforeDaysFlg() {
  // return del_at_pop3_before_days_flg;
  // }
  //
  // public ALNumberField getDelAtPop3BeforeDays() {
  // return del_at_pop3_before_days;
  // }
  //
  // /**
  // * @return
  // */
  // public ALStringField getSignature() {
  // return signature;
  // }
  //
  // public ALNumberField getSmtpEncryptionFlag() {
  // return smtp_encryption_flag;
  // }
  //
  // public ALNumberField getPop3EncryptionFlag() {
  // return pop3_encryption_flag;
  // }

  // add start
  /**
   * 設定ファイルから<SMTPサーバ名>、<POP3サーバ名>、<SMTPポート番号>、<POP3ポート番号>を取得し、
   * それぞれのフィールド変数にセットするメソッドです。
   * 
   * @return 成功:true 失敗:false
   */
  public boolean setMailDefaultInfo() {
    try {
      // プロパティファイルから設定読み込み
      Properties prop = new Properties();
      prop.load(new FileInputStream(SETTING_FILE_PATH));

      String default_smtpserver_name = prop.getProperty("smtpserver_name");
      String default_pop3server_name = prop.getProperty("pop3server_name");
      String default_smtp_port = prop.getProperty("smtp_port");
      String default_pop3_port = prop.getProperty("pop3_port");

      // それぞれのフィールド変数に取得値を設定
      smtpserver_name.setValue(default_smtpserver_name);
      pop3server_name.setValue(default_pop3server_name);
      smtp_port.setValue(default_smtp_port);
      pop3_port.setValue(default_pop3_port);

    } catch (Exception ex) {
      String msg = "メールサーバ接続情報の取得に失敗しました。FILE=" + SETTING_FILE_PATH;
      logger.error(msg, ex);
      return false;
    }
    return true;
  }

  // add end

  // add start 2012.2.24 受入障害No.294
  /**
   * アカウント用途取得
   * 
   * @return アカウント用途種 通常:0 会議室:1
   */
  public ALStringField getAccountUsage() {
    return account_usage;
  }

  // add end
}
