/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.schedule.SchedulePrintWeeklySelectData;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * スケジュールの印刷用画面を処理するクラスです。 <br />
 * 
 */
public class SchedulePrintScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(SchedulePrintScreen.class.getName());

  /**
   * スケジュールの印刷用画面表示処理
   * 
   * @param rundata
   *          JetSpeedランデータ
   * @param context
   *          JetSpeedコンテキスト
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
    String portletId = portlet.getID();

    try {

      SchedulePrintWeeklySelectData listData = new SchedulePrintWeeklySelectData();
      (listData).setPortletId(portletId);
      listData.initField();
      listData.doViewList(this, rundata, context);

      String layout_template = null;
      if (listData.doViewList(this, rundata, context)) {
        String entityid = ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
        context.put(ALEipConstants.ENTITY_ID, entityid);
        layout_template = "portlets/html/ja/ajax-print-calendar-weekly.vm";
      } else {
        layout_template = "portlets/html/ja/DBErrorForWindow.vm";
      }

      context.put("theme", ALOrgUtilsService.getTheme());
      context.put("utils", new ALCommonUtils());
      Map<String, String> attribute = ALOrgUtilsService.getParameters();
      for (Map.Entry<String, String> e : attribute.entrySet()) {
        context.put(e.getKey(), e.getValue());
      }

      HttpServletResponse response = rundata.getResponse();
      response.setContentType("text/html; " + ALEipConstants.DEF_CONTENT_ENCODING);

      // setTemplate(
      // rundata,
      // context,
      // "portlets/html/ja/ajax-print-calendar-weekly.vm");
      setTemplate(rundata, context, layout_template);

    } catch (Exception ex) {
      logger.error("[SchedulePrintScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

}
