/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.auto._EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.auto._EipTScheduleMap;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;

// change start
///**
// * スケジュール1日表示の検索結果を管理するクラスです。
// *
// */
/**
 * 他ユーザースケジュール1日表示の検索結果を管理するクラスです。
 * 
 */
// change end
public class CellScheduleOnedaySelectByMemberData extends CellScheduleOnedaySelectData {

  /** <code>logger</code> logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(CellScheduleOnedaySelectByMemberData.class.getName());

  /** <code>login_user</code> 表示対象ユーザー */
  private ALEipUser targerUser;

  // remove start
  // ToDo リスト未使用のため削除
  // /** <code>todoList</code> ToDo リスト */
  // private List<ScheduleToDoResultData> todoList;
  //
  // /** ポートレット ID */
  // private String portletId;

  // remove end
  /** ログインユーザID */
  private int userid;

  // add start
  // 表示可否
  private String scheduleAcl;

  // 表示可否が「不可」の場合のエラーメッセージ
  private String errorMsg;

  // ログインユーザー名
  private String loginUserName;

  // add end
  @Override
  public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);

    userid = ALEipUtils.getUserId(rundata);

    // 表示対象ユーザー取得
    String s = rundata.getParameters().getString("selectedmember");
    if (s != null) {
      targerUser = ALEipUtils.getALEipUser(Integer.parseInt(s));
    }
    // remove start
    // else {
    // // ToDo詳細画面に遷移後に"前画面に戻る"で戻ってきた場合
    // s = ALEipUtils.getTemp(rundata, context, "target_otheruser_id");
    // targerUser = ALEipUtils.getALEipUser(Integer.parseInt(s));
    // }
    // remove end
    // add start
    else {
      targerUser = ALEipUtils.getALEipUser(userid);
    }
    int target_user_id = (int) targerUser.getUserId().getValue();
    // 現在のユーザー名を取得する
    ALEipUser loginuser = ALEipUtils.getALEipUser(rundata);
    loginUserName = loginuser.getAliasName().getValue();
    try {
      if (!("".equals(target_user_id))) {
        ALEipUser tempuser = ALEipUtils.getALEipUser(target_user_id);
        // <閲覧予定ユーザー>のログインユーザーに対する<表示可否>を取得する。
        scheduleAcl = ScheduleUtils.getScheduleAcl(Integer.toString(userid), Integer.toString(target_user_id));
        if (ScheduleConst.SCHEDULE_ACL_REFUSAL.equals(scheduleAcl)) {
          errorMsg = "[" + tempuser.getAliasName() + "さん]の予定を見る権限がありません。";
          return;
        }
      }
    } catch (Exception e) {
      errorMsg = "スケジュール(携帯・スマートフォン)1日一覧の表示に失敗しました" + loginUserName;
      logger.error(errorMsg + " " + e);
    }
    // add end
  }

  /**
   * 検索条件を設定した SelectQuery を返します。
   * 
   * @param rundata
   * @param context
   * @return
   */
  @Override
  protected SelectQuery<EipTScheduleMap> getSelectQuery(RunData rundata, Context context) {

    SelectQuery<EipTScheduleMap> query = Database.query(EipTScheduleMap.class);

    Expression exp1 = ExpressionFactory.matchExp(_EipTScheduleMap.USER_ID_PROPERTY, targerUser.getUserId().getValue());
    query.setQualifier(exp1);
    Expression exp2 = ExpressionFactory.matchExp(_EipTScheduleMap.TYPE_PROPERTY, ScheduleUtils.SCHEDULEMAP_TYPE_USER);
    query.andQualifier(exp2);

    // 終了日時
    Expression exp11 =
      ExpressionFactory.greaterOrEqualExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + _EipTSchedule.END_DATE_PROPERTY, getViewDate().getValue());
    // change start
    // // 日付を1日ずつずらす
    // Calendar cal = Calendar.getInstance();
    // cal.setTime(getViewDate().getValue());
    // cal.add(Calendar.DATE, 1);
    // ALCellDateTimeField field = new ALCellDateTimeField();
    // field.setValue(cal.getTime());
    // // 開始日時
    // // LESS_EQUALからLESS_THANへ修正、期間スケジュールFIXのため(Haruo Kaneko)
    // Expression exp12 =
    // ExpressionFactory.lessExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.START_DATE_PROPERTY, field.getValue());
    //
    // // 通常スケジュール
    // Expression exp13 =
    // ExpressionFactory.matchExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.REPEAT_PATTERN_PROPERTY, "N");
    // // 期間スケジュール
    // Expression exp14 =
    // ExpressionFactory.matchExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.REPEAT_PATTERN_PROPERTY, "S");
    //
    // // 繰り返しスケジュール（週間）
    // Calendar date = Calendar.getInstance();
    // date.setTime(getViewDate().getValue());
    // int weekindex = date.get(Calendar.DAY_OF_WEEK - 1);
    // String token = null;
    // StringBuffer sb = new StringBuffer();
    // sb.append("W");
    // for (int i = 0; i < 7; i++) {
    // if (i == weekindex) {
    // token = "1";
    // } else {
    // token = "_";
    // }
    // sb.append(token);
    // }
    //
    // Expression exp21 =
    // ExpressionFactory.likeExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.REPEAT_PATTERN_PROPERTY, (sb.toString() + "L"));
    // Expression exp22 =
    // ExpressionFactory.likeExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.REPEAT_PATTERN_PROPERTY, (sb.toString() + "N"));
    //
    // // 繰り返しスケジュール（日）
    // Expression exp23 =
    // ExpressionFactory.matchExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.REPEAT_PATTERN_PROPERTY, "DN");
    // Expression exp31 =
    // ExpressionFactory.matchExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.REPEAT_PATTERN_PROPERTY, "DL");
    //
    // // 繰り返しスケジュール（月）
    // SimpleDateFormat sdf = new SimpleDateFormat("dd");
    // sdf.setTimeZone(TimeZone.getDefault());
    // String dayStr = sdf.format(date.getTime());
    //
    // Expression exp24 =
    // ExpressionFactory.likeExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.REPEAT_PATTERN_PROPERTY, ("M" + dayStr + "L"));
    // Expression exp25 =
    // ExpressionFactory.likeExp(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY
    // + "."
    // + _EipTSchedule.REPEAT_PATTERN_PROPERTY, ("M" + dayStr + "N"));
    //
    // query.andQualifier((exp11.andExp(exp12).andExp(((exp13).orExp(exp14))
    // .orExp(exp21)
    // .orExp(exp31)
    // .orExp(exp24))).orExp(exp22.orExp(exp23).orExp(exp25)));
    // 開始日時
    Calendar cal = Calendar.getInstance();
    cal.setTime(getViewDate().getValue());
    cal.add(Calendar.DATE, 1);
    // getViewDate().setValue(cal.getTime());
    Expression exp12 = ExpressionFactory.lessExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + EipTSchedule.START_DATE_PROPERTY, cal.getTime());
    // 通常スケジュール
    Expression exp13 = ExpressionFactory.noMatchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + EipTSchedule.REPEAT_PATTERN_PROPERTY, "N");
    // 期間スケジュール
    Expression exp14 = ExpressionFactory.noMatchExp(EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + EipTSchedule.REPEAT_PATTERN_PROPERTY, "S");
    query.andQualifier((exp11.andExp(exp12)).orExp(exp13.andExp(exp14)));
    // change end

    // 開始日時でソート
    List<Ordering> orders = new ArrayList<Ordering>();
    orders.add(new Ordering(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + _EipTSchedule.START_DATE_PROPERTY, true));
    orders.add(new Ordering(_EipTScheduleMap.EIP_TSCHEDULE_PROPERTY + "." + _EipTSchedule.END_DATE_PROPERTY, true));
    query.getQuery().addOrderings(orders);

    return query;
  }

  // remove start
  // TODO未使用のため削除
  // @Override
  // public void loadToDo(RunData rundata, Context context) {
  // todoList = new ArrayList<ScheduleToDoResultData>();
  // try {
  // SelectQuery<EipTTodo> query = getSelectQueryForTodo(rundata, context);
  // List<EipTTodo> todos = query.fetchList();
  //
  // int todosize = todos.size();
  // for (int i = 0; i < todosize; i++) {
  // EipTTodo record = todos.get(i);
  // ScheduleToDoResultData rd = new ScheduleToDoResultData();
  // rd.initField();
  //
  // // ポートレット ToDo のへのリンクを取得する．
  // String todo_url =
  // getPortletURItoTodo(
  // rundata,
  // record.getTodoId().longValue(),
  // portletId);
  //
  // rd.setTodoId(record.getTodoId().intValue());
  // rd.setTodoName(record.getTodoName());
  // rd.setUserId(record.getTurbineUser().getUserId().intValue());
  // rd.setStartDate(record.getStartDate());
  // rd.setEndDate(record.getEndDate());
  // rd.setTodoUrl(todo_url);
  // // 公開/非公開を設定する．
  // rd.setPublicFlag("T".equals(record.getPublicFlag()));
  // todoList.add(rd);
  // }
  // } catch (Exception ex) {
  // logger.error("Exception", ex);
  // return;
  // }
  // }

  // private SelectQuery<EipTTodo> getSelectQueryForTodo(RunData rundata,
  // Context context) {
  // // Integer uid = Integer.valueOf(ALEipUtils.getUserId(rundata));
  // Integer uid = (int) targerUser.getUserId().getValue();
  // SelectQuery<EipTTodo> query = Database.query(EipTTodo.class);
  //
  // Expression exp1 =
  // ExpressionFactory.noMatchExp(EipTTodo.STATE_PROPERTY, Short
  // .valueOf((short) 100));
  // query.setQualifier(exp1);
  // Expression exp2 =
  // ExpressionFactory.matchExp(EipTTodo.ADDON_SCHEDULE_FLG_PROPERTY, "T");
  // query.andQualifier(exp2);
  // Expression exp3 =
  // ExpressionFactory.matchDbExp(TurbineUser.USER_ID_PK_COLUMN, uid);
  // query.andQualifier(exp3);
  //
  // // 終了日時
  // Expression exp11 =
  // ExpressionFactory.greaterOrEqualExp(
  // EipTTodo.END_DATE_PROPERTY,
  // getViewDate().getValue());
  // // 開始日時
  // Expression exp12 =
  // ExpressionFactory.lessOrEqualExp(
  // EipTTodo.START_DATE_PROPERTY,
  // getViewDate().getValue());
  //
  // // 開始日時のみ指定されている ToDo を検索
  // Expression exp21 =
  // ExpressionFactory.lessOrEqualExp(
  // EipTTodo.START_DATE_PROPERTY,
  // getViewDate().getValue());
  // Expression exp22 =
  // ExpressionFactory.matchExp(EipTTodo.END_DATE_PROPERTY, ToDoUtils
  // .getEmptyDate());
  //
  // // 終了日時のみ指定されている ToDo を検索
  // Expression exp31 =
  // ExpressionFactory.greaterOrEqualExp(
  // EipTTodo.END_DATE_PROPERTY,
  // getViewDate().getValue());
  // Expression exp32 =
  // ExpressionFactory.matchExp(EipTTodo.START_DATE_PROPERTY, ToDoUtils
  // .getEmptyDate());
  //
  // query.andQualifier((exp11.andExp(exp12)).orExp(exp21.andExp(exp22)).orExp(
  // exp31.andExp(exp32)));
  // return query;
  // }
  // remove end
  /**
   * 
   * @param record
   * @return
   * @throws ALPageNotFoundException
   * @throws ALDBErrorException
   */
  @Override
  protected Object getResultData(EipTScheduleMap record) throws ALPageNotFoundException, ALDBErrorException {
    CellScheduleResultData rd = new CellScheduleResultData();
    // 未使用
    // remove start
    // CellScheduleResultData rd2 = new CellScheduleResultData();
    // remove end
    rd.initField();
    // remove start
    // 未使用
    // rd2.setFormat("yyyy-MM-dd-HH-mm");
    // rd2.initField();
    // remove end
    try {
      EipTSchedule schedule = record.getEipTSchedule();
      if ("R".equals(record.getStatus())) {
        // 参加メンバーが削除したレコード(格納しません）
        // change start
        // return rd;
        return null;
        // change end
      }
      // add start
      // 参照権限が無い場合は格納しない
      if (ScheduleConst.SCHEDULE_ACL_REFUSAL.equals(scheduleAcl)) {
        return null;
      }
      // add end
      if (!ScheduleUtils.isView(getViewDate(), schedule.getRepeatPattern(), schedule.getStartDate(), schedule.getEndDate())) {
        // change start
        // return rd;
        return null;
        // change end
      }

      // remove start
      // ID
      // rd.setScheduleId(schedule.getScheduleId().intValue());
      // // 親スケジュール ID
      // rd.setParentId(schedule.getParentId().intValue());
      // // 予定
      // rd.setName(schedule.getName());
      // // 開始時間
      // rd.setStartDate(schedule.getStartDate());
      // // 終了時間
      // rd.setEndDate(schedule.getEndDate());
      // // 仮スケジュールかどうか
      // rd.setTmpreserve("T".equals(record.getStatus()));
      // // 公開するかどうか
      // rd.setPublic("O".equals(schedule.getPublicFlag()));
      // // 表示するかどうか
      // rd.setHidden("P".equals(schedule.getPublicFlag()));
      // // ダミーか
      // rd.setDummy("D".equals(record.getStatus()));
      // // 繰り返しパターン
      // rd.setPattern(schedule.getRepeatPattern());
      //
      // // add start
      // // 場所
      // rd.setPlace(schedule.getPlace());
      // // 状態
      // rd.setStatus(record.getStatus());
      // // 重要フラグ
      // rd.setPriority(record.getPriority());
      // // 承諾／仮承諾／辞退対応
      // // 必須/任意フラグ
      // rd.setRequired(record.getRequired());
      // // ダミー未回答フラグ
      // rd.setRequired(record.getDummyNonResponse());
      // add end
      // remove end

      // is_memberのチェック
      SelectQuery<EipTScheduleMap> mapquery = Database.query(EipTScheduleMap.class);
      Expression mapexp1 = ExpressionFactory.matchExp(EipTScheduleMap.SCHEDULE_ID_PROPERTY, record.getScheduleId());
      mapquery.setQualifier(mapexp1);

      Expression mapexp2 = ExpressionFactory.matchExp(EipTScheduleMap.USER_ID_PROPERTY, Integer.valueOf(userid));
      mapquery.andQualifier(mapexp2);

      Expression mapexp3 = ExpressionFactory.noMatchExp(EipTScheduleMap.STATUS_PROPERTY, "R");
      mapquery.andQualifier(mapexp3);

      List<EipTScheduleMap> schedulemaps = mapquery.fetchList();

      boolean is_member = (schedulemaps != null && schedulemaps.size() > 0) ? true : false;
      rd.setMember(is_member);

      // add start
      if (ScheduleConst.SCHEDULE_ACL_PUBLIC.equals(scheduleAcl) && !"D".equals(record.getStatus()) && "P".equals(schedule.getPublicFlag()) && !is_member) {
        // 完全に非公開(格納しません）
        return null;
      }

      if (ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl)
        && !"D".equals(record.getStatus())
        && "P".equals(schedule.getPublicFlag())
        && (schedule.getCreateUserId().intValue() == record.getUserId().intValue())
        && !is_member) {
        // 秘書設定元ユーザーが作成者で完全に非公開(格納しません）
        return null;
      }

      if (ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl)
        && !"D".equals(record.getStatus())
        && "P".equals(schedule.getPublicFlag())
        && (schedule.getCreateUserId().intValue() != userid)
        && !is_member) {
        // 秘書が作成者で無ければ完全に非公開(格納しません）
        return null;
      }
      // add end

      // 非公開／完全に隠すに対応
      // remove start
      // boolean publicable = schedule.getPublicFlag().equals("O");
      // if (!publicable && !is_member) {
      // rd.setName("非公開");
      // }
      // remove end
      boolean hidden = schedule.getPublicFlag().equals("P");
      if (hidden && !is_member) {
        // 「完全に隠す」でメンバーでない場合(格納しません）
        return null;
      }

      // add start
      // 役員自身が「非公開」設定した場合は秘書でも詳細閲覧はできない
      if ("C".equals(schedule.getPublicFlag())
        && (ScheduleConst.SCHEDULE_ACL_PUBLIC.equals(scheduleAcl) || (ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl) && schedule
          .getCreateUserId()
          .intValue() == record.getUserId().intValue()))
        && !is_member) {
        // 名前
        rd.setName("非公開");
        // 仮スケジュールかどうか
        rd.setTmpreserve(false);

        // 場所
        rd.setPlace("");
        // 状態
        rd.setStatus("");
        // 重要フラグ
        rd.setPriority("");
        // add start 要件No.26 スケジュール個別色換え
        // ログインユーザー
        rd.setLoginuser(false);
        // 個別色
        rd.setIndividualColor("");
        // add end

      } else {
        // 名前
        rd.setName(schedule.getName());
        // 仮スケジュールかどうか
        rd.setTmpreserve("T".equals(record.getStatus()));

        // 場所
        rd.setPlace(schedule.getPlace());
        // 状態
        rd.setStatus(record.getStatus());
        // 重要フラグ
        rd.setPriority(record.getPriority());
        // add start 要件No.26 スケジュール個別色換え
        // ログインユーザー=対象者 または ログインユーザー=対象者の秘書 の場合、ログインユーザー扱いにする
        rd.setLoginuser(record.getUserId().intValue() == userid || ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl));
        // 個別色
        rd.setIndividualColor(record.getIndividualColor());
        // add end

      }
      // ID
      rd.setScheduleId(schedule.getScheduleId().intValue());
      // 親スケジュール ID
      rd.setParentId(schedule.getParentId().intValue());
      // 名前
      rd.setName(schedule.getName());
      // 開始日時
      rd.setStartDate(schedule.getStartDate());
      // 終了日時
      rd.setEndDate(schedule.getEndDate());
      // 仮スケジュールかどうか
      rd.setTmpreserve("T".equals(record.getStatus()));
      // 公開するかどうか
      rd.setPublic("O".equals(schedule.getPublicFlag()));
      // 非表示にするかどうか
      rd.setHidden("P".equals(schedule.getPublicFlag()));
      // ダミーか
      rd.setDummy("D".equals(record.getStatus()));

      // remove start 要件No.26 スケジュール個別色換え
      // ログインユーザかどうか
      // rd.setLoginuser(record.getUserId().intValue() == userid);
      // remove end
      // オーナーかどうか
      // rd.setOwner(schedule.getOwnerId().intValue() == userid_int);
      // change start 要件No.26 スケジュール個別色換え
      // if (ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl) &&
      // ("C".equals(schedule.getPublicFlag()) ||
      // "P".equals(schedule.getPublicFlag()))) {
      // // ログインユーザーが閲覧対象ユーザーに対して”秘書”で、かつ、公開区分が”非公開”もしくは
      // // ”完全に非公開”の場合
      // if (schedule.getCreateUserId().intValue() == userid) {
      // // 秘書が作成者
      // rd.setOwner(true);
      // } else if (schedule.getCreateUserId().intValue() !=
      // record.getUserId().intValue()) {
      // // 作成者が役員本人ではない
      // rd.setOwner(true);
      // } else {
      // rd.setOwner(schedule.getOwnerId().intValue() == userid);
      // }
      // } else {
      // rd.setOwner(schedule.getOwnerId().intValue() == userid);
      // }
      // ログインユーザーが主催者 または 主催者の秘書の場合、オーナー扱いにする
      if (schedule.getOwnerId().intValue() == userid) {
        // ログインユーザーが主催者
        rd.setOwner(true);
      } else if (schedule.getOwnerId().intValue() == record.getUserId().intValue() && ScheduleConst.SCHEDULE_ACL_SECRETARY.equals(scheduleAcl)) {
        // ログインユーザーが主催者の秘書
        rd.setOwner(true);
      } else {
        rd.setOwner(false);
      }
      // change end
      // remove start 要件No.26 スケジュール個別色換え
      // // 共有メンバーかどうか
      // rd.setMember(is_member);
      // remove end

      // 繰り返しパターン
      rd.setPattern(schedule.getRepeatPattern().toString());

      // ステータス
      rd.setStatus(record.getStatus());
      // 場所
      rd.setPlace(schedule.getPlace());
      // 承諾／仮承諾／辞退対応
      // 必須/任意フラグ
      rd.setRequired(record.getRequired());
      // ダミー未回答フラグ
      rd.setRequired(record.getDummyNonResponse());
      // add end

      // add start 要件No.9 スケジュール表示 （仮の予定、確定した予定）
      rd.setTemporaryFlag(schedule.getTemporaryFlag());
      // add end

      // // 期間スケジュールの場合
      if (rd.getPattern().equals("S")) {
        // spanResultData = rd;
        rd.setSpan(true);
        return rd;
      }
      // change start
      // // 繰り返しスケジュールの場合
      // if (!rd.getPattern().equals("N")) {
      //
      // if (!ScheduleUtils.isView(getViewDate(), rd.getPattern(), rd
      // .getStartDate()
      // .getValue(), rd.getEndDate().getValue())) {
      // return rd;
      // }
      // rd.setRepeat(true);
      // }

      // ひまたぎスケジュールの場合
      if (rd.getPattern().equals("Z")) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(getViewDate().getValue());
        cal1.set(Calendar.HOUR_OF_DAY, 0);
        cal1.set(Calendar.MINUTE, 0);
        Date tmpTargetDate = cal1.getTime();

        Calendar calStart = Calendar.getInstance();
        calStart.setTime(rd.getStartDate().getValue());
        calStart.set(Calendar.HOUR_OF_DAY, 0);
        calStart.set(Calendar.MINUTE, 0);
        Date tmpStartDate = calStart.getTime();

        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(rd.getEndDate().getValue());
        calEnd.set(Calendar.HOUR_OF_DAY, 0);
        calEnd.set(Calendar.MINUTE, 0);
        Date tmpEndDate = calEnd.getTime();

        Calendar temp = Calendar.getInstance();
        Calendar temp2 = Calendar.getInstance();
        if (tmpTargetDate.compareTo(tmpStartDate) == 0) {
          // 対象日が日またぎの開始日
          temp.setTime(rd.getStartDate().getValue());
          temp2.setTime(rd.getStartDate().getValue());
          temp2.set(Calendar.HOUR_OF_DAY, 23);
          temp2.set(Calendar.MINUTE, 59);
          temp2.set(Calendar.SECOND, 0);
        } else if (tmpTargetDate.after(tmpStartDate) && tmpTargetDate.before(tmpEndDate)) {
          // 対象日が開始日より後、かつ対象日が終了日の前
          temp.setTime(getViewDate().getValue());
          temp.set(Calendar.HOUR_OF_DAY, 0);
          temp.set(Calendar.MINUTE, 0);
          temp.set(Calendar.SECOND, 0);
          temp2.setTime(getViewDate().getValue());
          temp2.set(Calendar.HOUR_OF_DAY, 23);
          temp2.set(Calendar.MINUTE, 59);
          temp2.set(Calendar.SECOND, 0);
        } else if (tmpTargetDate.compareTo(tmpEndDate) == 0) {
          // 対象日が日またぎの終了日
          temp.setTime(rd.getEndDate().getValue());
          temp.set(Calendar.HOUR_OF_DAY, 0);
          temp.set(Calendar.MINUTE, 0);
          temp.set(Calendar.SECOND, 0);
          temp2.setTime(rd.getEndDate().getValue());
        } else {
          // いずれの条件にも合致しなければ処理対象外
          rd.initField();
          return null;
        }
        return resultData2resultData(rd, temp, temp2);
      } else /* add end */if (!rd.getPattern().equals("N")) {
        // 繰り返しスケジュールの場合
        if (!ScheduleUtils.isView(getViewDate(), rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
          // change start
          // return rd;
          Calendar temp = Calendar.getInstance();
          temp.setTime(getViewDate().getValue());
          temp.set(Calendar.HOUR, Integer.parseInt(rd.getStartDate().getHour()));
          temp.set(Calendar.MINUTE, Integer.parseInt(rd.getStartDate().getMinute()));
          temp.set(Calendar.SECOND, 0);
          temp.set(Calendar.MILLISECOND, 0);
          Calendar temp2 = Calendar.getInstance();
          temp2.setTime(getViewDate().getValue());
          temp2.set(Calendar.HOUR, Integer.parseInt(rd.getEndDate().getHour()));
          temp2.set(Calendar.MINUTE, Integer.parseInt(rd.getEndDate().getMinute()));
          temp2.set(Calendar.SECOND, 0);
          temp2.set(Calendar.MILLISECOND, 0);
          return resultData2resultData(rd, temp, temp2);
        }
        rd.setRepeat(true);
      }
      // change end
    } catch (Exception e) {
      // change start
      // logger.error("Exception", e);
      logger.error("スケジュール(携帯・スマートフォン)1日一覧の表示に失敗しました" + loginUserName, e);
      // change end
      return null;
    }
    return rd;
  }

  public ALEipUser getTargerUser() {
    return targerUser;
  }

  public void setTargerUser(ALEipUser targerUser) {
    this.targerUser = targerUser;
  }

  // remove start
  // @Override
  // public List<ScheduleToDoResultData> getToDoResultDataList() {
  // return todoList;
  // }

  // @Override
  // public void setPortletId(String id) {
  // portletId = id;
  // }
  // remove end
  // add start
  /**
   * エラーメッセージを返します。
   * 
   * @return エラーメッセージ
   */
  public String getErrorMsg() {
    return errorMsg;
  }
  // add end
}
