/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule.beans;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;

/**
 * スケジュールポートレット用ユーザー情報Bean
 */
public class ScheduleUserBean implements Cloneable {

  /** ユーザーID */
  private ALNumberField usetId = null;

  /** ログイン名 */
  private ALStringField loginName = null;

  /** 名 */
  private ALStringField firstName = null;

  /** 姓 */
  private ALStringField lastName = null;

  /** 名（カナ） */
  private ALStringField firstNameKana = null;

  /** 姓（カナ） */
  private ALStringField lastNameKana = null;

  /** 職種（コード+名称） */
  private ALStringField category = null;

  /** 表示名（並び順コード+氏名） */
  private ALStringField displayName = null;

  /** （使用者からみた）アクセス権限 */
  private String accessCtrl = null;

  /**
   * 全フィールドに該当型フィールドインスタンスを設定
   */
  public ScheduleUserBean() {
    usetId = new ALNumberField();
    loginName = new ALStringField();
    firstName = new ALStringField();
    lastName = new ALStringField();
    firstNameKana = new ALStringField();
    lastNameKana = new ALStringField();
    category = new ALStringField();
    displayName = new ALStringField();
    accessCtrl = "";
  }

  /**
   * 数値型ユーザーIDを返します。
   * 
   * @return 数値型ユーザーID
   */
  public long getUsetId() {
    return usetId.getValue();
  }

  /**
   * 文字型ユーザーIDを返します。
   * 
   * @return 文字型ユーザーID
   */
  public String getUsetIdValue() {
    return usetId.toString();
  }

  /**
   * ユーザーIDを設定します。
   * 
   * @param usetId
   *          ユーザーID
   */
  public void setUsetId(long usetId) {
    this.usetId.setValue(usetId);
  }

  /**
   * ログイン名を返します。
   * 
   * @return ログイン名
   */
  public String getLoginName() {
    return loginName.toString();
  }

  /**
   * ログイン名を設定します。
   * 
   * @param loginName
   *          ログイン名
   */
  public void setLoginName(String loginName) {
    this.loginName.setValue(loginName);
  }

  /**
   * 名を返します。
   * 
   * @return 名
   */
  public String getFirstName() {
    return firstName.toString();
  }

  /**
   * 名を設定します。
   * 
   * @param firstName
   *          名
   */
  public void setFirstName(String firstName) {
    this.firstName.setValue(firstName);
  }

  /**
   * 姓を返します。
   * 
   * @return 姓
   */
  public String getLastName() {
    return lastName.toString();
  }

  /**
   * 姓を設定します。
   * 
   * @param lastName
   *          姓
   */
  public void setLastName(String lastName) {
    this.lastName.setValue(lastName);
  }

  /**
   * 姓+名を返します。
   * 
   * @return 姓+名
   */
  public String getAliasName() {
    return lastName.toString() + " " + firstName.toString();
  }

  /**
   * 名（カナ）を返します。
   * 
   * @return 名（カナ）
   */
  public String getFirstNameKana() {
    return firstNameKana.toString();
  }

  /**
   * 名（カナ）を設定します。
   * 
   * @param firstNameKana
   *          名（カナ）
   */
  public void setFirstNameKana(String firstNameKana) {
    this.firstNameKana.setValue(firstNameKana);
  }

  /**
   * 姓（カナ）を返します。
   * 
   * @return 姓（カナ）
   */
  public String getLastNameKana() {
    return lastNameKana.toString();
  }

  /**
   * 姓（カナ）を設定します。
   * 
   * @param lastNameKana
   *          姓（カナ）
   */
  public void setLastNameKana(String lastNameKana) {
    this.lastNameKana.setValue(lastNameKana);
  }

  /**
   * 姓（カナ）+名（カナ）を返します。
   * 
   * @return 姓+名
   */
  public String getAliasNameKana() {
    return lastNameKana.toString() + " " + firstNameKana.toString();
  }

  /**
   * 職種（コード+名称）を返します。
   * 
   * @return 職種
   */
  public String getCategory() {
    return category.toString();
  }

  /**
   * 職種（コード+名称）を設定します。
   * 
   * @param category
   *          職種
   */
  public void setCategory(String category) {
    this.category.setValue(category);
  }

  /**
   * 表示名（並び順コード+氏名）を取得します。
   * 
   * @return 表示名
   */
  public String getDisplayName() {
    return displayName.toString();
  }

  /**
   * 表示名（並び順コード+氏名）を設定します。
   * 
   * @param displayName
   *          表示名
   */
  public void setDisplayName(String displayName) {
    this.displayName.setValue(displayName);
  }

  /**
   * （使用者からみた）アクセス権限を返します。
   * 
   * @return アクセス権限
   */
  public String getAccessCtrl() {
    return accessCtrl;
  }

  /**
   * （使用者からみた）アクセス権限を設定します。
   * 
   * @param accessCtrl
   *          アクセス権限
   */
  public void setAccessCtrl(String accessCtrl) {
    this.accessCtrl = accessCtrl;
  }

}
