/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.webmail;

import java.util.ArrayList;
import java.util.StringTokenizer;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.addressbook.AddressBookCorpFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookPost1SelectData;
import com.aimluck.eip.addressbook.AddressBookPost2SelectData;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.CellWebMailAccountSelectData;
import com.aimluck.eip.webmail.CellWebMailFormData;
import com.aimluck.eip.webmail.WebMailConsts;
import com.aimluck.eip.webmail.WebMailFormData;
import com.aimluck.eip.webmail.WebMailSelectData;
import com.aimluck.eip.webmail.WebMailSendSelectData;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * Webメールのアクションクラスです。
 * 
 */
public class CellWebMailAction extends WebMailAction {

  /** <code>logger</code> logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(CellWebMailAction.class.getName());

  /**
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) {

  }

  /**
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {
    // MODEを取得
    String mode = rundata.getParameters().getString(ALEipConstants.MODE);
    try {
      if (ALEipConstants.MODE_FORM.equals(mode)) {
        // doWebmail_form(rundata, context);
      } else if (ALEipConstants.MODE_DETAIL.equals(mode)) {
        // doSchedule_detail(rundata, context);
      } else if (ALEipConstants.MODE_LIST.equals(mode)) {
        doWebmail_account_list(rundata, context);
      }
      if (getMode() == null) {
        doWebmail_menu(rundata, context);
      }
    } catch (Exception ex) {
      logger.error("[CellWebMailAction] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

  /**
   * メールを作成するページ(初期表示)を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_create_mail(RunData rundata, Context context)
      throws Exception {
    ALEipUtils.removeTemp(rundata, context, ALEipConstants.ENTITY_ID);

    // ACCOUNT_ID の取得
    String accountId =
      rundata.getParameters().getString(WebMailUtils.ACCOUNT_ID);
    if (accountId != null) {
      // ACCOUNT_ID をセッションに登録する．
      ALEipUtils.setTemp(rundata, context, WebMailUtils.ACCOUNT_ID, accountId);
    }
    // add start
    // メールタイプ設定
    if (rundata.getParameters().containsKey(WebMailUtils.MAIL_TYPE)) {
      if (String.valueOf(WebMailFormData.TYPE_REPLY_MAIL).equals(
        rundata.getParameters().getString(WebMailUtils.MAIL_TYPE))) {
        context.put(WebMailUtils.MAIL_TYPE, WebMailFormData.TYPE_REPLY_MAIL);
      } else {
        context.put(WebMailUtils.MAIL_TYPE, WebMailFormData.TYPE_FORWARD_MAIL);
      }
    }
    // add end
    // showMailForm(rundata, context, WebMailFormData.TYPE_NEW_MAIL);

    showMailForm(rundata, context);
  }

  /**
   * 指定したメール種別に応じて，メールを作成するページを表示する．
   * 
   * @param rundata
   * @param context
   * @param mailType
   */
  // private void showMailForm(RunData rundata, Context context, int mailType) {
  private void showMailForm(RunData rundata, Context context) {
    WebMailFormData formData = new WebMailFormData();
    // formData.initField(mailType);
    formData.initField();
    // add start
    formData.setCellularSmartPhone(true);
    // add end
    formData.doViewForm(this, rundata, context);
    setTemplate(rundata, "webmail-form");
  }

  /**
   * 指定したフォルダにあるメールの内容を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_show_mail(RunData rundata, Context context)
      throws Exception {
    WebMailSelectData detailData = new WebMailSelectData();
    detailData.initField();
    if (detailData.doViewDetail(this, rundata, context)) {
      String mailIndex =
        rundata.getParameters().getString(ALEipConstants.ENTITY_ID);
      context.put(WebMailUtils.ACCOUNT_ID, ALEipUtils.getTemp(
        rundata,
        context,
        WebMailUtils.ACCOUNT_ID));
      context.put("currentTab", ALEipUtils.getTemp(rundata, context, "tab"));
      context.put(ALEipConstants.ENTITY_ID, mailIndex);
      setTemplate(rundata, "webmail-detail");
    } else {
      doWebmail_account_list(rundata, context);
    }
  }

  // add start
  // PC版にて受信、送信の詳細取得処理を分けるよう改修されたため
  // 携帯版もPC版クラスを使用するため変更
  /**
   * 送信フォルダにあるメールの内容を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_show_sent_mail(RunData rundata, Context context)
      throws Exception {
    WebMailSendSelectData detailData = new WebMailSendSelectData();
    detailData.initField();
    if (detailData.doViewDetail(this, rundata, context)) {
      String mailIndex =
        rundata.getParameters().getString(ALEipConstants.ENTITY_ID);
      context.put(WebMailUtils.ACCOUNT_ID, ALEipUtils.getTemp(
        rundata,
        context,
        WebMailUtils.ACCOUNT_ID));
      context.put("currentTab", ALEipUtils.getTemp(rundata, context, "tab"));
      context.put(ALEipConstants.ENTITY_ID, mailIndex);
      setTemplate(rundata, "webmail-detail");
    } else {
      doWebmail_account_list(rundata, context);
    }
  }

  /**
   * アドレス帳(社内/個人選択画面)初期画面(Toからアドレス帳ボタンを押した場合)を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_addr_list_to(RunData rundata, Context context)
      throws Exception {
    // セッション情報初期化
    removeTemp(rundata, context);
    // アドレス帳を開くときは入力内容保持のためメール作成画面の項目をセッションにセットする
    setTemp(rundata, context, WebMailConsts.STR_TO);
    doWebmail_addr_list(rundata, context);
  }

  /**
   * アドレス帳(社内/個人選択画面)初期画面(CCからアドレス帳ボタンを押した場合)を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_addr_list_cc(RunData rundata, Context context)
      throws Exception {
    // セッション情報初期化
    removeTemp(rundata, context);
    // アドレス帳を開くときはメール作成画面の項目をセッションにセットする
    setTemp(rundata, context, WebMailConsts.STR_CC);
    doWebmail_addr_list(rundata, context);
  }

  /**
   * アドレス帳(社内/個人選択画面)初期画面(BCCからアドレス帳ボタンを押した場合)を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_addr_list_bcc(RunData rundata, Context context)
      throws Exception {
    // セッション情報初期化
    removeTemp(rundata, context);
    // アドレス帳を開くときはメール作成画面の項目をセッションにセットする
    setTemp(rundata, context, WebMailConsts.STR_BCC);
    doWebmail_addr_list(rundata, context);
  }

  /**
   * アドレス帳(社内/個人選択画面)初期画面を表示します。
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_addr_list(RunData rundata, Context context)
      throws Exception {
    WebMailSelectData listData = new WebMailSelectData();
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "webmail-addr-search");
  }

  /**
   * 社内/個人アドレス切り替えによる検索処理を行います。
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_addr_search(RunData rundata, Context context)
      throws Exception {
    String addr_search_select_type = rundata.getParameters().getString("tab");
    if ("syagai".equals(addr_search_select_type)) {
      // 個人アドレス切り替えによる個人アドレスグループ検索処理を行います。
      AddressBookFilterdSelectData listData =
        new AddressBookFilterdSelectData();
      listData.setRowsNum(20);
      listData.doViewList(this, rundata, context);
      listData.loadGroups(rundata, context);
      putData(rundata, context);
      setTemplate(rundata, "webmail-personal-group-list");
    } else if ("corp".equals(addr_search_select_type)) {
      // 社内アドレス切り替えによる部署1検索処理を行います。
      AddressBookPost1SelectData listData = new AddressBookPost1SelectData();
      listData.doViewList(this, rundata, context);
      putData(rundata, context);
      setTemplate(rundata, "webmail-post1-search");
    } else {
      // 個人アドレス切り替えによる個人アドレスグループ検索後の個人検索処理を行います。
      AddressBookFilterdSelectData listData =
        new AddressBookFilterdSelectData();
      listData.setRowsNum(1000);
      listData.doViewList(this, rundata, context);
      listData.loadGroups(rundata, context);
      putData(rundata, context);
      setTemplate(rundata, "webmail-personal-list");
    }
  }

  /**
   * 社内アドレス切り替えによる部署2検索処理を行います。
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_post2_search(RunData rundata, Context context)
      throws Exception {
    AddressBookPost2SelectData listData = new AddressBookPost2SelectData();
    listData.doViewList(this, rundata, context);
    putData(rundata, context);
    if ("groupsend".equals(rundata.getParameters().getString(
      "parent_group_name"))) {
      // グループ送信（グループ指定）の場合、選択済みグループが在る場合は、当該グループのチェック状態をONにする。
      // 選択状態ONにするグループID一覧を画面に返すためのリストを作成
      ArrayList<String> hiddenGroupIdList = new ArrayList<String>();
      String str_groupsend_id = "";
      // 送信タイプにより参照する入力済みフィールド先を振り分ける
      if (WebMailConsts.STR_TO.equals(ALEipUtils.getTemp(
        rundata,
        context,
        WebMailConsts.MAIL_SENT_TYPE))) {
        str_groupsend_id =
          ALEipUtils.getTemp(rundata, context, WebMailConsts.STR_TO_GROUPSEND);
      } else if (WebMailConsts.STR_CC.equals(ALEipUtils.getTemp(
        rundata,
        context,
        WebMailConsts.MAIL_SENT_TYPE))) {
        str_groupsend_id =
          ALEipUtils.getTemp(rundata, context, WebMailConsts.STR_CC_GROUPSEND);
      } else if (WebMailConsts.STR_BCC.equals(ALEipUtils.getTemp(
        rundata,
        context,
        WebMailConsts.MAIL_SENT_TYPE))) {
        str_groupsend_id =
          ALEipUtils.getTemp(rundata, context, WebMailConsts.STR_BCC_GROUPSEND);
      }
      StringTokenizer st = new StringTokenizer(str_groupsend_id, ",");
      while (st.hasMoreTokens()) {
        hiddenGroupIdList.add(st.nextToken());
      }
      context.put("hiddenGroupIdList", hiddenGroupIdList);
      setTemplate(rundata, "webmail-groupsend-list");
    } else {
      // グループ送信（グループ指定）以外は部署2選択画面へ遷移させる
      setTemplate(rundata, "webmail-post2-search");
    }
  }

  /**
   * 部署2所属ユーザー検索処理を行います。
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_corp_list(RunData rundata, Context context)
      throws Exception {
    ALEipUtils.setTemp(rundata, context, "tab", "corp");
    AddressBookCorpFilterdSelectData listData =
      new AddressBookCorpFilterdSelectData();
    listData.setRowsNum(1000);
    listData.doViewList(this, rundata, context);
    context.put("parent_group_name", rundata.getParameters().getString(
      "parent_group_name"));
    context.put("post2_group_name", rundata.getParameters().getString(
      "post2_group_name"));
    setTemplate(rundata, "webmail-corp-list");
  }

  /**
   * メール作成ページ(初期表示以外)を表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_create_mail_with_session(RunData rundata,
      Context context) throws Exception {
    // アカウント一覧以外からメール作成画面を呼ぶ場合は入力内容保持のため
    // セッションから入力内容を取得し表示します。
    CellWebMailFormData formData = new CellWebMailFormData();
    formData.initField();
    if (formData.doViewForm(this, rundata, context)) {
      setTemplate(rundata, "webmail-form");
    } else {
      if (rundata.getParameters().containsKey("set_corp_flg")) {
        context.put("parent_group_name", rundata.getParameters().getString(
          "parent_group_name"));
        context.put("post2_group_name", rundata.getParameters().getString(
          "post2_group_name"));
        doWebmail_corp_list(rundata, context);
      } else {
        // context.put("filtertype", "group");
        // context.put("post2_group_name", rundata.getParameters().getString(
        // "post2_group_name"));
        doWebmail_addr_search(rundata, context);
      }
    }
  }

  /**
   * メール作成画面の項目をセッションにセットします。
   * 
   * @param rundata
   * @param context
   */
  private void setTemp(RunData rundata, Context context, String mail_sent_type) {
    // メール送信タイプ
    ALEipUtils.setTemp(
      rundata,
      context,
      WebMailConsts.MAIL_SENT_TYPE,
      mail_sent_type);
    // to
    ALEipUtils.setTemp(rundata, context, WebMailConsts.STR_TO, rundata
      .getParameters()
      .getString(WebMailConsts.STR_TO));
    // toGroupsendName(宛先グループ表示名)
    ALEipUtils.setTemp(
      rundata,
      context,
      WebMailConsts.STR_TO_GROUPSEND_NAME,
      rundata.getParameters().getString(WebMailConsts.STR_TO_GROUPSEND_NAME));
    // toGroupsend(宛先hiddenパラメータ)
    ALEipUtils.setTemp(
      rundata,
      context,
      WebMailConsts.STR_TO_GROUPSEND,
      rundata.getParameters().getString(WebMailConsts.STR_TO_GROUPSEND));
    // cc
    ALEipUtils.setTemp(rundata, context, WebMailConsts.STR_CC, rundata
      .getParameters()
      .getString(WebMailConsts.STR_CC));
    // ccGroupsendName(CCグループ表示名)
    ALEipUtils.setTemp(
      rundata,
      context,
      WebMailConsts.STR_CC_GROUPSEND_NAME,
      rundata.getParameters().getString(WebMailConsts.STR_CC_GROUPSEND_NAME));
    // ccGroupsend(CChiddenパラメータ)
    ALEipUtils.setTemp(
      rundata,
      context,
      WebMailConsts.STR_CC_GROUPSEND,
      rundata.getParameters().getString(WebMailConsts.STR_CC_GROUPSEND));
    // bcc
    ALEipUtils.setTemp(rundata, context, WebMailConsts.STR_BCC, rundata
      .getParameters()
      .getString(WebMailConsts.STR_BCC));
    // bccGroupsendName(BCCグループ表示名)
    ALEipUtils.setTemp(
      rundata,
      context,
      WebMailConsts.STR_BCC_GROUPSEND_NAME,
      rundata.getParameters().getString(WebMailConsts.STR_BCC_GROUPSEND_NAME));
    // bccGroupsend(BCChiddenパラメータ)
    ALEipUtils.setTemp(
      rundata,
      context,
      WebMailConsts.STR_BCC_GROUPSEND,
      rundata.getParameters().getString(WebMailConsts.STR_BCC_GROUPSEND));
    // 件名
    ALEipUtils.setTemp(rundata, context, WebMailConsts.STR_SUBJECT, rundata
      .getParameters()
      .getString(WebMailConsts.STR_SUBJECT));
    // メール本文
    ALEipUtils.setTemp(rundata, context, WebMailConsts.STR_BODY, rundata
      .getParameters()
      .getString(WebMailConsts.STR_BODY));
    // 開封要求
    ALEipUtils.setTemp(
      rundata,
      context,
      WebMailConsts.STR_HAS_DISPOSITION_NOTIFICATION,
      rundata.getParameters().getString(
        WebMailConsts.STR_HAS_DISPOSITION_NOTIFICATION));
  }

  /**
   * メールフォームのセッション格納データを破棄します。<BR>
   * 
   * @param rundata
   * @param context
   */
  private void removeTemp(RunData rundata, Context context) {
    // メール送信タイプ
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.MAIL_SENT_TYPE);
    // to
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.STR_TO);
    // toGroupsendName(宛先グループ表示名)
    ALEipUtils
      .removeTemp(rundata, context, WebMailConsts.STR_TO_GROUPSEND_NAME);
    // toGroupsend(宛先hiddenパラメータ)
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.STR_TO_GROUPSEND);
    // cc
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.STR_CC);
    // ccGroupsendName(CCグループ表示名)
    ALEipUtils
      .removeTemp(rundata, context, WebMailConsts.STR_CC_GROUPSEND_NAME);
    // ccGroupsend(CChiddenパラメータ)
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.STR_CC_GROUPSEND);
    // bcc
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.STR_BCC);
    // bccGroupsendName(BCCグループ表示名)
    ALEipUtils.removeTemp(
      rundata,
      context,
      WebMailConsts.STR_BCC_GROUPSEND_NAME);
    // bccGroupsend(BCChiddenパラメータ)
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.STR_BCC_GROUPSEND);
    // 件名
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.STR_SUBJECT);
    // メール本文
    ALEipUtils.removeTemp(rundata, context, WebMailConsts.STR_BODY);
    // 開封要求
    ALEipUtils.removeTemp(
      rundata,
      context,
      WebMailConsts.STR_HAS_DISPOSITION_NOTIFICATION);
  }

  // add end
  /**
   * 受信したメールを表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_show_received_mails(RunData rundata, Context context)
      throws Exception {
    // ACCOUNT_ID のセット
    setAccountIdToSession(rundata, context);
    // change start
    // PC版にて受信、送信の一覧取得処理を分けるよう改修されたため
    // 携帯版もPC版クラスを使用するため変更
    // ALEipUtils.setTemp(rundata, context, "tab", WebMailUtils.TAB_RECEIVE);
    // doWebmail_list(rundata, context);
    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
    WebMailSelectData listData = new WebMailSelectData();
    listData.initField();
    listData.loadMailAccountList(rundata, context);
    listData.setRowsNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.setStrLength(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p4a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "webmail-list");
    // change end
  }

  /**
   * 送信したメールを表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doWebmail_show_sent_mails(RunData rundata, Context context)
      throws Exception {
    // ACCOUNT_ID のセット
    setAccountIdToSession(rundata, context);
    // add start 2012.2.6 受入障害対応No.261 携帯側「下書きフォルダ」非表示対応
    // 携帯フラグを設定
    rundata.getParameters().setString("isMobile", "true");
    // add end
    // change start
    // PC版にて受信、送信の一覧取得処理を分けるよう改修されたため
    // 携帯版もPC版クラスを使用するため変更
    // ALEipUtils.setTemp(rundata, context, "tab", WebMailUtils.TAB_SENT);
    // doWebmail_list(rundata, context);
    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
    WebMailSendSelectData listData = new WebMailSendSelectData();
    listData.initField();
    listData.loadMailAccountList(rundata, context);
    listData.setRowsNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.setStrLength(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p4a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "webmail-list");
    // change end
  }

  /**
   * POP3 サーバからメールを受信し，受信トレイを表示する．
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doWebmail_receive_mails(RunData rundata, Context context)
      throws Exception {
    setAccountIdToSession(rundata, context);

    // super.doWebmail_receive_mails(rundata, context);

    // メールを受信する．
    // if (WebMailUtils.isNewMessage(rundata, context)) {
    // change start
    // WebMailUtils.receiveMailsThread(rundata, context);
    // 携帯はる受信スレッドの待ち合わせを行うように修正
    WebMailUtils.receiveMailsForMobile(rundata, context);
    // change end
    // }
    doWebmail_show_received_mails(rundata, context);
  }

  /**
   * リクエストに含まれる AccountID をセッションにセットする．
   * 
   * @param rundata
   * @param context
   */
  private void setAccountIdToSession(RunData rundata, Context context) {
    // ACCOUNT_ID の取得
    String accountId =
      rundata.getParameters().getString(WebMailUtils.ACCOUNT_ID);
    if (accountId != null) {
      // ACCOUNT_ID をセッションに登録する．
      ALEipUtils.setTemp(rundata, context, WebMailUtils.ACCOUNT_ID, accountId);
    }
  }

  /**
   * スケジュールのメニューを表示する．
   * 
   * @param rundata
   * @param context
   */
  public void doWebmail_menu(RunData rundata, Context context) throws Exception {
    // ACCOUNT_ID をセッションから削除する．
    ALEipUtils.removeTemp(rundata, context, WebMailUtils.ACCOUNT_ID);

    // // 新着メールの最終確認日をセッションに追加する．
    // if (confirmNewmail) {
    // String lastTime = WebMailUtils.getNowTime();
    // ALEipUtils.setTemp(rundata, context, LAST_TIME, lastTime);
    // }
    // context.put(LAST_TIME, ALEipUtils.getTemp(rundata, context, LAST_TIME));
    // remove start
    // int rowsNum =
    // Integer.parseInt(ALEipUtils
    // .getPortlet(rundata, context)
    // .getPortletConfig()
    // .getInitParameter("p1b-rows"));
    // remove end
    CellWebMailAccountSelectData listData = new CellWebMailAccountSelectData();
    listData.initField();
    // add start
    // フォルダ容量情報設定
    listData.loadMailBoxVolume(rundata, context);
    // add end
    // remove start
    // listData.setRowsNum(rowsNum);
    // remove end
    listData.doViewList(this, rundata, context);

    setTemplate(rundata, "webmail-menu");
  }

  // change start
  // /**
  // * メール一覧ページを表示させる.
  // *
  // * @param rundata
  // * @param context
  // */
  /**
   * 受信メール一覧ページング処理.
   * 
   * @param rundata
   * @param context
   */
  // change end
  public void doWebmail_pageview(RunData rundata, Context context)
      throws Exception {
    // 受信フォルダもしくは送信フォルダに保存されているメールの一覧を表示する．
    WebMailSelectData listData = new WebMailSelectData();
    listData.initField();
    listData.loadMailAccountList(rundata, context);

    // PSMLからパラメータをロードする
    // 最大表示件数（通常時）
    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
    listData.setRowsNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.setStrLength(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p4a-strlen")));

    listData.doViewList(this, rundata, context);

    setTemplate(rundata, "webmail-list");
  }

  // add start
  /**
   * 送信メール一覧ページング処理.
   * 
   * @param rundata
   * @param context
   */
  public void doWebmail_pageview_from_sent(RunData rundata, Context context)
      throws Exception {
    // 携帯フラグを設定
    rundata.getParameters().setString("isMobile", "true");
    // add end
    // 受信フォルダもしくは送信フォルダに保存されているメールの一覧を表示する．
    WebMailSendSelectData listData = new WebMailSendSelectData();
    listData.initField();
    listData.loadMailAccountList(rundata, context);

    // PSMLからパラメータをロードする
    // 最大表示件数（通常時）
    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context);
    listData.setRowsNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.setStrLength(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p4a-strlen")));

    listData.doViewList(this, rundata, context);

    setTemplate(rundata, "webmail-list");
  }

  // add end

  public void doWebmail_send_mail(RunData rundata, Context context)
      throws Exception {
    WebMailFormData formData = new WebMailFormData();
    // add start
    formData.setCellularSmartPhone(true);
    // add end
    formData.initField();
    // add start
    // 携帯向けエラーメッセージ切り替え用に携帯フラグを埋め込む
    rundata.getParameters().setString("send_from_mobile", "true");
    // add end
    if (formData.doInsert(this, rundata, context)) {
      // add start 2012.2.21 受入障害対応No.261 携帯側「下書きフォルダ」非表示対応
      // 携帯フラグを設定
      rundata.getParameters().setString("isMobile", "true");
      // add end

      // change start 2012.3.28
      // 受入障害No.347対応
      // doWebmail_list(rundata, context);
      doWebmail_menu(rundata, context);
      // change end 2012.3.28
    } else {
      setTemplate(rundata, "webmail-form");
    }
  }

}
