/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.io.InputStream;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.cayenne.om.portlet.AvzTMailSendRecvAcl;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * Webメールのファイルを処理するクラスです。 <br />
 */
public class WebMailFileScreen extends RawScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WebMailFileScreen.class.getName());

  /**
   * 
   * @param rundata
   * @return
   */
  @Override
  protected String getContentType(RunData rundata) {
    return "application/octet-stream";
  }

  /**
   * 
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata) throws Exception {
    ServletOutputStream out = null;

    try {
      String orgId = Database.getDomainName();
      int uid = ALEipUtils.getUserId(rundata);
      int accountid =
        Integer.parseInt(rundata.getParameters().getString(
          WebMailUtils.ACCOUNT_ID));
      int mailindex = rundata.getParameters().getInt(ALEipConstants.ENTITY_ID);
      int attachmentIndex = rundata.getParameters().getInt("attachmentIndex");
      if (attachmentIndex < 0) {
        return;
      }

      // add start
      EipMMailAccount account = ALMailUtils.getMailAccount(accountid);
      if (account.getUserId().intValue() != uid) {
        // 代理受信したメールの詳細の添付ファイルの場合

        // 代理受信アカウントの取得して権限チェックを行ないます
        List<AvzTMailSendRecvAcl> deputyList =
          ALMailUtils.getRepresentReceiveAccount(uid);
        // メールアカウント一覧に追加
        boolean found = false;
        for (AvzTMailSendRecvAcl deputyAccount : deputyList) {
          if (deputyAccount.getAccountId().intValue() == accountid) {
            found = true;
            break;
          }
        }
        if (!found) {
          throw new Exception(ALEipUtils.getUserFullName(uid)
            + "さんにより代理受信権限の与えられていないアカウントに対する操作が行なわれました。");
        }

        // ユーザーIDを代理受信設定元に差し替える。
        uid = account.getUserId().intValue();
      }

      // add end

      String currentTab = rundata.getParameters().getString("tab");
      int type_mail =
        (WebMailUtils.TAB_RECEIVE.equals(currentTab))
          ? ALFolder.TYPE_RECEIVE
          : ALFolder.TYPE_SEND;
      ALMailHandler handler =
        ALMailFactoryService.getInstance().getMailHandler();
      ALFolder folder = handler.getALFolder(type_mail, orgId, uid, accountid);
      // change start 2012.2.8 受入障害対応No.272
      // ALLocalMailMessage msg = (ALLocalMailMessage)
      // folder.getMail(mailindex);
      ALLocalMailMessage msg =
      // change start 2012.2.24 受入障害No.294
        // (ALLocalMailMessage) folder.getMail(mailindex, account
        // .getUserId()
        // .intValue() != uid);
        (ALLocalMailMessage) folder.getMail(mailindex, account
          .getUserId()
          .intValue() != uid, account.getAccountUsage());
      // change end 2012.2.24
      // change end

      // change start 2012.1.19 IBM拡張文字ファイル名が正しく表示できない不具合修正
      String fileName =
      // new String(
        // msg.getFileName(attachmentIndex).getBytes("Shift_JIS"),
        // "8859_1");
        new String(
          msg.getFileName(attachmentIndex).getBytes("Windows-31J"),
          "ISO-8859-1");
      // change end
      InputStream in = msg.getInputStream(attachmentIndex);
      HttpServletResponse response = rundata.getResponse();
      // change start 2012.1.19 IBM拡張文字ファイル名が正しく表示できない不具合修正
      response.setHeader("Content-Type", "charset=UTF-8");
      // change end
      // ファイル名の送信(attachment部分をinlineに変更すればインライン表示)
      response.setHeader("Content-disposition", "attachment; filename=\""
        + fileName
        + "\"");
      response.setHeader("Cache-Control", "aipo");
      response.setHeader("Pragma", "aipo");

      // ファイル内容の出力
      out = response.getOutputStream();
      byte[] b = new byte[1024];
      int len = -1;
      while ((len = in.read(b)) != -1) {
        out.write(b, 0, len);
        out.flush();
      }
      in.close();
      out.flush();
      out.close();
    } catch (Exception e) {
      // change start
      // logger.error("[ERROR]", e);
      logger.error("[WebMailFileScreen] Exception.", e);
      ALEipUtils.redirectDBError(rundata);
      // change end
      // add start
    } catch (Throwable t) {
      logger.error("[WebMailFileScreen] Exception.", t);
      ALEipUtils.redirectDBError(rundata);
      // add end
    }

  }
}
