/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.cayenne.om.portlet.AvzTMailSend;
import com.aimluck.eip.cayenne.om.portlet.AvzTMailSendRecvAcl;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailConsts;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * Webメールのメールファイルを処理するクラスです。 <br />
 */
public class WebMailMailFileScreen extends RawScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WebMailMailFileScreen.class.getName());

  /**
   * 
   * @param rundata
   * @return
   */
  @Override
  protected String getContentType(RunData rundata) {
    return "application/octet-stream";
  }

  /**
   * 
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata) throws Exception {
    ServletOutputStream out = null;

    try {
      String orgId = Database.getDomainName();
      int uid = ALEipUtils.getUserId(rundata);
      int accountid = Integer.parseInt(rundata.getParameters().getString(WebMailUtils.ACCOUNT_ID));
      int mailindex = rundata.getParameters().getInt(ALEipConstants.ENTITY_ID);

      EipMMailAccount account = ALMailUtils.getMailAccount(accountid);
      if (account.getUserId().intValue() != uid) {
        // 代理受信したメールの場合
        // 代理受信アカウントの取得して権限チェックを行ないます
        List<AvzTMailSendRecvAcl> deputyList = ALMailUtils.getRepresentReceiveAccount(uid);
        // メールアカウント一覧に追加
        boolean found = false;
        for (AvzTMailSendRecvAcl deputyAccount : deputyList) {
          if (deputyAccount.getAccountId().intValue() == accountid) {
            found = true;
            break;
          }
        }
        if (!found) {
          throw new Exception(ALEipUtils.getUserFullName(uid) + "さんにより代理受信権限の与えられていないアカウントに対する操作が行なわれました。");
        }

        // ユーザーIDを代理受信設定元に差し替える。
        uid = account.getUserId().intValue();
      }

      String currentTab = rundata.getParameters().getString("tab");
      int type_mail = (WebMailUtils.TAB_RECEIVE.equals(currentTab)) ? ALFolder.TYPE_RECEIVE : ALFolder.TYPE_SEND;
      ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
      ALFolder folder = handler.getALFolder(type_mail, orgId, uid, accountid);

      // メールオブジェクトを取得する。
      ALLocalMailMessage msg = (ALLocalMailMessage) folder.getMail(mailindex, account.getUserId().intValue() != uid, account.getAccountUsage());

      // メールファイルを取得する。
      File file = getMailFile(mailindex, uid, accountid, type_mail);
      // ファイル存在チェック
      if (!file.exists()) {
        throw new Exception("対象のメールファイルがありません。[ユーザーID]=" + uid + "[アカウントID]=" + accountid + "[メール種別]=" + type_mail + "[メールファイル名]=" + msg.getFileName());
      }

      // 件名のデコード
      String subject = ALMailUtils.decodeSubject(msg.getHeader("Subject", null));
      // <メール件名>にある次の文字「\t、:、"、|、/、*、<、>、?、\」は、ファイル名の禁則文字のため除去する。
      String fileName = subject.replaceAll("[\t:\"|/*<>?\\\\]", "");
      // ファイル名の長さをLinuxの上限内にするため、先頭から60文字でカットする。
      if (fileName.length() > 60) {
        fileName = fileName.substring(0, 60);
      }
      // 件名が空の場合は"無題"とする。
      if (fileName.equals("")) {
        fileName = "無題";
      }

      // 拡張子は、".eml"とする。
      fileName += ".eml";

      InputStream in = new FileInputStream(file);
      HttpServletResponse response = rundata.getResponse();
      response.setHeader("Content-Type", "charset=UTF-8");
      // ファイル名はURLエンコードする。（エンコードすると半角スペースが+に置き変わってしまうため、%20に置換する）
      response.setHeader("Content-disposition", "attachment; filename=\"" + URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20") + "\"");
      response.setHeader("Cache-Control", "aipo");
      response.setHeader("Pragma", "aipo");

      // ファイル内容の出力
      out = response.getOutputStream();
      byte[] b = new byte[1024];
      int len = -1;
      while ((len = in.read(b)) != -1) {
        out.write(b, 0, len);
        out.flush();
      }
      in.close();
      out.flush();
      out.close();
    } catch (Exception e) {
      logger.error("メールファイルのダウンロードに失敗しました。", e);
      ALEipUtils.redirectDBError(rundata);
    } catch (Throwable t) {
      logger.error("メールファイルのダウンロードに失敗しました。", t);
      ALEipUtils.redirectDBError(rundata);
    }

  }

  /**
   * メールファイルオブジェクトを取得します。<BR>
   * 
   * @param mailId
   *          ユーザーID
   * @param userId
   *          ユーザーID
   * @param accountId
   *          アカウントID
   * @param type
   *          メール種別
   * @return メールファイル
   * @throws Exception
   */
  private static File getMailFile(int mailId, int userId, int accountId, int type) throws Exception {

    String fileName = "";
    try {

      // メール種別よりディレクトリ名を判別
      String dirName = null;

      if (type == ALFolder.TYPE_RECEIVE) {
        // 受信の場合
        dirName = WebMailConsts.STR_RECEIVE_FOLDER_NAME;
        EipTMail email = Database.get(EipTMail.class, mailId);
        fileName = email.getFilePath();
      } else {
        // 送信の場合
        dirName = WebMailConsts.STR_SEND_FOLDER_NAME;
        AvzTMailSend email = Database.get(AvzTMailSend.class, mailId);
        fileName = email.getFilePath();
      }
      // 対象となるメールファイルを取得
      File src_file = new File(WebMailUtils.createMailFilePath(userId, accountId, dirName, fileName));
      return src_file;

    } catch (Exception e) {
      throw e;
    }

  }
}
