/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTMailBatch;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailConsts;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * 退避ファイルダウンロードを行うクラスです
 */
public class WebMailPackageProcessDownLoadScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService
      .getLogger(WebMailPackageProcessDownLoadScreen.class.getName());

  /** ログインユーザーのID * */
  private int user_id;

  /** ログインユーザー名 * */
  private String login_user_name;

  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    // ログインユーザーID取得
    user_id = ALEipUtils.getUserId(rundata);
    // ログインユーザー名取得
    login_user_name = ALEipUtils.getUserFullName(user_id);

    AvzTMailBatch mailBatch = WebMailUtils.getAvzTMailBatchResultList(user_id);
    try {

      // ダウンロードファイル名
      String download_file_name = mailBatch.getFileName();

      // ダウンロードディレクトリパス
      String downloadDirectory = WebMailUtils.getDownloadFileDir(user_id);

      // ファイルダウンロード処理
      WebMailUtils.downloadFile(rundata, downloadDirectory, download_file_name,
      // ダウンロードに戻るボタン追加のため、ダウンロード後の削除方式廃止
        // 受入障害対応No.157
        // change start
        // true);
        false);
      // change end

      // Webメール一括処理 ダウンロード済に更新
      WebMailUtils
        .updateMailBatchData(mailBatch, WebMailConsts.FINISH_DOWNLOAD);
      Database.commit();

    } catch (Exception ex) {
      Database.rollback();
      logger.error("退避ファイルダウンロードに失敗しました" + login_user_name, ex);
      return;
    }
  }

}
