/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.webmail;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.AvzMGroupsend;
import com.aimluck.eip.cayenne.om.portlet.AvzTMailSendRecvAcl;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipGroupSend;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogConstants;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * Webメールアカウントのフォームデータを管理するためのクラスです。 <br />
 */
public class WebMailAccountFormData extends ALAbstractFormData {

  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WebMailAccountFormData.class.getName());

  // remove by motegi start
  private final int DEF_SMTP_PORT = 25;

  private final int DEF_POP3_PORT = 110;

  // /** The value for the accountId field */
  // private ALNumberField account_id;
  //
  // /** The value for the userId field */
  // private ALNumberField user_id;
  //
  // /** The value for the accountName field */
  // private ALStringField account_name;
  //
  // /** The value for the accountType field */
  // private ALStringField account_type;
  //
  /** The value for the pop3serverName field */
  private ALStringField smtpserver_name;

  /** The value for the pop3serverName field */
  private ALStringField pop3server_name;

  /** The value for the pop3userName field */
  private ALStringField pop3user_name;

  /** The value for the pop3password field */
  private ALStringField pop3_password;

  // /** The value for the mailUserName field */
  // private ALStringField mail_user_name;

  /** The value for the mailAddress field */
  private ALStringField mail_address;

  /** The value for the smtpPort field */
  private ALNumberField smtp_port;

  /** The value for the pop3Port field */
  private ALNumberField pop3_port;

  // /** <code>auth_send_flag</code> 送信時の認証方式 */
  // private ALNumberField auth_send_flg;
  //
  // /** <code>auth_send_user_id</code> SMTP 認証時のユーザ ID */
  // private ALStringField auth_send_user_id;
  //
  // /** <code>auth_send_user_password</code> SMTP 認証時のユーザパスワード */
  // private ALStringField auth_send_user_password;
  //
  // /** <code>auth_receive_flag</code> 受信時の認証方式 */
  // private ALNumberField auth_receive_flag;
  //
  /** The value for the delAtPop3Flg field */
  private ALNumberField del_at_pop3_flg;

  // /** <code>del_at_pop3_before_days_flg</code> 指定日数の経過後に POP3 サーバからメールを削除する
  // */
  // private ALNumberField del_at_pop3_before_days_flg;
  //
  // /** <code>del_at_pop3_before_days</code> POP3 サーバからメールを削除する経過日数 */
  // private ALNumberField del_at_pop3_before_days;
  //
  /** The value for the nonReceivedFlg field */
  private ALNumberField non_received_flg;

  // /** The value for the createDate field */
  // private ALDateTimeField create_date;
  //
  // remove end

  /** The value for the updateDate field */
  private ALDateTimeField update_date;

  /** The value for the signature field */
  private ALStringField signature;

  // remove by motegi start
  // /** The value for the smtpEncryptionFlag field */
  // private ALNumberField smtp_encryption_flag;
  //
  // /** The value for the pop3EncryptionFlag field */
  // private ALNumberField pop3_encryption_flag;
  // remove end

  // remove by motegi start
  // private String orgId;
  // remove end

  // remove by motegi start
  // private boolean isAdmin;
  // remove end

  /** 代理送信設定メンバーリスト add by motegi */
  private List<ALEipUser> sendMemberList;

  /** 代理受信設定メンバーリスト add by motegi */
  private List<ALEipUser> receiveMemberList;

  /** 代理送信設定グループ送信リスト add by motegi */
  private List<ALEipGroupSend> groupSendList;

  /** <code>loginuserid</code> ログインユーザーID add by motegi */
  private int loginuserid;

  /** 代理送受信制御 権限種類 受信 */
  public static final String WEBMAILACL_ACL_TYPE_R = "R";

  /** 代理送受信制御 権限種類 送信 */
  public static final String WEBMAILACL_ACL_TYPE_S = "S";

  /** スケジュール制御 適用タイプ グループ送信 */
  public static final String WEBMAILACL_TARGET_TYPE_G = "G";

  /** スケジュール制御 適用タイプ ユーザー */
  public static final String WEBMAILACL_TARGET_TYPE_U = "U";

  // add start 2012.2.24 受入障害No.294
  /** The value for the accountUsage field */
  private ALStringField account_usage;

  // add end 2012.2.24
  /**
   * 初期処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @see com.aimluck.eip.common.ALAbstractFormData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);

    // remove by motegi start
    // orgId = Database.getDomainName();
    // isAdmin =
    // rundata.getScreen().equals(WebMailAdminFormScreen.class.getSimpleName())
    // || rundata.getScreen().equals(
    // WebMailAdminFormJSONScreen.class.getSimpleName());
    // remove end

    // add start
    loginuserid = ALEipUtils.getUserId(rundata);

    // add end

  }

  /**
   * 各フィールドを初期化します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  @Override
  public void initField() {
    // remove by motegi start
    // account_id = new ALNumberField();
    // account_id.setFieldName("アカウントID");
    //
    // user_id = new ALNumberField();
    // user_id.setFieldName("ユーザID");
    //
    // account_name = new ALStringField();
    // account_name.setFieldName("メールアカウント名");
    // account_name.setTrim(true);
    //
    // account_type = new ALStringField();
    // account_type.setFieldName("アカウント種別");
    // account_type.setTrim(true);
    //
    smtpserver_name = new ALStringField();
    smtpserver_name.setFieldName("送信メールサーバ名（SMTP）");
    smtpserver_name.setTrim(true);

    pop3server_name = new ALStringField();
    pop3server_name.setFieldName("受信メールサーバ名（POP3）");
    pop3server_name.setTrim(true);

    pop3user_name = new ALStringField();
    pop3user_name.setFieldName("受信用ユーザーID");
    pop3user_name.setTrim(true);

    pop3_password = new ALStringField();
    pop3_password.setFieldName("受信用ユーザーパスワード");
    pop3_password.setTrim(true);

    // mail_user_name = new ALStringField();
    // mail_user_name.setFieldName("名前");
    // mail_user_name.setTrim(true);

    mail_address = new ALStringField();
    mail_address.setFieldName("メールアドレス");
    mail_address.setTrim(true);

    smtp_port = new ALNumberField();
    smtp_port.setFieldName("送信ポート番号（SMTP）");
    smtp_port.setValue(DEF_SMTP_PORT);

    pop3_port = new ALNumberField();
    pop3_port.setFieldName("受信ポート番号（POP3）");
    pop3_port.setValue(DEF_POP3_PORT);

    // auth_send_flg = new ALNumberField();
    // auth_send_flg.setFieldName("送信時の認証方式");
    // auth_send_flg.setValue(ALSmtpMailSender.AUTH_SEND_NONE);
    //
    // smtp_encryption_flag = new ALNumberField();
    // smtp_encryption_flag.setFieldName("送信時の暗号化方式");
    // smtp_encryption_flag.setValue(0);
    //
    // auth_send_user_id = new ALStringField();
    // auth_send_user_id.setFieldName("SMTP認証用ユーザーID");
    // auth_send_user_id.setTrim(true);
    //
    // auth_send_user_password = new ALStringField();
    // auth_send_user_password.setFieldName("SMTP認証用パスワード");
    // auth_send_user_password.setTrim(true);
    //
    // auth_receive_flag = new ALNumberField();
    // auth_receive_flag.setFieldName("受信時の認証方式");
    // auth_receive_flag.setValue(ALPop3MailReceiver.AUTH_RECEIVE_NORMAL);
    //
    // pop3_encryption_flag = new ALNumberField();
    // pop3_encryption_flag.setFieldName("受信時の暗号化方式");
    // pop3_encryption_flag.setValue(0);
    //
    del_at_pop3_flg = new ALNumberField();
    del_at_pop3_flg.setFieldName("受信後、サーバからメールを削除する");
    del_at_pop3_flg.setValue(0);

    // del_at_pop3_before_days_flg = new ALNumberField();
    // del_at_pop3_before_days_flg.setFieldName("メール削除日数指定フラグ");
    // del_at_pop3_before_days_flg.setValue(0);
    //
    // del_at_pop3_before_days = new ALNumberField();
    // del_at_pop3_before_days.setFieldName("メール削除日数");
    // del_at_pop3_before_days.setValue(0);
    //
    non_received_flg = new ALNumberField();
    non_received_flg.setFieldName("受信済みメッセージは取り込まない");
    non_received_flg.setValue(1);

    // create_date = new ALDateTimeField(WebMailUtils.CREATED_DATE_FORMAT);
    // create_date.setFieldName("メールアカウント作成日");
    //
    // remove end
    update_date = new ALDateTimeField(WebMailUtils.DATE_TIME_FORMAT);
    update_date.setFieldName("メールアカウント最終更新日");

    signature = new ALStringField();
    signature.setFieldName("署名");
    signature.setTrim(true);

    // add by motegi
    // 代理送信設定メンバーリスト
    sendMemberList = new ArrayList<ALEipUser>();

    // 代理受信設定メンバーリスト
    receiveMemberList = new ArrayList<ALEipUser>();

    // 代理送信設定グループ送信
    groupSendList = new ArrayList<ALEipGroupSend>();
    // add end

    // add start 2012.2.24 受入障害No.294
    account_usage = new ALStringField();
    account_usage.setFieldName("アカウント用途選択");
    account_usage.setTrim(true);
    // add end
  }

  /**
   * バリデーション初期化
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  @Override
  protected void setValidator() {
    // remove start
    // // アカウント名
    // account_name.setNotNull(true);
    // account_name.limitMaxLength(20);

    // SMTPサーバ名
    smtpserver_name.setNotNull(true);
    smtpserver_name.setCharacterType(ALStringField.TYPE_ASCII);
    smtpserver_name.limitMaxLength(50);

    // POP3サーバ名
    pop3server_name.setNotNull(true);
    pop3server_name.setCharacterType(ALStringField.TYPE_ASCII);
    pop3server_name.limitMaxLength(50);

    // POP3用ユーザID
    pop3user_name.setNotNull(true);
    pop3user_name.setCharacterType(ALStringField.TYPE_ASCII);
    pop3user_name.limitMaxLength(50);

    // POP3用ユーザパスワード
    pop3_password.setNotNull(true);
    pop3_password.setCharacterType(ALStringField.TYPE_ASCII);
    pop3_password.limitMaxLength(50);

    // // メールユーザ名
    // mail_user_name.setNotNull(true);
    // mail_user_name.limitMaxLength(50);
    //
    // // メールアドレス
    // mail_address.setNotNull(true);
    // mail_address.setCharacterType(ALStringField.TYPE_ASCII);
    // mail_address.limitMaxLength(50);
    //
    // SMTPポート番号
    smtp_port.setNotNull(true);
    smtp_port.limitMinValue(0);
    smtp_port.limitMaxValue(65535);

    // POP3ポート番号
    pop3_port.setNotNull(true);
    pop3_port.limitMinValue(0);
    pop3_port.limitMaxValue(65535);

    // // 送信時の認証方式
    // auth_send_flg.setNotNull(true);
    // auth_send_flg.limitMinValue(ALSmtpMailSender.AUTH_SEND_NONE);
    // auth_send_flg.limitMaxValue(ALSmtpMailSender.AUTH_SEND_SMTP_AUTH);
    //
    // // 送信時の暗号化
    // smtp_encryption_flag.setNotNull(true);
    // smtp_encryption_flag.limitMaxValue(ALSmtpMailSender.ENCRYPTION_SEND_SSL);
    // smtp_encryption_flag.limitMinValue(ALSmtpMailSender.ENCRYPTION_SEND_NONE);
    //
    // // SMTP 認証時のユーザ ID
    // auth_send_user_id.setNotNull(true);
    // auth_send_user_id.setCharacterType(ALStringField.TYPE_ASCII);
    // auth_send_user_id.limitMaxLength(50);
    //
    // // SMTP 認証時のユーザパスワード
    // auth_send_user_password.setNotNull(true);
    // auth_send_user_password.setCharacterType(ALStringField.TYPE_ASCII);
    // auth_send_user_password.limitMaxLength(50);
    //
    // // 受信時の認証方式
    // auth_receive_flag.setNotNull(true);
    // auth_receive_flag.limitMinValue(ALPop3MailReceiver.AUTH_RECEIVE_NORMAL);
    // auth_receive_flag.limitMaxValue(ALPop3MailReceiver.AUTH_RECEIVE_APOP);
    //
    // // 受信時の暗号化
    // pop3_encryption_flag.setNotNull(true);
    // pop3_encryption_flag.limitMinValue(ALPop3MailReceiver.ENCRYPTION_SEND_NONE);
    // pop3_encryption_flag.limitMaxValue(ALPop3MailReceiver.ENCRYPTION_SEND_SSL);
    //
    // 受信後、サーバからメールを削除する
    del_at_pop3_flg.setNotNull(true);
    del_at_pop3_flg.limitMinValue(0);
    del_at_pop3_flg.limitMaxValue(1);

    // // 指定日数の経過後に POP3 サーバからメールを削除する
    // del_at_pop3_before_days_flg.setNotNull(true);
    // del_at_pop3_before_days_flg.limitMinValue(0);
    // del_at_pop3_before_days_flg.limitMaxValue(1);
    //
    // // POP3 サーバからメールを削除する経過日数
    // del_at_pop3_before_days.setNotNull(true);
    // del_at_pop3_before_days.limitMinValue(0);
    // del_at_pop3_before_days.limitMaxValue(100);
    //
    // 受信済みメッセージは取り込まない
    non_received_flg.setNotNull(true);
    non_received_flg.limitMinValue(0);
    non_received_flg.limitMaxValue(1);
    // remove end

    // 署名の最大文字数
    signature.limitMaxLength(1000);
  }

  /**
   * バリデーション
   * 
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  @Override
  protected boolean validate(List<String> msgList) {
    // remove start
    // // アカウント名
    // account_name.validate(msgList);
    // // SMTPサーバ名
    // smtpserver_name.validate(msgList);
    //
    // if (!isAdmin
    // || (isAdmin && auth_send_flg.getValue() ==
    // ALSmtpMailSender.AUTH_SEND_POP_BEFORE_SMTP)) {
    // POP3サーバ名
    pop3server_name.validate(msgList);
    // POP3用ユーザID
    pop3user_name.validate(msgList);
    // POP3用ユーザパスワード
    pop3_password.validate(msgList);
    // POP3ポート番号
    pop3_port.validate(msgList);
    // // 受信時の暗号化
    // pop3_encryption_flag.validate(msgList);
    // // 受信時の認証方式
    // auth_receive_flag.validate(msgList);
    // }
    // // メールユーザ名
    // mail_user_name.validate(msgList);
    // // メールアドレス
    // if (mail_address.validate(msgList)
    // && !ALStringUtil.isMailAddress(mail_address.getValue())) {
    // msgList.add("『 <span class='em'>メールアドレス</span> 』を正しく入力してください。");
    // }
    //
    // SMTPポート番号
    smtp_port.validate(msgList);

    // // 送信時の認証方式
    // auth_send_flg.validate(msgList);
    //
    // if (auth_send_flg.getValue() == ALSmtpMailSender.AUTH_SEND_SMTP_AUTH) {
    // // SMTP 認証時のユーザ ID
    // auth_send_user_id.validate(msgList);
    //
    // // SMTP 認証時のユーザパスワード
    // auth_send_user_password.validate(msgList);
    // }
    //
    // // 送信時の暗号化
    // smtp_encryption_flag.validate(msgList);
    //
    // 受信後、サーバからメールを削除する
    del_at_pop3_flg.validate(msgList);

    // if (del_at_pop3_flg.getValue() == 0) {
    // // 指定日数の経過後に POP3 サーバからメールを削除する
    // del_at_pop3_before_days_flg.validate(msgList);
    //
    // if (del_at_pop3_before_days_flg.getValue() == 1) {
    // // POP3 サーバからメールを削除する経過日数
    // del_at_pop3_before_days.validate(msgList);
    // }
    // }
    //
    // 受信済みメッセージは取り込まない
    non_received_flg.validate(msgList);
    // remove end

    // 署名
    signature.validate(msgList);

    return (msgList.size() == 0);
  }

  /**
   * メールアカウント情報編集画面表示処理
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * 
   * @throws ALDBErrorException
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
    try {
      // 全体で使うメールアカウントのオーナーは常にuid=1
      // change start
      // int userId = isAdmin ? 1 : ALEipUtils.getUserId(rundata);
      int userId = ALEipUtils.getUserId(rundata);
      // change end

      // change start
      // int accountId =
      // Integer.parseInt(ALEipUtils.getTemp(
      // rundata,
      // context,
      // ALEipConstants.ENTITY_ID));
      int accountId = rundata.getParameters().getInt(ALEipConstants.ENTITY_ID);
      // change end

      // オブジェクトモデルを取得
      EipMMailAccount account = ALMailUtils.getMailAccount(userId, accountId);
      if (account == null) {
        // change start
        // return false;
        throw new Exception("指定されたメールアカウントがデータベースにありません。");
        // change end
      }

      // remove start
      // account_id.setValue(account.getAccountId().intValue());
      // account_name.setValue(account.getAccountName());
      // account_type.setValue(account.getAccountType());
      smtpserver_name.setValue(account.getSmtpserverName());
      pop3server_name.setValue(account.getPop3serverName());
      pop3user_name.setValue(account.getPop3userName());
      pop3_password.setValue(new String(ALMailUtils.getDecryptedMailAccountPasswd(account.getPop3password())));
      // mail_user_name.setValue(account.getMailUserName());
      mail_address.setValue(account.getMailAddress());
      smtp_port.setValue(account.getSmtpPort());
      pop3_port.setValue(account.getPop3Port());
      // auth_send_flg.setValue(account.getAuthSendFlg());
      // smtp_encryption_flag.setValue(account.getSmtpEncryptionFlg());
      // pop3_encryption_flag.setValue(account.getPop3EncryptionFlg());
      // auth_send_user_id.setValue(account.getAuthSendUserId());
      // remove end
      signature.setValue(account.getSignature());

      // remove start
      // byte[] tmpAuthSendUserPasswd = account.getAuthSendUserPasswd();
      // if (tmpAuthSendUserPasswd != null && tmpAuthSendUserPasswd.length > 0)
      // {
      // auth_send_user_password.setValue(new String(ALMailUtils
      // .getDecryptedMailAccountPasswd(tmpAuthSendUserPasswd)));
      // }
      //
      // auth_receive_flag.setValue(account.getAuthReceiveFlg().longValue());
      del_at_pop3_flg.setValue(account.getDelAtPop3Flg());
      // del_at_pop3_before_days_flg.setValue(account.getDelAtPop3BeforeDaysFlg());
      // del_at_pop3_before_days.setValue(account
      // .getDelAtPop3BeforeDays()
      // .longValue());
      non_received_flg.setValue(account.getNonReceivedFlg());
      // create_date.setValue(account.getCreateDate());
      // remove end
      update_date.setValue(account.getUpdateDate());

      // add start 2012.2.24 受入障害No.294
      account_usage.setValue(account.getAccountUsage());
      // add end

      // add by motegi
      final String groupSendSql =
        "SELECT DISTINCT "
          + "  B.GROUPSEND_ID, B.GROUPSEND_NAME, C.POSITION "
          + " FROM avz_t_mail_send_recv_acl as A "
          + " INNER JOIN avz_m_groupsend as B "
          + "  on A.TARGET_ID = B.GROUPSEND_ID "
          + " INNER JOIN avz_m_groupsend_position as C "
          + " on B.GROUPSEND_ID = C.GROUPSEND_ID "
          + " WHERE A.ACCOUNT_ID = #bind($accountId 'INTEGER') "
          + "   AND A.TARGET_TYPE = 'G' "
          + "   AND A.ACL_TYPE = 'S' "
          + " ORDER BY C.POSITION ";

      SQLTemplate<AvzMGroupsend> query = new SQLTemplate<AvzMGroupsend>(AvzMGroupsend.class, groupSendSql);

      List<AvzMGroupsend> groupSendEntityList = query.param("accountId", accountId).fetchList();
      if (groupSendEntityList != null && groupSendEntityList.size() > 0) {
        for (AvzMGroupsend e : groupSendEntityList) {
          ALEipGroupSend gs = new ALEipGroupSend();
          gs.initField();
          gs.setGroupSendId(e.getGroupsendId());
          gs.setGroupSendName(e.getGroupsendName());
          groupSendList.add(gs);
        }
      }

      // 代理受信設定メンバー
      final String memberSql =
        "SELECT DISTINCT "
          + "  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, B.DISPLAY_NAME, C.POSITION "
          + " FROM avz_t_mail_send_recv_acl as A "
          + " INNER JOIN turbine_user as B "
          + "  on A.TARGET_ID = B.USER_ID "
          + " INNER JOIN eip_m_user_position as C "
          + " on B.USER_ID = C.USER_ID "
          + " WHERE A.ACCOUNT_ID = #bind($accountId 'INTEGER') "
          + "   AND A.TARGET_TYPE = #bind($targetType 'VARCHAR') "
          + "   AND A.ACL_TYPE = #bind($aclType 'VARCHAR') "
          + " ORDER BY B.DISPLAY_NAME, C.POSITION ";

      SQLTemplate<TurbineUser> publicMemberQuery = new SQLTemplate<TurbineUser>(TurbineUser.class, memberSql);

      List<TurbineUser> turbineUserList =
        publicMemberQuery.param("accountId", accountId).param("targetType", WEBMAILACL_TARGET_TYPE_U).param("aclType", WEBMAILACL_ACL_TYPE_R).fetchList();
      if (turbineUserList != null && turbineUserList.size() > 0) {
        for (TurbineUser e : turbineUserList) {
          ALEipUser u = new ALEipUser();
          u.initField();
          u.setUserId(e.getUserId());
          u.setName(e.getLoginName());
          u.setAliasName(e.getFirstName(), e.getLastName());
          receiveMemberList.add(u);
        }
      }

      // 代理送信設定メンバー
      SQLTemplate<TurbineUser> sendMemberQuery = new SQLTemplate<TurbineUser>(TurbineUser.class, memberSql);

      List<TurbineUser> turbineSecretaryUserList =
        sendMemberQuery.param("accountId", accountId).param("targetType", WEBMAILACL_TARGET_TYPE_U).param("aclType", WEBMAILACL_ACL_TYPE_S).fetchList();
      if (turbineSecretaryUserList != null && turbineSecretaryUserList.size() > 0) {
        for (TurbineUser e : turbineSecretaryUserList) {
          ALEipUser u = new ALEipUser();
          u.initField();
          u.setUserId(e.getUserId());
          u.setName(e.getLoginName());
          u.setAliasName(e.getFirstName(), e.getLastName());
          sendMemberList.add(u);
        }
      }
      // add end
    } catch (Exception ex) {
      // change start
      // logger.error("Exception", ex);
      // return false;
      String msg = "署名・代理人設定画面の表示に失敗しました。";
      logger.error(msg, ex);
      throw new ALDBErrorException();
      // change end
    }
    return true;
  }

  /**
   * ※未使用
   */
  @Override
  protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {

    // change by motegi start
    // // 全体で使うメールアカウントのオーナーは常にuid=1
    // int uid = isAdmin ? 1 : ALEipUtils.getUserId(rundata);
    // return ALMailUtils.insertMailAccountData(
    // rundata,
    // msgList,
    // uid,
    // getAccountName().getValue(),
    // ALMailUtils.ACCOUNT_TYPE_NON,
    // getMailAddress().getValue(),
    // getMailUserName().getValue(),
    // getSmtpserverName().getValue(),
    // (int) getSmtpPort().getValue(),
    // getPop3serverName().getValue(),
    // (int) getPop3Port().getValue(),
    // getPop3userName().getValue(),
    // getPop3Password().getValue(),
    // (int) getAuthSendFlg().getValue(),
    // getAuthSendUserId().getValue(),
    // this.getAuthSendUserPasswd().getValue(),
    // (int) getAuthReceiveFlg().getValue(),
    // (int) getDelAtPop3Flg().getValue(),
    // (int) getDelAtPop3BeforeDaysFlg().getValue(),
    // (int) getDelAtPop3BeforeDays().getValue(),
    // getNonReceivedFlg().toString(),
    // getSignature().toString(),
    // (int) getSmtpEncryptionFlag().getValue(),
    // (int) getPop3EncryptionFlag().getValue());
    return true;
    // change end
  }

  /**
   * 代理受信と代理送信設定先を上書き登録する。 <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  @Override
  protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {

    try {
      // add by motegi
      Date now = Calendar.getInstance().getTime();
      // add end

      // 全体で使うメールアカウントのオーナーは常にuid=1

      // change start
      // int userId = isAdmin ? 1 : ALEipUtils.getUserId(rundata);
      int userId = ALEipUtils.getUserId(rundata);
      // change end

      // change start
      // int accountId =
      // Integer.parseInt(ALEipUtils.getTemp(
      // rundata,
      // context,
      // ALEipConstants.ENTITY_ID));
      // アカウントIDをセッションより取得
      int accountId = Integer.parseInt(ALEipUtils.getTemp(rundata, context, WebMailUtils.ACCOUNT_ID));

      // change end

      // オブジェクトモデルを取得
      EipMMailAccount mailAccount = ALMailUtils.getMailAccount(userId, accountId);
      if (mailAccount == null) {
        throw new Exception("指定されたメールアカウントがデータベースにありません。");
      }

      // remove start
      // mailAccount.setUserId(Integer.valueOf(userId));
      // mailAccount.setAccountName(getAccountName().getValue());
      // // mailAccount.setAccountType(getAccountType().getValue());
      mailAccount.setSmtpserverName(getSmtpserverName().getValue());
      mailAccount.setPop3serverName(getPop3serverName().getValue());
      mailAccount.setPop3userName(getPop3userName().getValue());
      mailAccount.setPop3password(ALMailUtils.getEncryptedMailAccountPasswd(getPop3Password().getValue().getBytes()));
      // mailAccount.setMailUserName(getMailUserName().getValue());
      mailAccount.setMailAddress(getMailAddress().getValue());
      mailAccount.setSmtpPort(Integer.toString((int) getSmtpPort().getValue()));
      mailAccount.setPop3Port(Integer.toString((int) getPop3Port().getValue()));
      // mailAccount.setAuthSendFlg(Short.valueOf(getAuthSendFlg().toString()));
      // mailAccount.setSmtpEncryptionFlg((short) getSmtpEncryptionFlag()
      // .getValue());
      // mailAccount.setPop3EncryptionFlg((short) getPop3EncryptionFlag()
      // .getValue());
      // if (getAuthSendFlg().getValue() ==
      // ALSmtpMailSender.AUTH_SEND_SMTP_AUTH) {
      // mailAccount.setAuthSendUserId(getAuthSendUserId().getValue());
      // mailAccount.setAuthSendUserPasswd(ALMailUtils
      // .getEncryptedMailAccountPasswd(getAuthSendUserPasswd()
      // .getValue()
      // .getBytes()));
      // }
      // mailAccount.setAuthReceiveFlg(Short.valueOf((short) getAuthReceiveFlg()
      // .getValue()));
      mailAccount.setDelAtPop3Flg(getDelAtPop3Flg().getValueAsString());
      // if (getDelAtPop3Flg().getValue() == 0) {
      // mailAccount.setDelAtPop3BeforeDaysFlg(getDelAtPop3BeforeDaysFlg()
      // .getValueAsString());
      // if (getDelAtPop3BeforeDaysFlg().getValue() == 1) {
      // mailAccount.setDelAtPop3BeforeDays(Integer
      // .valueOf((int) getDelAtPop3BeforeDays().getValue()));
      // }
      // }
      mailAccount.setNonReceivedFlg(getNonReceivedFlg().toString());
      // mailAccount.setUpdateDate(Calendar.getInstance().getTime());
      // remove end

      mailAccount.setUpdateDate(now);
      mailAccount.setSignature(getSignature().getValue());
      // add start 2012.2.24 受入障害対応No.294
      mailAccount.setAccountUsage(getAccountUsage().getValue());
      // add end 2012.2.24
      // スケジュール制御を一旦削除する。
      String deleteAvzTMailSendRecvAclSql = "DELETE FROM AVZ_T_MAIL_SEND_RECV_ACL WHERE ACCOUNT_ID = #bind($accountId 'INTEGER')";
      Database.sql(AvzTMailSendRecvAcl.class, deleteAvzTMailSendRecvAclSql).param("accountId", accountId).execute();

      // 代理送信設定グループを設定する。
      for (ALEipGroupSend gs : groupSendList) {
        AvzTMailSendRecvAcl acl = Database.create(AvzTMailSendRecvAcl.class);
        acl.setAccountId(accountId);
        acl.setAclType(WEBMAILACL_ACL_TYPE_S);
        acl.setTargetType(WEBMAILACL_TARGET_TYPE_G);
        ;
        acl.setTargetId((int) gs.getGroupSendId().getValue());
        acl.setCreateDate(now);
        acl.setUpdateDate(now);
      }

      // 代理受信設定ユーザーを設定する。
      for (ALEipUser u : receiveMemberList) {
        AvzTMailSendRecvAcl acl = Database.create(AvzTMailSendRecvAcl.class);
        acl.setAccountId(accountId);
        acl.setAclType(WEBMAILACL_ACL_TYPE_R);
        acl.setTargetType(WEBMAILACL_TARGET_TYPE_U);
        acl.setTargetId((int) u.getUserId().getValue());
        acl.setCreateDate(now);
        acl.setUpdateDate(now);
      }

      // 代理送信設定ユーザーを設定する。
      for (ALEipUser u : sendMemberList) {
        AvzTMailSendRecvAcl acl = Database.create(AvzTMailSendRecvAcl.class);
        acl.setAccountId(accountId);
        acl.setAclType(WEBMAILACL_ACL_TYPE_S);
        acl.setTargetType(WEBMAILACL_TARGET_TYPE_U);
        acl.setTargetId((int) u.getUserId().getValue());
        acl.setCreateDate(now);
        acl.setUpdateDate(now);
      }
      // アカウントを更新
      Database.commit();

      // イベントログに保存
      ALEventlogFactoryService.getInstance().getEventlogHandler().log(
        mailAccount.getAccountId(),
        ALEventlogConstants.PORTLET_TYPE_WEBMAIL_ACCOUNT,
        mailAccount.getAccountName());

    } catch (Exception e) {
      Database.rollback();
      String msg = "署名・代理人設定の更新に失敗しました。[" + ALEipUtils.getBaseUser(loginuserid).getUserName() + "]";
      logger.error(msg, e);
      msgList.add(msg);
      return false;
    }
    return true;
  }

  /**
   * ※未使用
   */
  @Override
  protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
    // remove start
    // try {
    // int uid = ALEipUtils.getUserId(rundata);
    // int accountId = rundata.getParameters().getInt(WebMailUtils.ACCOUNT_ID);
    //
    // SelectQuery<EipMMailAccount> query =
    // Database.query(EipMMailAccount.class);
    //
    // Expression exp1 =
    // ExpressionFactory.matchExp(EipMMailAccount.USER_ID_PROPERTY, Integer
    // .valueOf(uid));
    // Expression exp2 =
    // ExpressionFactory.matchDbExp(
    // EipMMailAccount.ACCOUNT_ID_PK_COLUMN,
    // Integer.valueOf(accountId));
    //
    // EipMMailAccount account =
    // query.setQualifier(exp1.andExp(exp2)).fetchSingle();
    // if (account == null) {
    // msgList.add("指定したメールアカウントがデータベースに存在しません。");
    // return false;
    // }
    //
    // // ローカルフォルダを削除する．
    // ALMailHandler handler =
    // ALMailFactoryService.getInstance().getMailHandler();
    // handler.removeAccount(orgId, ALEipUtils.getUserId(rundata), accountId);
    //
    // Database.delete(account);
    // Database.commit();
    //
    // // セッション変数を削除する
    // WebMailUtils.clearWebMailAccountSession(rundata, context);
    //
    // // イベントログに保存
    // ALEventlogFactoryService.getInstance().getEventlogHandler().log(
    // account.getAccountId(),
    // ALEventlogConstants.PORTLET_TYPE_WEBMAIL_ACCOUNT,
    // account.getAccountName());
    // } catch (Throwable t) {
    // Database.rollback();
    // logger.error(t);
    // return false;
    // }
    // remove end
    return true;
  }

  /**
   * 設定画面初期表示処理、登録処理時のリクエストパラメータ取得を行なう。
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param msgList
   *            エラーメッセージリスト
   * @return 処理結果(正常：true、異常:false)
   * @see com.aimluck.eip.common.ALAbstractFormData#setFormData(org.apache.turbine
   *      .util.RunData, org.apache.velocity.context.Context,
   *      java.util.ArrayList)
   */
  @Override
  protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {

    boolean res = super.setFormData(rundata, context, msgList);
    if (res) {
      if (ALEipConstants.MODE_UPDATE.equals(getMode())) {
        try {
          // 代理送信設定ユーザー情報リストを取得する。
          String[] send_member_ids = rundata.getParameters().getStrings("send_member_to");
          if (send_member_ids != null && send_member_ids.length != 0) {
            SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inExp(TurbineUser.LOGIN_NAME_PROPERTY, send_member_ids);
            query.setQualifier(exp);
            List<ALEipUser> tmp = ALEipUtils.getUsersFromSelectQuery(query);
            for (ALEipUser u : tmp) {
              sendMemberList.add(u);
            }
          }

          // 代理受信設定ユーザー情報リストを取得する。
          String[] receive_member_ids = rundata.getParameters().getStrings("receive_member_to");
          if (receive_member_ids != null && receive_member_ids.length != 0) {
            SelectQuery<TurbineUser> query = Database.query(TurbineUser.class);
            Expression exp = ExpressionFactory.inExp(TurbineUser.LOGIN_NAME_PROPERTY, receive_member_ids);
            query.setQualifier(exp);
            List<ALEipUser> tmp = ALEipUtils.getUsersFromSelectQuery(query);
            for (ALEipUser u : tmp) {
              receiveMemberList.add(u);
            }
          }

          // 代理送信設定グループ送信リストを取得する。
          String[] groupsend_ids = rundata.getParameters().getStrings("groupsend_to");
          if (groupsend_ids != null && groupsend_ids.length != 0) {

            for (String id : groupsend_ids) {
              ALEipGroupSend tmp = ALEipUtils.getGroupSend(Integer.parseInt(id));
              groupSendList.add(tmp);
            }
          }

        } catch (Exception e) {
          String msg = "署名・代理人設定の更新に失敗しました。[" + ALEipUtils.getBaseUser(loginuserid).getUserName() + "]";
          logger.error(msg, e);
          msgList.add(msg);
        }
      }
    }

    return res;
  }

  // remove start
  // /**
  // * @return
  // */
  // public ALStringField getAccountName() {
  // return account_name;
  // }
  //
  // /**
  // * @return
  // */
  // public ALStringField getAccountType() {
  // return account_type;
  // }
  //
  // /**
  // * @return
  // */
  // public ALDateTimeField getCreateDate() {
  // return create_date;
  // }
  //
  /**
   * @return
   */
  public ALNumberField getDelAtPop3Flg() {
    return del_at_pop3_flg;
  }

  /**
   * @return
   */
  public ALStringField getMailAddress() {
    return mail_address;
  }

  // /**
  // * @return
  // */
  // public ALStringField getMailUserName() {
  // return mail_user_name;
  // }
  //
  /**
   * @return
   */
  public ALNumberField getNonReceivedFlg() {
    return non_received_flg;
  }

  /**
   * @return
   */
  public ALStringField getPop3Password() {
    return pop3_password;
  }

  /**
   * @return
   */
  public ALNumberField getPop3Port() {
    return pop3_port;
  }

  /**
   * @return
   */
  public ALStringField getPop3serverName() {
    return pop3server_name;
  }

  /**
   * @return
   */
  public ALStringField getPop3userName() {
    return pop3user_name;
  }

  public ALStringField getSmtpserverName() {
    return smtpserver_name;
  }

  /**
   * @return
   */
  public ALNumberField getSmtpPort() {
    return smtp_port;
  }

  // remove end

  /**
   * 更新日取得
   * 
   * @return 更新日
   */
  public ALDateTimeField getUpdateDate() {
    return update_date;
  }

  // remove start
  // /**
  // * @return
  // */
  // public int getAccountId() {
  // return (int) account_id.getValue();
  // }
  //
  // public ALNumberField getAuthSendFlg() {
  // return auth_send_flg;
  // }
  //
  // public ALStringField getAuthSendUserId() {
  // return auth_send_user_id;
  // }
  //
  // public ALStringField getAuthSendUserPasswd() {
  // return auth_send_user_password;
  // }
  //
  // public ALNumberField getAuthReceiveFlg() {
  // return auth_receive_flag;
  // }
  //
  // public ALNumberField getDelAtPop3BeforeDaysFlg() {
  // return del_at_pop3_before_days_flg;
  // }
  //
  // public ALNumberField getDelAtPop3BeforeDays() {
  // return del_at_pop3_before_days;
  // }
  // remove end

  /**
   * 署名取得
   * 
   * @return 署名
   */
  public ALStringField getSignature() {
    return signature;
  }

  // remove start
  // public ALNumberField getSmtpEncryptionFlag() {
  // return smtp_encryption_flag;
  // }
  //
  // public ALNumberField getPop3EncryptionFlag() {
  // return pop3_encryption_flag;
  // }
  // remove end

  /**
   * 代理送信設定メンバーリストを取得します。
   * 
   * @return
   */
  public List<ALEipUser> getSendMemberList() {
    return sendMemberList;
  }

  /**
   * 代理受信設定メンバーリストを取得します。
   * 
   * @return
   */
  public List<ALEipUser> getReceiveMemberList() {
    return receiveMemberList;
  }

  /**
   * 代理送信設定グループ送信を取得します。
   * 
   * @return
   */
  public List<ALEipGroupSend> getGroupSendList() {
    return groupSendList;
  }

  // add start 2012.2.24 受入障害No.294
  /**
   * アカウント用途取得
   * 
   * @return アカウント用途種 通常:0 会議室:1
   */
  public ALStringField getAccountUsage() {
    return account_usage;
  }

  // add end

  public boolean isMask() {
    return JetspeedResources.getBoolean("aipo.mask_account_setting", false);
  }

}
