/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.webmail;

import java.util.List;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTMailSend;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMail;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.util.WebMailUtils;

/**
 * 複数のWebメールを未読に戻すクラスです。 <br />
 */
public class WebMailMultiUnread extends ALAbstractCheckList {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(WebMailMultiUnread.class.getName());

  /**
   * 指定されたメールを未読に戻します。<BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @param values
   *            対象メールIDリスト
   * @param msgList
   *            エラーメッセージリスト
   * @return true:処理成功 false:処理失敗
   * @see com.aimluck.eip.common.ALAbstractCheckList#action(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList,
   *      java.util.ArrayList)
   */
  @Override
  protected boolean action(RunData rundata, Context context,
      List<String> values, List<String> msgList) {
    int accountId = -1;
    int userId = ALEipUtils.getUserId(rundata);
    EipMMailAccount account;

    // 現在処理中のタブ（受信トレイor送信トレイ）
    String currentTab = ALEipUtils.getTemp(rundata, context, "tab");
    if (currentTab == null || "".equals(currentTab)) {
      return false;
    }

    try {
      accountId =
        Integer.parseInt(ALEipUtils.getTemp(
          rundata,
          context,
          WebMailUtils.ACCOUNT_ID));
      account = ALMailUtils.getMailAccount(userId, accountId);

      if (accountId < 0 || account == null) {
        return false;
      }

      // 未読に戻す
      // 受信トレイ
      if (WebMailUtils.TAB_RECEIVE.equals(currentTab)) {
        SelectQuery<EipTMail> query = Database.query(EipTMail.class);
        Expression exp =
          ExpressionFactory.inDbExp(EipTMail.MAIL_ID_PK_COLUMN, values);

        List<EipTMail> mailList = query.setQualifier(exp).fetchList();
        for (EipTMail mail : mailList) {
          mail.setReadFlg("F");
        }
      } else {
        // 送信トレイ
        SelectQuery<AvzTMailSend> query = Database.query(AvzTMailSend.class);
        Expression exp =
          ExpressionFactory.inDbExp(AvzTMailSend.MAIL_ID_PK_COLUMN, values);

        List<AvzTMailSend> mailList = query.setQualifier(exp).fetchList();
        for (AvzTMailSend mail : mailList) {
          mail.setReadFlg("F");
        }
      }
      Database.commit();

      return true;
    } catch (Throwable t) {
      Database.rollback();
      String msg = "メール未読戻しに失敗しました。";
      logger.error(msg, t);
      msgList.add(msg);
      return false;
    }
  }

}
